/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.java.decompiler.modules.decompiler.IfHelper;
import org.jetbrains.java.decompiler.modules.decompiler.SequenceHelper;
import org.jetbrains.java.decompiler.modules.decompiler.StatEdge;
import org.jetbrains.java.decompiler.modules.decompiler.ValidationHelper;
import org.jetbrains.java.decompiler.modules.decompiler.exps.AssignmentExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.ConstExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.FunctionExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.VarExprent;
import org.jetbrains.java.decompiler.modules.decompiler.stats.BasicBlockStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.IfStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.RootStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarVersionPair;
import org.jetbrains.java.decompiler.struct.gen.VarType;

public final class IfPatternMatchProcessor {
    public static boolean matchInstanceof(RootStatement root) {
        boolean res = IfPatternMatchProcessor.matchInstanceofRec(root, root);
        if (res) {
            ValidationHelper.validateStatement(root);
            if (!IfHelper.mergeAllIfs(root)) {
                SequenceHelper.condenseSequences(root);
            }
        }
        return res;
    }

    private static boolean matchInstanceofRec(Statement statement, RootStatement root) {
        boolean res = false;
        for (Statement stat : statement.getStats()) {
            if (!IfPatternMatchProcessor.matchInstanceofRec(stat, root)) continue;
            res = true;
        }
        if (statement instanceof IfStatement) {
            res |= IfPatternMatchProcessor.handleIf((IfStatement)statement, root);
        }
        return res;
    }

    private static boolean handleIf(IfStatement statement, RootStatement root) {
        Exprent condition = statement.getHeadexprent().getCondition();
        Exprent lastIfTrue = IfPatternMatchProcessor.getLastExprentWhen(condition, true, true);
        Exprent lastIfFalse = IfPatternMatchProcessor.getLastExprentWhen(condition, false, true);
        boolean updated = false;
        if (lastIfTrue != null && IfPatternMatchProcessor.checkBranch(lastIfTrue, statement, statement.getIfEdge().getDestination(), root)) {
            updated = true;
            statement.fixIfInvariantEmptyIfBranch();
        }
        if (!updated && lastIfFalse != null) {
            if (statement.getElseEdge() != null) {
                if (IfPatternMatchProcessor.checkBranch(lastIfFalse, statement, statement.getElseEdge().getDestination(), root)) {
                    updated = true;
                    statement.fixIfInvariantEmptyElseBranch();
                }
            } else {
                List<StatEdge> allSuc = statement.getAllSuccessorEdges();
                if (allSuc.size() == 1 && IfPatternMatchProcessor.checkBranch(lastIfFalse, statement, allSuc.get(0).getDestination(), root)) {
                    updated = true;
                }
            }
        }
        return updated;
    }

    private static boolean checkBranch(Exprent exprent, IfStatement statement, Statement branch, RootStatement root) {
        Exprent last;
        if (!(exprent instanceof FunctionExprent) || branch.getAllPredecessorEdges().size() != 1) {
            return false;
        }
        FunctionExprent iof = (FunctionExprent)exprent;
        if (iof.getFuncType() != FunctionExprent.FunctionType.INSTANCEOF || iof.getLstOperands().size() != 2) {
            return false;
        }
        Exprent source = iof.getLstOperands().get(0);
        if ((source.getExprentUse() & 1) == 0) {
            return false;
        }
        Exprent target = iof.getLstOperands().get(1);
        BasicBlockStatement head = branch.getBasichead();
        if (head.getExprents() == null || head.getExprents().isEmpty()) {
            return false;
        }
        Exprent first = head.getExprents().get(0);
        if (!(first instanceof AssignmentExprent)) {
            return false;
        }
        Exprent left = first.getAllExprents().get(0);
        Exprent right = first.getAllExprents().get(1);
        if (!(right instanceof FunctionExprent)) {
            return false;
        }
        if (((FunctionExprent)right).getFuncType() != FunctionExprent.FunctionType.CAST) {
            return false;
        }
        Exprent casted = right.getAllExprents().get(0);
        if (!source.equals(casted)) {
            return false;
        }
        if (!(left instanceof VarExprent) || !target.getExprType().equals(left.getExprType())) {
            return false;
        }
        ArrayList<VarVersionPair> vvs = new ArrayList<VarVersionPair>();
        IfPatternMatchProcessor.findVarsInPredecessors(vvs, branch);
        VarVersionPair var = ((VarExprent)left).getVarVersionPair();
        for (VarVersionPair vv : vvs) {
            if (var.var != vv.var) continue;
            return false;
        }
        VarType storeType = left.getInferredExprType(null);
        iof.getLstOperands().add(2, left);
        head.getExprents().remove(0);
        if (storeType.isGeneric()) {
            iof.getLstOperands().set(1, new ConstExprent(storeType, null, iof.getLstOperands().get((int)1).bytecode));
        }
        statement.setPatternMatched(true);
        BasicBlockStatement before = statement.getBasichead();
        if (before.getExprents() != null && before.getExprents().size() > 0 && (last = before.getExprents().get(before.getExprents().size() - 1)) instanceof AssignmentExprent && source instanceof VarExprent) {
            Exprent stored = last.getAllExprents().get(0);
            Exprent method = last.getAllExprents().get(1);
            VarExprent checked = (VarExprent)source;
            if (!(method instanceof FunctionExprent && ((FunctionExprent)method).getFuncType() == FunctionExprent.FunctionType.CAST || !checked.equals(stored) || checked.isVarReferenced(root, (VarExprent)stored))) {
                iof.getLstOperands().set(0, last.getAllExprents().get(1));
                before.getExprents().remove(before.getExprents().size() - 1);
            }
        }
        return true;
    }

    private static void findVarsInPredecessors(List<VarVersionPair> vvs, Statement root) {
        ArrayDeque<Statement> stack = new ArrayDeque<Statement>();
        HashSet<Statement> seen = new HashSet<Statement>();
        stack.add(root);
        while (!stack.isEmpty()) {
            Statement st = (Statement)stack.pop();
            if (!seen.add(st)) continue;
            if (st.getParent() instanceof IfStatement || st instanceof IfStatement) {
                stack.add(st.getParent());
            }
            for (StatEdge pred : st.getAllPredecessorEdges()) {
                Statement stat = pred.getSource();
                stack.add(stat);
                if (stat == root || stat.getExprents() == null) continue;
                for (Exprent exprent : stat.getExprents()) {
                    AssignmentExprent assignment;
                    if (!(exprent instanceof AssignmentExprent) || !((assignment = (AssignmentExprent)exprent).getLeft() instanceof VarExprent)) continue;
                    vvs.add(((VarExprent)assignment.getLeft()).getVarVersionPair());
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Exprent getLastExprentWhen(Exprent base, boolean ifTrue, boolean onlyIfTrue) {
        switch (base.type) {
            case FUNCTION: {
                FunctionExprent func = (FunctionExprent)base;
                switch (func.getFuncType()) {
                    case BOOLEAN_AND: {
                        if (!ifTrue) break;
                        return IfPatternMatchProcessor.getLastExprentWhen(func.getLstOperands().get(1), true, onlyIfTrue);
                    }
                    case BOOLEAN_OR: {
                        if (ifTrue) break;
                        return IfPatternMatchProcessor.getLastExprentWhen(func.getLstOperands().get(1), false, onlyIfTrue);
                    }
                    case BOOL_NOT: {
                        boolean bl;
                        if (!ifTrue) {
                            bl = true;
                            return IfPatternMatchProcessor.getLastExprentWhen(func.getLstOperands().get(0), bl, onlyIfTrue);
                        }
                        bl = false;
                        return IfPatternMatchProcessor.getLastExprentWhen(func.getLstOperands().get(0), bl, onlyIfTrue);
                    }
                    case EQ: {
                        boolean bl;
                        ConstExprent constExprent;
                        Exprent rhs = func.getLstOperands().get(1);
                        if (rhs.type != Exprent.Type.CONST || (constExprent = (ConstExprent)rhs).getConstType() != VarType.VARTYPE_BOOLEAN) break;
                        if (constExprent.getIntValue() != 0) return IfPatternMatchProcessor.getLastExprentWhen(func.getLstOperands().get(0), ifTrue, onlyIfTrue);
                        if (!ifTrue) {
                            bl = true;
                            return IfPatternMatchProcessor.getLastExprentWhen(func.getLstOperands().get(0), bl, onlyIfTrue);
                        }
                        bl = false;
                        return IfPatternMatchProcessor.getLastExprentWhen(func.getLstOperands().get(0), bl, onlyIfTrue);
                    }
                    case NE: {
                        boolean bl;
                        ConstExprent constExprent;
                        Exprent rhs = func.getLstOperands().get(1);
                        if (rhs.type != Exprent.Type.CONST || (constExprent = (ConstExprent)rhs).getConstType() != VarType.VARTYPE_BOOLEAN) break;
                        if (constExprent.getIntValue() == 0) {
                            return IfPatternMatchProcessor.getLastExprentWhen(func.getLstOperands().get(0), ifTrue, onlyIfTrue);
                        }
                        if (!ifTrue) {
                            bl = true;
                            return IfPatternMatchProcessor.getLastExprentWhen(func.getLstOperands().get(0), bl, onlyIfTrue);
                        }
                        bl = false;
                        return IfPatternMatchProcessor.getLastExprentWhen(func.getLstOperands().get(0), bl, onlyIfTrue);
                    }
                }
                break;
            }
        }
        if (!onlyIfTrue) return base;
        if (ifTrue) return base;
        return null;
    }
}

