/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.jetbrains.java.decompiler.modules.decompiler.MergeHelper;
import org.jetbrains.java.decompiler.modules.decompiler.StatEdge;
import org.jetbrains.java.decompiler.modules.decompiler.exps.ExitExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.VarExprent;
import org.jetbrains.java.decompiler.modules.decompiler.flow.DirectEdge;
import org.jetbrains.java.decompiler.modules.decompiler.flow.DirectEdgeType;
import org.jetbrains.java.decompiler.modules.decompiler.flow.DirectGraph;
import org.jetbrains.java.decompiler.modules.decompiler.flow.DirectNode;
import org.jetbrains.java.decompiler.modules.decompiler.flow.DirectNodeType;
import org.jetbrains.java.decompiler.modules.decompiler.flow.FlattenStatementsHelper;
import org.jetbrains.java.decompiler.modules.decompiler.stats.BasicBlockStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.CatchStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.DoStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.DummyExitStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.IfStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.RootStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarVersionNode;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarVersionPair;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarVersionsGraph;
import org.jetbrains.java.decompiler.struct.gen.VarType;
import org.jetbrains.java.decompiler.util.DotExporter;
import org.jetbrains.java.decompiler.util.collections.ListStack;
import org.jetbrains.java.decompiler.util.collections.VBStyleCollection;

public final class ValidationHelper {
    public static final boolean VALIDATE = System.getProperty("VALIDATE_DECOMPILED_CODE", "false").equals("true");

    public static void validateStatement(RootStatement statement) {
        DirectGraph directGraph;
        if (!VALIDATE) {
            return;
        }
        VBStyleCollection<Statement, Integer> statements = new VBStyleCollection<Statement, Integer>();
        LinkedList<Statement> stack = new LinkedList<Statement>();
        stack.push(statement.getDummyExit());
        stack.push(statement);
        while (!stack.isEmpty()) {
            Statement stat = (Statement)stack.pop();
            statements.putWithKey(stat, stat.id);
            stack.addAll(stat.getStats());
        }
        for (Statement stat : statements) {
            for (StatEdge edge : stat.getAllSuccessorEdges()) {
                ValidationHelper.validateEdgeContext(statements, stat, edge);
            }
            for (StatEdge edge : stat.getAllPredecessorEdges()) {
                ValidationHelper.validateEdgeContext(statements, stat, edge);
            }
            for (StatEdge edge : stat.getLabelEdges()) {
                ValidationHelper.validateEdgeContext(statements, stat, edge);
            }
            if (stat.getExprents() != null) {
                for (Exprent exprent : stat.getExprents()) {
                    ValidationHelper.validateExprent(exprent);
                }
            }
            if (!(statements.contains(stat.getFirst()) || stat instanceof DummyExitStatement || stat instanceof BasicBlockStatement)) {
                throw new IllegalStateException("Non-existing first statement: [" + stat + "] " + stat.getFirst());
            }
            for (Statement statStat : stat.getStats()) {
                if (statStat.getParent() == stat) continue;
                throw new IllegalStateException("Statement parent is not set correctly: " + statStat);
            }
            ValidationHelper.validateSingleStatement(stat);
        }
        try {
            FlattenStatementsHelper flatten = new FlattenStatementsHelper();
            directGraph = flatten.buildDirectGraph(statement);
        }
        catch (Throwable e) {
            throw new IllegalStateException("Failed to build direct graph", e);
        }
        ValidationHelper.validateDGraph(directGraph, statement);
    }

    private static void validateEdgeContext(VBStyleCollection<Statement, Integer> statements, Statement stat, StatEdge edge) {
        if (!statements.contains(edge.getSource())) {
            throw new IllegalStateException("Edge pointing from non-existing statement: [" + stat + "] " + edge);
        }
        if (!statements.contains(edge.getDestination())) {
            throw new IllegalStateException("Edge pointing to non-existing statement: [" + stat + "] " + edge);
        }
        if (edge.closure != null && !statements.contains(edge.closure)) {
            throw new IllegalStateException("Edge with non-existing closure: [" + stat + "] " + edge);
        }
        ValidationHelper.validateEdge(edge);
    }

    public static void validateEdge(StatEdge edge) {
        if (!VALIDATE) {
            return;
        }
        if (!edge.labeled || edge.closure == null) {
            // empty if block
        }
        if (!ValidationHelper.isSuccessor(edge.getSource(), edge)) {
            throw new IllegalStateException("Edge pointing from statement but it isn't a successor: " + edge.getSource() + " " + edge);
        }
        if (!edge.getDestination().getAllPredecessorEdges().contains(edge)) {
            throw new IllegalStateException("Edge pointing to statement but it isn't a predecessor: " + edge);
        }
        if (!edge.labeled || edge.getType() != 4 || !edge.getDestination().getLabelEdges().contains(edge)) {
            // empty if block
        }
        switch (edge.getType()) {
            case 1: {
                if (edge.closure == null) break;
                break;
            }
            case 4: {
                if (edge.closure == null) {
                    throw new IllegalStateException("Break edge with break type, but no closure: " + edge);
                }
                if (edge.closure.type == Statement.StatementType.BASIC_BLOCK) {
                    throw new IllegalStateException("Break edge closure to basic block: " + edge);
                }
                if (edge.getSource() == edge.closure && !edge.phantomContinue) {
                    throw new IllegalStateException("Break edge with closure pointing to itself: " + edge);
                }
                if (edge.getDestination() == edge.closure) {
                    throw new IllegalStateException("Break edge with closure pointing to itself: " + edge);
                }
                if (edge.getSource() == edge.getDestination()) {
                    throw new IllegalStateException("Break edge pointing to itself: " + edge);
                }
                if (edge.getDestination() instanceof DummyExitStatement || MergeHelper.isDirectPath(edge.closure, edge.getDestination())) break;
                throw new IllegalStateException("Break edge with closure with invalid direct path: " + edge);
            }
            case 8: {
                if (edge.closure == null) {
                    throw new IllegalStateException("Continue edge with continue type, but no closure: " + edge);
                }
                if (edge.closure != edge.getDestination()) {
                    throw new IllegalStateException("Continue edge with closure pointing to different destination: " + edge);
                }
                if (edge.getDestination() instanceof DoStatement) break;
                throw new IllegalStateException("Continue edge where closure isn't pointing to a do: " + edge);
            }
            case 32: {
                if (edge.closure == null) {
                    throw new IllegalStateException("Finally exit edge with finally exit type, but no closure: " + edge);
                }
                if (edge.getDestination() instanceof DummyExitStatement) break;
                throw new IllegalStateException("Finally exit edge where closure isn't pointing to the dummy exit: " + edge);
            }
        }
    }

    public static void validateSingleStatement(Statement stat) {
        if (!VALIDATE) {
            return;
        }
        switch (stat.type) {
            case IF: {
                ValidationHelper.validateIfStatement((IfStatement)stat);
                break;
            }
            case TRY_CATCH: {
                ValidationHelper.validateTrycatchStatement((CatchStatement)stat);
            }
        }
    }

    public static void validateTrycatchStatement(CatchStatement catchStat) {
        if (catchStat.getStats().size() == 1 && catchStat.getResources().isEmpty()) {
            throw new IllegalStateException("Try statement with single statement: " + catchStat);
        }
    }

    public static void validateIfStatement(IfStatement ifStat) {
        if (!VALIDATE) {
            return;
        }
        VBStyleCollection<Statement, Integer> stats = ifStat.getStats();
        if (ifStat.getFirst() == null) {
            throw new IllegalStateException("If statement without a first statement: " + ifStat);
        }
        if (!stats.contains(ifStat.getFirst())) {
            throw new IllegalStateException("If statement does not contain own first statement: " + ifStat);
        }
        if (ifStat.getIfEdge() == null) {
            throw new IllegalStateException("If statement without an if edge: " + ifStat);
        }
        if (ifStat.getIfstat() != null) {
            if (ifStat.getIfEdge().getDestination() != ifStat.getIfstat()) {
                throw new IllegalStateException("If statement if edge destination is not ifStat: " + ifStat + " (destination is: " + ifStat.getIfEdge().getDestination() + " but ifStat is: " + ifStat.getIfstat() + ")");
            }
            if (!stats.contains(ifStat.getIfstat())) {
                throw new IllegalStateException("If statement does not contain own ifStat: " + ifStat);
            }
        }
        if (ifStat.iftype == 0) {
            if (ifStat.getElseEdge() != null) {
                throw new IllegalStateException("If statement with unexpected else edge: " + ifStat);
            }
            if (ifStat.getSuccessorEdges(0x40000000).isEmpty()) {
                throw new IllegalStateException("If statement with no else edge and no successors: " + ifStat);
            }
            if (ifStat.getSuccessorEdges(0x40000000).size() > 1) {
                throw new IllegalStateException("If statement with more than one successor: " + ifStat + " (successors: " + ifStat.getSuccessorEdges(0x40000000) + ")");
            }
        } else if (ifStat.iftype == 1) {
            if (ifStat.getElseEdge() == null) {
                throw new IllegalStateException("IfElse statement without else edge: " + ifStat);
            }
            if (ifStat.getIfstat() == null) {
                throw new IllegalStateException("IfElse statement without ifStat: " + ifStat);
            }
            if (ifStat.getElsestat() == null) {
                throw new IllegalStateException("IfElse statement without elseStat: " + ifStat);
            }
            if (ifStat.getElseEdge().getDestination() != ifStat.getElsestat()) {
                throw new IllegalStateException("IfElse statement else edge destination is not elseStat: " + ifStat);
            }
            if (!stats.contains(ifStat.getElsestat())) {
                throw new IllegalStateException("IfElse statement does not contain own elseStat: " + ifStat);
            }
        } else {
            throw new IllegalStateException("Unknown if type: " + ifStat);
        }
        if (ifStat.getIfEdge() != null && ifStat.getIfEdge().getSource() != ifStat.getFirst()) {
            throw new IllegalStateException("If statement if edge source is not first statement: [" + ifStat.getIfEdge() + "] " + ifStat + " (source is: " + ifStat.getIfEdge().getSource() + " but first is: " + ifStat.getFirst() + ")");
        }
        if (ifStat.getElseEdge() != null && ifStat.getElseEdge().getSource() != ifStat.getFirst()) {
            throw new IllegalStateException("IfElse statement else edge source is not first statement: " + ifStat + " (elseEdge: " + ifStat.getElseEdge() + ")");
        }
        if (stats.size() > 3) {
            throw new IllegalStateException("If statement with more than 3 sub statements: " + ifStat);
        }
        for (Statement stat : stats) {
            if (stat == ifStat.getFirst() || stat == ifStat.getIfstat() || stat == ifStat.getElsestat()) continue;
            throw new IllegalStateException("If statement contains unknown sub statement: " + ifStat + " (subStatement: " + stat + ")");
        }
        for (StatEdge edge : ifStat.getFirst().getSuccessorEdges(0x40000000)) {
            if (ifStat.getIfEdge() == edge || ifStat.getElseEdge() == edge) continue;
            throw new IllegalStateException("If statement first contains unknown successor edge: " + ifStat + " (edge: " + edge + ")");
        }
    }

    public static void validateDGraph(DirectGraph graph, RootStatement root) {
        if (!VALIDATE) {
            return;
        }
        try {
            HashSet inaccessibleNodes = new HashSet(graph.nodes);
            ListStack<DirectNode> stack = new ListStack<DirectNode>();
            stack.push(graph.first);
            inaccessibleNodes.remove(graph.first);
            while (!stack.isEmpty()) {
                DirectNode node = (DirectNode)stack.pop();
                for (DirectEdge pred : node.getPredecessors(DirectEdgeType.REGULAR)) {
                    if (pred.getSource().getSuccessors(DirectEdgeType.REGULAR).contains(pred)) continue;
                    throw new IllegalStateException("Predecessor " + pred + " does not have " + (DirectNode)node + " as a successor");
                }
                for (DirectEdge succ : node.getSuccessors(DirectEdgeType.REGULAR)) {
                    if (!succ.getDestination().getPredecessors(DirectEdgeType.REGULAR).contains(succ)) {
                        throw new IllegalStateException("Successor " + succ + " does not have " + (DirectNode)node + " as a predecessor");
                    }
                    if (!inaccessibleNodes.remove(succ.getDestination())) continue;
                    stack.push(succ.getDestination());
                }
            }
            if (!inaccessibleNodes.isEmpty()) {
                for (DirectNode inaccessibleNode : inaccessibleNodes) {
                    if (inaccessibleNode.type == DirectNodeType.FINALLY_END) continue;
                    throw new IllegalStateException("Inaccessible direct graph nodes: " + inaccessibleNodes);
                }
            }
            HashMap<ID<Exprent>, DirectNode> allExprents = new HashMap<ID<Exprent>, DirectNode>();
            for (DirectNode node : graph.nodes) {
                for (Exprent exprent : node.exprents) {
                    for (Exprent subExprent : exprent.getAllExprents(true, true)) {
                        ID<Exprent> key = new ID<Exprent>(subExprent);
                        if (allExprents.containsKey(key)) {
                            throw new IllegalStateException("Duplicated exprent: " + subExprent + " (Sub exprent of: " + exprent + ") in dgraph. Appears in both node " + node.id + " and node " + ((DirectNode)allExprents.get(key)).id + "!");
                        }
                        allExprents.put(key, node);
                    }
                }
            }
        }
        catch (Throwable e) {
            DotExporter.errorToDotFile(graph, root.mt, "erroring_dgraph");
            throw e;
        }
    }

    public static void validateVars(DirectGraph dgraph, RootStatement root, Predicate<VarExprent> predicate, String message) {
        if (!VALIDATE) {
            return;
        }
        try {
            for (DirectNode node : dgraph.nodes) {
                if (node.exprents == null) continue;
                for (Exprent exprent : node.exprents) {
                    for (Exprent sub : exprent.getAllExprents(true, true)) {
                        VarExprent var;
                        if (!(sub instanceof VarExprent) || predicate.test(var = (VarExprent)sub)) continue;
                        System.out.println(root.toJava().convertToStringAndAllowDataDiscard());
                        throw new IllegalStateException(message + ": " + var.getIndex() + "_" + var.getVersion() + " " + var.getVarType());
                    }
                }
            }
        }
        catch (Throwable e) {
            DotExporter.errorToDotFile(dgraph, root.mt, "erroring_dgraph");
            throw e;
        }
    }

    public static void notNull(Object o) {
        if (!VALIDATE) {
            return;
        }
        if (o == null) {
            throw new NullPointerException("Validation: null object");
        }
    }

    public static void validateExitExprent(ExitExprent exit) {
        if (!VALIDATE) {
            return;
        }
        if (exit.getExitType() == ExitExprent.Type.RETURN) {
            if (exit.getRetType().equals(VarType.VARTYPE_VOID)) {
                if (exit.getValue() != null) {
                    throw new IllegalStateException("Void return with value: " + exit);
                }
            } else if (exit.getValue() == null) {
                throw new IllegalStateException("Non-void return without value: " + exit);
            }
        }
        for (Exprent subExprents : exit.getAllExprents()) {
            ValidationHelper.validateExprent(subExprents);
        }
    }

    public static void validateExprent(Exprent exprent) {
        if (!VALIDATE) {
            return;
        }
        switch (exprent.type) {
            case EXIT: {
                ValidationHelper.validateExitExprent((ExitExprent)exprent);
                break;
            }
            default: {
                for (Exprent subExprents : exprent.getAllExprents()) {
                    ValidationHelper.validateExprent(subExprents);
                }
            }
        }
    }

    public static void successorsExist(Statement stat) {
        if (!VALIDATE) {
            return;
        }
        if (stat.getAllSuccessorEdges().isEmpty()) {
            throw new IllegalStateException("Statement has no successors: " + stat);
        }
    }

    public static void oneSuccessor(Statement stat) {
        if (!VALIDATE) {
            return;
        }
        if (stat.getAllSuccessorEdges().size() != 1) {
            throw new IllegalStateException("Statement has more than one successor: [" + stat + "] " + stat.getAllSuccessorEdges());
        }
    }

    private static boolean isSuccessor(Statement source, StatEdge edge) {
        IfStatement ifstat;
        if (source.getAllSuccessorEdges().contains(edge)) {
            return true;
        }
        return source.getParent() instanceof IfStatement && (ifstat = (IfStatement)source.getParent()).getFirst() == source && (edge == ifstat.getIfEdge() || edge == ifstat.getElseEdge());
    }

    public static void validateTrue(boolean condition, String message) {
        if (VALIDATE && !condition) {
            throw new IllegalStateException("Validation failed: " + message);
        }
    }

    public static void assertTrue(boolean condition, String message) {
        if (!condition) {
            throw new IllegalStateException("Assertion failed: " + message);
        }
    }

    public static void validateVarVersionsGraph(VarVersionsGraph graph, RootStatement statement, Map<VarVersionPair, VarVersionPair> varAssignmentMap) {
        if (!VALIDATE) {
            return;
        }
        HashSet<VarVersionNode> roots = new HashSet<VarVersionNode>();
        for (VarVersionNode node : graph.nodes) {
            if (!node.predecessors.isEmpty()) continue;
            roots.add(node);
        }
        Set<VarVersionNode> reached = VarVersionsGraph.rootReachability(roots);
        if (graph.nodes.size() != reached.size()) {
            DotExporter.errorToDotFile(graph, statement.mt, "erroring_varVersionGraph", varAssignmentMap);
            throw new IllegalStateException("Highly cyclic varversions graph!");
        }
    }

    private static class ID<T> {
        private final T obj;

        private ID(T obj) {
            this.obj = obj;
        }

        public int hashCode() {
            return System.identityHashCode(this.obj);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ID id = (ID)o;
            return this.obj == id.obj;
        }
    }
}

