/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.vars;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.modules.decompiler.ValidationHelper;
import org.jetbrains.java.decompiler.modules.decompiler.exps.AssignmentExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.ConstExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.FunctionExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.VarExprent;
import org.jetbrains.java.decompiler.modules.decompiler.flow.DirectGraph;
import org.jetbrains.java.decompiler.modules.decompiler.stats.RootStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;
import org.jetbrains.java.decompiler.modules.decompiler.vars.CheckTypesResult;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarVersionPair;
import org.jetbrains.java.decompiler.struct.StructClass;
import org.jetbrains.java.decompiler.struct.StructMethod;
import org.jetbrains.java.decompiler.struct.gen.CodeType;
import org.jetbrains.java.decompiler.struct.gen.MethodDescriptor;
import org.jetbrains.java.decompiler.struct.gen.TypeFamily;
import org.jetbrains.java.decompiler.struct.gen.VarType;

public class VarTypeProcessor {
    private final StructMethod method;
    private final MethodDescriptor methodDescriptor;
    private final Map<VarVersionPair, VarType> mapExprentMinTypes = new HashMap<VarVersionPair, VarType>();
    private final Map<VarVersionPair, VarType> mapExprentMaxTypes = new HashMap<VarVersionPair, VarType>();
    private final Map<VarVersionPair, FinalType> mapFinalVars = new HashMap<VarVersionPair, FinalType>();

    public VarTypeProcessor(StructMethod mt, MethodDescriptor md) {
        this.method = mt;
        this.methodDescriptor = md;
    }

    public void calculateVarTypes(RootStatement root, DirectGraph graph) {
        this.setInitVars(root);
        VarTypeProcessor.resetExprentTypes(graph);
        while (!this.processVarTypes(graph)) {
        }
        ValidationHelper.validateVars(graph, root, var -> var.getVarType() != VarType.VARTYPE_UNKNOWN, "Var type not set!");
    }

    private void setInitVars(RootStatement root) {
        boolean thisVar = !this.method.hasModifier(8);
        MethodDescriptor md = this.methodDescriptor;
        if (thisVar) {
            StructClass cl = DecompilerContext.getContextProperty(DecompilerContext.CURRENT_CLASS);
            VarType clType = new VarType(CodeType.OBJECT, 0, cl.qualifiedName);
            this.mapExprentMinTypes.put(new VarVersionPair(0, 1), clType);
            this.mapExprentMaxTypes.put(new VarVersionPair(0, 1), clType);
        }
        int varIndex = 0;
        for (int i = 0; i < md.params.length; ++i) {
            this.mapExprentMinTypes.put(new VarVersionPair(varIndex + (thisVar ? 1 : 0), 1), md.params[i]);
            this.mapExprentMaxTypes.put(new VarVersionPair(varIndex + (thisVar ? 1 : 0), 1), md.params[i]);
            varIndex += md.params[i].stackSize;
        }
        LinkedList<RootStatement> stack = new LinkedList<RootStatement>();
        stack.add(root);
        while (!stack.isEmpty()) {
            Statement stat = (Statement)stack.removeFirst();
            List<VarExprent> vars = stat.getImplicitlyDefinedVars();
            if (vars != null) {
                for (VarExprent var : vars) {
                    this.mapExprentMinTypes.put(new VarVersionPair(var.getIndex(), 1), var.getVarType());
                    this.mapExprentMaxTypes.put(new VarVersionPair(var.getIndex(), 1), var.getVarType());
                }
            }
            stack.addAll(stat.getStats());
        }
    }

    private static void resetExprentTypes(DirectGraph graph) {
        graph.iterateExprents(exprent -> {
            List<Exprent> lst = exprent.getAllExprents(true);
            lst.add(exprent);
            for (Exprent expr : lst) {
                if (expr instanceof VarExprent) {
                    VarExprent ve = (VarExprent)expr;
                    if (ve.getLVT() != null) {
                        ve.setVarType(ve.getLVT().getVarType());
                        continue;
                    }
                    ve.setVarType(VarType.VARTYPE_UNKNOWN);
                    continue;
                }
                if (!(expr instanceof ConstExprent)) continue;
                ConstExprent constExpr = (ConstExprent)expr;
                if (constExpr.getConstType().typeFamily != TypeFamily.INTEGER) continue;
                constExpr.setConstType(new ConstExprent(constExpr.getIntValue(), constExpr.isBoolPermitted(), null).getConstType());
            }
            return 0;
        });
    }

    private boolean processVarTypes(DirectGraph graph) {
        return graph.iterateExprents(exprent -> this.checkTypeExprent(exprent) ? 0 : 1);
    }

    private boolean checkTypeExprent(Exprent exprent) {
        for (Exprent expr : exprent.getAllExprents(true)) {
            if (this.checkTypeExpr(expr)) continue;
            return false;
        }
        return this.checkTypeExpr(exprent);
    }

    private boolean checkTypeExpr(Exprent exprent) {
        if (exprent instanceof ConstExprent) {
            VarVersionPair pair;
            ConstExprent constExpr = (ConstExprent)exprent;
            if (constExpr.getConstType().typeFamily.isLesserOrEqual(TypeFamily.INTEGER) && !this.mapExprentMinTypes.containsKey(pair = new VarVersionPair(constExpr.id, -1))) {
                this.mapExprentMinTypes.put(pair, constExpr.getConstType());
            }
        }
        CheckTypesResult result = exprent.checkExprTypeBounds();
        boolean res = true;
        if (result != null) {
            for (CheckTypesResult.ExprentTypePair entry : result.getLstMaxTypeExprents()) {
                if (entry.type.typeFamily == TypeFamily.OBJECT) continue;
                this.changeExprentType(entry.exprent, entry.type, 1);
            }
            for (CheckTypesResult.ExprentTypePair entry : result.getLstMinTypeExprents()) {
                res &= this.changeExprentType(entry.exprent, entry.type, 0);
            }
        }
        return res;
    }

    private boolean changeExprentType(Exprent exprent, VarType newType, int minMax) {
        switch (exprent.type) {
            case CONST: {
                VarType minInteger;
                ConstExprent constExpr = (ConstExprent)exprent;
                VarType constType = constExpr.getConstType();
                if (newType.typeFamily.isGreater(TypeFamily.INTEGER) || constType.typeFamily.isGreater(TypeFamily.INTEGER)) {
                    return true;
                }
                if (newType.typeFamily == TypeFamily.INTEGER && (minInteger = new ConstExprent((Integer)constExpr.getValue(), false, null).getConstType()).isStrictSuperset(newType)) {
                    newType = minInteger;
                }
                return this.changeVarExprentType(exprent, newType, minMax, new VarVersionPair(exprent.id, -1));
            }
            case VAR: {
                return this.changeVarExprentType(exprent, newType, minMax, new VarVersionPair((VarExprent)exprent));
            }
            case ASSIGNMENT: {
                return this.changeExprentType(((AssignmentExprent)exprent).getRight(), newType, minMax);
            }
            case FUNCTION: {
                return this.changeFunctionExprentType(newType, minMax, (FunctionExprent)exprent);
            }
        }
        return true;
    }

    private boolean changeVarExprentType(Exprent exprent, VarType newType, int minMax, VarVersionPair pair) {
        if (minMax == 0) {
            VarType newMinType;
            VarType currentMinType = this.mapExprentMinTypes.get(pair);
            if (currentMinType == null || newType.typeFamily.isGreater(currentMinType.typeFamily)) {
                newMinType = newType;
            } else {
                if (newType.typeFamily.isLesser(currentMinType.typeFamily)) {
                    return true;
                }
                newMinType = VarType.getCommonSupertype(currentMinType, newType);
            }
            this.mapExprentMinTypes.put(pair, newMinType);
            if (exprent instanceof ConstExprent) {
                ((ConstExprent)exprent).setConstType(newMinType);
            }
            if (currentMinType != null && (newMinType.typeFamily.isGreater(currentMinType.typeFamily) || newMinType.isStrictSuperset(currentMinType))) {
                return false;
            }
        } else {
            VarType newMaxType;
            VarType currentMaxType = this.mapExprentMaxTypes.get(pair);
            if (currentMaxType == null || newType.typeFamily.isLesser(currentMaxType.typeFamily)) {
                newMaxType = newType;
            } else {
                if (newType.typeFamily.isGreater(currentMaxType.typeFamily)) {
                    return true;
                }
                newMaxType = VarType.getCommonMinType(currentMaxType, newType);
            }
            this.mapExprentMaxTypes.put(pair, newMaxType);
        }
        return true;
    }

    private boolean changeFunctionExprentType(VarType newType, int minMax, FunctionExprent func) {
        int offset = 0;
        switch (func.getFuncType()) {
            case TERNARY: {
                ++offset;
            }
            case AND: 
            case OR: 
            case XOR: {
                return this.changeExprentType(func.getLstOperands().get(offset), newType, minMax) & this.changeExprentType(func.getLstOperands().get(offset + 1), newType, minMax);
            }
        }
        return true;
    }

    public Map<VarVersionPair, VarType> getMapExprentMaxTypes() {
        return this.mapExprentMaxTypes;
    }

    public Map<VarVersionPair, VarType> getMapExprentMinTypes() {
        return this.mapExprentMinTypes;
    }

    public Map<VarVersionPair, FinalType> getMapFinalVars() {
        return this.mapFinalVars;
    }

    public void setVarType(VarVersionPair pair, VarType type) {
        this.mapExprentMinTypes.put(pair, type);
    }

    public VarType getVarType(VarVersionPair pair) {
        return this.mapExprentMinTypes.get(pair);
    }

    public static enum FinalType {
        NON_FINAL,
        EXPLICIT_FINAL,
        FINAL;

    }
}

