/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.gui;

import cuchaz.enigma.Enigma;
import cuchaz.enigma.EnigmaProfile;
import cuchaz.enigma.EnigmaServices;
import cuchaz.enigma.gui.EditableType;
import cuchaz.enigma.gui.ExceptionIgnorer;
import cuchaz.enigma.gui.Gui;
import cuchaz.enigma.gui.GuiController;
import cuchaz.enigma.gui.config.Themes;
import cuchaz.enigma.gui.config.UiConfig;
import cuchaz.enigma.gui.dialog.CrashDialog;
import cuchaz.enigma.translation.mapping.serde.MappingFormat;
import cuchaz.enigma.utils.I18n;
import java.awt.Toolkit;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.ValueConverter;

public class Main {
    public static void main(String[] args) throws IOException {
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec jar = parser.accepts("jar", "Jar file to open at startup; if there are multiple jars, the order must be the same between all collab session members").withRequiredArg().withValuesConvertedBy(PathConverter.INSTANCE);
        ArgumentAcceptingOptionSpec library = parser.accepts("library", "The libraries for the input jar files").withRequiredArg().withValuesConvertedBy(PathConverter.INSTANCE);
        ArgumentAcceptingOptionSpec mappings = parser.accepts("mappings", "Mappings file to open at startup").withRequiredArg().withValuesConvertedBy(PathConverter.INSTANCE);
        ArgumentAcceptingOptionSpec profile = parser.accepts("profile", "Profile json to apply at startup").withRequiredArg().withValuesConvertedBy(PathConverter.INSTANCE);
        parser.acceptsAll(List.of("edit-all", "e"), "Enable editing everything");
        parser.acceptsAll(List.of("no-edit-all", "E"), "Disable editing everything");
        parser.acceptsAll(List.of("edit-classes", "c"), "Enable editing class names");
        parser.acceptsAll(List.of("no-edit-classes", "C"), "Disable editing class names");
        parser.acceptsAll(List.of("edit-methods", "m"), "Enable editing method names");
        parser.acceptsAll(List.of("no-edit-methods", "M"), "Disable editing method names");
        parser.acceptsAll(List.of("edit-fields", "f"), "Enable editing field names");
        parser.acceptsAll(List.of("no-edit-fields", "F"), "Disable editing field names");
        parser.acceptsAll(List.of("edit-parameters", "p"), "Enable editing parameter names");
        parser.acceptsAll(List.of("no-edit-parameters", "P"), "Disable editing parameter names");
        parser.acceptsAll(List.of("edit-locals"), "Enable editing local variable names");
        parser.acceptsAll(List.of("no-edit-locals"), "Disable editing local variable names");
        parser.acceptsAll(List.of("edit-javadocs", "d"), "Enable editing Javadocs");
        parser.acceptsAll(List.of("no-edit-javadocs", "D"), "Disable editing Javadocs");
        parser.accepts("single-class-tree", "Unify the deobfuscated and obfuscated class panels");
        parser.accepts("help", "Displays help information");
        try {
            OptionSet options = parser.parse(args);
            if (options.has("help")) {
                parser.printHelpOn((OutputStream)System.out);
                return;
            }
            EnumSet<EditableType> editables = EnumSet.allOf(EditableType.class);
            for (OptionSpec spec : options.specs()) {
                Iterator iterator = spec.options().iterator();
                while (iterator.hasNext()) {
                    String s;
                    switch (s = (String)iterator.next()) {
                        case "edit-all": {
                            editables.addAll(List.of(EditableType.values()));
                            break;
                        }
                        case "no-edit-all": {
                            editables.clear();
                            break;
                        }
                        case "edit-classes": {
                            editables.add(EditableType.CLASS);
                            break;
                        }
                        case "no-edit-classes": {
                            editables.remove((Object)EditableType.CLASS);
                            break;
                        }
                        case "edit-methods": {
                            editables.add(EditableType.METHOD);
                            break;
                        }
                        case "no-edit-methods": {
                            editables.remove((Object)EditableType.METHOD);
                            break;
                        }
                        case "edit-fields": {
                            editables.add(EditableType.FIELD);
                            break;
                        }
                        case "no-edit-fields": {
                            editables.remove((Object)EditableType.FIELD);
                            break;
                        }
                        case "edit-parameters": {
                            editables.add(EditableType.PARAMETER);
                            break;
                        }
                        case "no-edit-parameters": {
                            editables.remove((Object)EditableType.PARAMETER);
                            break;
                        }
                        case "edit-locals": {
                            editables.add(EditableType.LOCAL_VARIABLE);
                            System.err.println("warning: --edit-locals has no effect as local variables are currently not editable");
                            break;
                        }
                        case "no-edit-locals": {
                            editables.remove((Object)EditableType.LOCAL_VARIABLE);
                            System.err.println("warning: --no-edit-locals has no effect as local variables are currently not editable");
                            break;
                        }
                        case "edit-javadocs": {
                            editables.add(EditableType.JAVADOC);
                            break;
                        }
                        case "no-edit-javadocs": {
                            editables.remove((Object)EditableType.JAVADOC);
                        }
                    }
                }
            }
            EnigmaProfile parsedProfile = EnigmaProfile.read((Path)((Path)options.valueOf((OptionSpec)profile)));
            Enigma enigma = Enigma.builder().setProfile(parsedProfile).build();
            I18n.setLanguage((String)UiConfig.getLanguage(), (EnigmaServices)enigma.getServices());
            if (Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints") == null) {
                Main.setDefaultSystemProperty("awt.useSystemAAFontSettings", "lcd");
            }
            Main.setDefaultSystemProperty("apple.laf.useScreenMenuBar", "true");
            Themes.setupTheme();
            Gui gui = new Gui(enigma, editables);
            GuiController controller = gui.getController();
            if (options.has("single-class-tree")) {
                gui.setSingleClassTree(true);
            }
            if (Boolean.parseBoolean(System.getProperty("enigma.catchExceptions", "true"))) {
                CrashDialog.init(gui.getFrame());
                Thread.setDefaultUncaughtExceptionHandler((thread, t) -> {
                    t.printStackTrace(System.err);
                    if (!ExceptionIgnorer.shouldIgnore(t)) {
                        CrashDialog.show(t);
                    }
                });
            }
            if (options.has((OptionSpec)jar)) {
                List jarPaths = options.valuesOf((OptionSpec)jar);
                List libraryPaths = options.valuesOf((OptionSpec)library);
                controller.openJar(jarPaths, libraryPaths).whenComplete((arg_0, arg_1) -> Main.lambda$main$1(options, (OptionSpec)mappings, controller, arg_0, arg_1));
            }
        }
        catch (OptionException e) {
            System.out.println("Invalid arguments: " + e.getMessage());
            System.out.println();
            parser.printHelpOn((OutputStream)System.out);
        }
    }

    private static void setDefaultSystemProperty(String property, String value) {
        System.setProperty(property, System.getProperty(property, value));
    }

    private static /* synthetic */ void lambda$main$1(OptionSet options, OptionSpec mappings, GuiController controller, Void v, Throwable t) {
        if (options.has(mappings)) {
            Path mappingsPath = (Path)options.valueOf(mappings);
            if (Files.isDirectory(mappingsPath, new LinkOption[0])) {
                controller.openMappings(MappingFormat.ENIGMA_DIRECTORY, mappingsPath);
            } else {
                controller.openMappings(MappingFormat.ENIGMA_FILE, mappingsPath);
            }
        }
    }

    public static class PathConverter
    implements ValueConverter<Path> {
        public static final ValueConverter<Path> INSTANCE = new PathConverter();

        PathConverter() {
        }

        public Path convert(String path) {
            if (path.startsWith("~")) {
                Path dirHome = Paths.get(System.getProperty("user.home"), new String[0]);
                if (path.startsWith("~/")) {
                    return dirHome.resolve(path.substring(2));
                }
                return dirHome.getParent().resolve(path.substring(1));
            }
            return Paths.get(path, new String[0]);
        }

        public Class<? extends Path> valueType() {
            return Path.class;
        }

        public String valuePattern() {
            return "path";
        }
    }
}

