/*
 * Decompiled with CFR 0.152.
 */
package com.github.swingdpi.plaf;

import com.github.swingdpi.DpiUtils;
import com.github.swingdpi.plaf.BasicTweaker;
import com.github.swingdpi.plaf.ScaledIconUIResource;
import com.github.swingdpi.util.LoopBreakingScaledIcon;
import java.awt.Font;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.UIResource;

public class WindowsTweaker
extends BasicTweaker {
    protected final float alternateScaleFactor;
    protected final Font optionPaneFont;
    protected final boolean windowsClassic;
    private static final String[] PREFIX_TO_NOT_SCALE_ICONS = new String[]{"InternalFrame."};
    private static final String[] PRESCALED_INTEGER_PREFIXES = new String[]{"ScrollBar.", "InternalFrame.", "Menu.", "MenuBar.", "MenuItem.", "CheckBoxMenuItem.", "RadioButtonMenuItem."};
    private static final String BUTTON_DASHED_RECT_PREFIX = "Button.dashedRectGap";

    public WindowsTweaker(float scaleFactor, boolean classic) {
        super(scaleFactor);
        this.alternateScaleFactor = DpiUtils.isPerMonitorDpiActive() ? 100.0f * scaleFactor / (float)DpiUtils.getSystemScaling() : scaleFactor;
        this.optionPaneFont = this.uiDefaults.getFont("OptionPane.font");
        this.windowsClassic = classic;
    }

    @Override
    public void initialTweaks() {
        super.initialTweaks();
        if (this.doExtraTweaks) {
            this.uiDefaults.put("MenuItem.margin", new InsetsUIResource(1, 1, 1, 1));
            this.uiDefaults.put("Menu.margin", new InsetsUIResource(2, 2, 2, 2));
        }
    }

    @Override
    public void finalTweaks() {
        super.finalTweaks();
        if (DpiUtils.isPerMonitorDpiActive()) {
            return;
        }
        try {
            int x = (Integer)this.uiDefaults.get("Button.dashedRectGapX");
            int y = (Integer)this.uiDefaults.get("Button.dashedRectGapY");
            this.uiDefaults.put("Button.dashedRectGapWidth", (Object)(x * 2));
            this.uiDefaults.put("Button.dashedRectGapHeight", (Object)(y * 2));
        }
        catch (RuntimeException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public Font modifyFont(Object key, Font original) {
        String keyString = key.toString();
        Font font = this.maybeSubstituteFont(keyString, original);
        if (this.isFontUnscaled(keyString)) {
            return super.modifyFont(key, font);
        }
        return WindowsTweaker.isUnscaled(this.alternateScaleFactor) ? font : WindowsTweaker.newScaledFontUIResource(font, this.alternateScaleFactor);
    }

    private Font maybeSubstituteFont(String key, Font original) {
        if (this.makeModern() && "Tahoma".equals(original.getFamily()) && !key.equals("Panel.font")) {
            return this.optionPaneFont;
        }
        return original;
    }

    private boolean isFontUnscaled(String keyString) {
        return keyString.endsWith(".acceleratorFont") && !keyString.startsWith("MenuItem.") || keyString.equals("ColorChooser.font") || keyString.equals("TextArea.font");
    }

    @Override
    public Integer modifyInteger(Object key, Integer original) {
        if (key.toString().startsWith(BUTTON_DASHED_RECT_PREFIX)) {
            return Math.round((float)original.intValue() * (1.0f + this.scaleFactor) * 0.5f);
        }
        for (String prefix : PRESCALED_INTEGER_PREFIXES) {
            if (!String.valueOf(key).startsWith(prefix)) continue;
            return WindowsTweaker.scaleIntegerIfMetric(key, original, this.alternateScaleFactor);
        }
        return super.modifyInteger(key, original);
    }

    @Override
    public Icon modifyIcon(Object key, Icon original) {
        if (DpiUtils.isPerMonitorDpiActive()) {
            return super.modifyIcon(key, original);
        }
        for (String prefix : PREFIX_TO_NOT_SCALE_ICONS) {
            if (!String.valueOf(key).startsWith(prefix)) continue;
            return original;
        }
        String className = original.getClass().getName();
        if (className.contains("WindowsIconFactory")) {
            if (className.endsWith("VistaMenuItemCheckIcon")) {
                return original;
            }
            return WindowsTweaker.newLoopBreakingScaledIcon(key, original, this.alternateScaleFactor);
        }
        if ((original instanceof UIResource || original instanceof ImageIcon) && !className.contains("SkinIcon")) {
            return super.modifyIcon(key, original);
        }
        return WindowsTweaker.newScaledIconUIResource(original, this.alternateScaleFactor);
    }

    private boolean makeModern() {
        return this.doExtraTweaks && !this.windowsClassic;
    }

    protected static Icon newLoopBreakingScaledIcon(Object key, Icon original, float scale) {
        if (WindowsTweaker.isUnscaled(scale) && original instanceof UIResource) {
            return original;
        }
        return new ScaledIconUIResource(new LoopBreakingScaledIcon(key, original, scale));
    }
}

