/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.assembler.metadata;

import com.strobel.assembler.metadata.Buffer;
import com.strobel.assembler.metadata.ITypeLoader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ClasspathTypeLoader
implements ITypeLoader {
    private static final Logger LOG = Logger.getLogger(ClasspathTypeLoader.class.getSimpleName());
    private final ClassLoader _loader = ClassLoader.getSystemClassLoader();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean tryLoadType(String internalName, Buffer buffer) {
        String path;
        URL resource;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Attempting to load type: " + internalName + "...");
        }
        if ((resource = this._loader.getResource(path = internalName.concat(".class"))) == null) {
            return false;
        }
        try (InputStream stream = this._loader.getResourceAsStream(path);){
            int bytesRead;
            byte[] temp = new byte[4096];
            while ((bytesRead = stream.read(temp, 0, temp.length)) > 0) {
                buffer.ensureWriteableBytes(bytesRead);
                buffer.putByteArray(temp, 0, bytesRead);
            }
            buffer.flip();
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Type loaded from " + resource + ".");
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException ignored) {
            return false;
        }
    }
}

