/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.source.procyon.transformers;

import com.strobel.assembler.metadata.ParameterDefinition;
import com.strobel.decompiler.languages.java.ast.AstNode;
import com.strobel.decompiler.languages.java.ast.Comment;
import com.strobel.decompiler.languages.java.ast.CommentType;
import com.strobel.decompiler.languages.java.ast.ConstructorDeclaration;
import com.strobel.decompiler.languages.java.ast.DepthFirstAstVisitor;
import com.strobel.decompiler.languages.java.ast.EnumValueDeclaration;
import com.strobel.decompiler.languages.java.ast.FieldDeclaration;
import com.strobel.decompiler.languages.java.ast.Keys;
import com.strobel.decompiler.languages.java.ast.MethodDeclaration;
import com.strobel.decompiler.languages.java.ast.ParameterDeclaration;
import com.strobel.decompiler.languages.java.ast.Roles;
import com.strobel.decompiler.languages.java.ast.TypeDeclaration;
import com.strobel.decompiler.languages.java.ast.transforms.IAstTransform;
import cuchaz.enigma.source.procyon.EntryParser;
import cuchaz.enigma.translation.mapping.EntryMapping;
import cuchaz.enigma.translation.mapping.EntryRemapper;
import cuchaz.enigma.translation.mapping.ResolutionStrategy;
import cuchaz.enigma.translation.representation.entry.Entry;
import cuchaz.enigma.translation.representation.entry.LocalVariableDefEntry;
import cuchaz.enigma.translation.representation.entry.MethodDefEntry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;

public final class AddJavadocsAstTransform
implements IAstTransform {
    private final EntryRemapper remapper;

    public AddJavadocsAstTransform(EntryRemapper remapper) {
        this.remapper = remapper;
    }

    @Override
    public void run(AstNode compilationUnit) {
        compilationUnit.acceptVisitor(new Visitor(this.remapper), null);
    }

    static class Visitor
    extends DepthFirstAstVisitor<Void, Void> {
        private final EntryRemapper remapper;

        Visitor(EntryRemapper remapper) {
            this.remapper = remapper;
        }

        private <T extends AstNode> void addDoc(T node, Function<T, Entry<?>> retriever) {
            AstNode[] comments = this.getComments(node, retriever);
            if (comments != null) {
                node.insertChildrenBefore(node.getFirstChild(), Roles.COMMENT, comments);
            }
        }

        private <T extends AstNode> Comment[] getComments(T node, Function<T, Entry<?>> retriever) {
            EntryMapping mapping = this.remapper.getDeobfMapping(retriever.apply(node));
            String docs = mapping.javadoc();
            return docs == null || docs.isEmpty() ? null : (Comment[])Stream.of(docs.split("\\R")).map(st -> new Comment((String)st, CommentType.Documentation)).toArray(Comment[]::new);
        }

        private Comment[] getParameterComments(ParameterDeclaration node, Function<ParameterDeclaration, Entry<?>> retriever) {
            Entry<?> entry = retriever.apply(node);
            EntryMapping mapping = this.remapper.getDeobfMapping(entry);
            Comment[] ret = this.getComments(node, retriever);
            if (ret != null) {
                String paramPrefix = "@param " + (mapping.targetName() != null ? mapping.targetName() : entry.getName()) + " ";
                String indent = " ".repeat(paramPrefix.length());
                ret[0].setContent(paramPrefix + ret[0].getContent());
                for (int i = 1; i < ret.length; ++i) {
                    ret[i].setContent(indent + ret[i].getContent());
                }
            }
            return ret;
        }

        private void visitMethod(AstNode node) {
            MethodDefEntry methodDefEntry = EntryParser.parse(node.getUserData(Keys.METHOD_DEFINITION));
            Comment[] baseComments = this.getComments(node, $ -> methodDefEntry);
            ArrayList<Comment> comments = new ArrayList<Comment>();
            if (baseComments != null) {
                Collections.addAll(comments, baseComments);
            }
            for (ParameterDeclaration dec : node.getChildrenByRole(Roles.PARAMETER)) {
                ParameterDefinition def;
                Comment[] paramComments = this.getParameterComments(dec, arg_0 -> Visitor.lambda$visitMethod$3(methodDefEntry, def = dec.getUserData(Keys.PARAMETER_DEFINITION), arg_0));
                if (paramComments == null) continue;
                Collections.addAll(comments, paramComments);
            }
            if (!comments.isEmpty()) {
                if (this.remapper.getObfResolver().resolveEntry(methodDefEntry, ResolutionStrategy.RESOLVE_ROOT).stream().noneMatch(e -> Objects.equals(e, methodDefEntry))) {
                    comments.add(0, new Comment("{@inheritDoc}", CommentType.Documentation));
                }
                AstNode oldFirst = node.getFirstChild();
                for (Comment comment : comments) {
                    node.insertChildBefore(oldFirst, comment, Roles.COMMENT);
                }
            }
        }

        @Override
        protected Void visitChildren(AstNode node, Void data) {
            for (AstNode child : node.getChildren()) {
                child.acceptVisitor(this, data);
            }
            return null;
        }

        @Override
        public Void visitMethodDeclaration(MethodDeclaration node, Void data) {
            this.visitMethod(node);
            return (Void)super.visitMethodDeclaration(node, data);
        }

        @Override
        public Void visitConstructorDeclaration(ConstructorDeclaration node, Void data) {
            this.visitMethod(node);
            return (Void)super.visitConstructorDeclaration(node, data);
        }

        @Override
        public Void visitFieldDeclaration(FieldDeclaration node, Void data) {
            this.addDoc(node, dec -> EntryParser.parse(dec.getUserData(Keys.FIELD_DEFINITION)));
            return (Void)super.visitFieldDeclaration(node, data);
        }

        @Override
        public Void visitTypeDeclaration(TypeDeclaration node, Void data) {
            this.addDoc(node, dec -> EntryParser.parse(dec.getUserData(Keys.TYPE_DEFINITION)));
            return (Void)super.visitTypeDeclaration(node, data);
        }

        @Override
        public Void visitEnumValueDeclaration(EnumValueDeclaration node, Void data) {
            this.addDoc(node, dec -> EntryParser.parse(dec.getUserData(Keys.FIELD_DEFINITION)));
            return (Void)super.visitEnumValueDeclaration(node, data);
        }

        private static /* synthetic */ Entry lambda$visitMethod$3(MethodDefEntry methodDefEntry, ParameterDefinition def, ParameterDeclaration $) {
            return new LocalVariableDefEntry(methodDefEntry, def.getSlot(), def.getName(), true, EntryParser.parseTypeDescriptor(def.getParameterType()), null);
        }
    }
}

