/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.translation.mapping;

import cuchaz.enigma.analysis.index.InheritanceIndex;
import cuchaz.enigma.analysis.index.JarIndex;
import cuchaz.enigma.translation.Translator;
import cuchaz.enigma.translation.mapping.EntryMapping;
import cuchaz.enigma.translation.mapping.tree.EntryTree;
import cuchaz.enigma.translation.representation.AccessFlags;
import cuchaz.enigma.translation.representation.entry.ClassEntry;
import cuchaz.enigma.translation.representation.entry.Entry;
import cuchaz.enigma.utils.validation.Message;
import cuchaz.enigma.utils.validation.ValidationContext;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class MappingValidator {
    private final EntryTree<EntryMapping> obfToDeobf;
    private final Translator deobfuscator;
    private final JarIndex index;

    public MappingValidator(EntryTree<EntryMapping> obfToDeobf, Translator deobfuscator, JarIndex index) {
        this.obfToDeobf = obfToDeobf;
        this.deobfuscator = deobfuscator;
        this.index = index;
    }

    public boolean validateRename(ValidationContext vc, Entry<?> entry, String name) {
        Set<Entry<?>> equivalentEntries = this.index.getEntryResolver().resolveEquivalentEntries(entry);
        boolean error = false;
        for (Entry entry2 : equivalentEntries) {
            entry2.validateName(vc, name);
            error |= this.validateUnique(vc, entry2, name);
        }
        return error;
    }

    private boolean validateUnique(ValidationContext vc, Entry<?> entry, String name) {
        ClassEntry containingClass = entry.getContainingClass();
        Collection<ClassEntry> relatedClasses = this.getRelatedClasses(containingClass);
        boolean error = false;
        for (ClassEntry relatedClass : relatedClasses) {
            Object parent;
            if (this.isStatic(entry) && relatedClass != containingClass) continue;
            Entry<?> relatedEntry = entry.replaceAncestor(containingClass, relatedClass);
            Entry<?> translatedEntry = this.deobfuscator.translate(relatedEntry);
            List<Entry> translatedSiblings = this.obfToDeobf.getSiblings(relatedEntry).stream().filter(sibling -> !sibling.equals(entry)).map(this.deobfuscator::translate).toList();
            if (!this.isUnique(translatedEntry, translatedSiblings, name)) {
                parent = translatedEntry.getParent();
                if (parent != null) {
                    vc.raise(Message.NONUNIQUE_NAME_CLASS, name, parent);
                } else {
                    vc.raise(Message.NONUNIQUE_NAME, name);
                }
                error = true;
                continue;
            }
            Entry<?> shadowedEntry = this.getShadowedEntry(translatedEntry, translatedSiblings, name);
            if (shadowedEntry == null) continue;
            parent = shadowedEntry.getParent();
            if (parent != null) {
                vc.raise(Message.SHADOWED_NAME_CLASS, name, parent);
                continue;
            }
            vc.raise(Message.SHADOWED_NAME, name);
        }
        return error;
    }

    private Collection<ClassEntry> getRelatedClasses(ClassEntry classEntry) {
        InheritanceIndex inheritanceIndex = this.index.getInheritanceIndex();
        HashSet<ClassEntry> relatedClasses = new HashSet<ClassEntry>();
        relatedClasses.add(classEntry);
        relatedClasses.addAll(inheritanceIndex.getChildren(classEntry));
        relatedClasses.addAll(inheritanceIndex.getAncestors(classEntry));
        return relatedClasses;
    }

    private boolean isUnique(Entry<?> entry, List<? extends Entry<?>> siblings, String name) {
        for (Entry<?> sibling : siblings) {
            if (!this.canConflict(entry, sibling) || !sibling.getName().equals(name)) continue;
            return false;
        }
        return true;
    }

    private boolean canConflict(Entry<?> entry, Entry<?> sibling) {
        return entry.canConflictWith(sibling);
    }

    @Nullable
    private Entry<?> getShadowedEntry(Entry<?> entry, List<? extends Entry<?>> siblings, String name) {
        for (Entry<?> sibling : siblings) {
            if (!this.canShadow(entry, sibling) || !sibling.getName().equals(name)) continue;
            return sibling;
        }
        return null;
    }

    private boolean canShadow(Entry<?> entry, Entry<?> sibling) {
        return entry.canShadow(sibling);
    }

    private boolean isStatic(Entry<?> entry) {
        AccessFlags accessFlags = this.index.getEntryIndex().getEntryAccess(entry);
        return accessFlags != null && accessFlags.isStatic();
    }
}

