/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.translation.representation.entry;

import cuchaz.enigma.api.view.entry.FieldEntryView;
import cuchaz.enigma.source.RenamableTokenType;
import cuchaz.enigma.translation.TranslateResult;
import cuchaz.enigma.translation.Translator;
import cuchaz.enigma.translation.mapping.EntryMapping;
import cuchaz.enigma.translation.representation.TypeDescriptor;
import cuchaz.enigma.translation.representation.entry.ClassEntry;
import cuchaz.enigma.translation.representation.entry.Entry;
import cuchaz.enigma.translation.representation.entry.ParentedEntry;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class FieldEntry
extends ParentedEntry<ClassEntry>
implements Comparable<FieldEntry>,
FieldEntryView {
    protected final TypeDescriptor desc;

    public FieldEntry(ClassEntry parent, String name, TypeDescriptor desc) {
        this(parent, name, desc, null);
    }

    public FieldEntry(ClassEntry parent, String name, TypeDescriptor desc, String javadocs) {
        super(Objects.requireNonNull(parent, "Owner cannot be null"), name, javadocs);
        this.desc = Objects.requireNonNull(desc, "Field descriptor cannot be null");
    }

    public static FieldEntry parse(String owner, String name, String desc) {
        return new FieldEntry(new ClassEntry(owner), name, new TypeDescriptor(desc), null);
    }

    @Override
    public Class<ClassEntry> getParentType() {
        return ClassEntry.class;
    }

    public TypeDescriptor getDesc() {
        return this.desc;
    }

    @Override
    public String getDescriptor() {
        return this.desc.toString();
    }

    @Override
    public FieldEntry withName(String name) {
        return new FieldEntry((ClassEntry)this.parent, name, this.desc, null);
    }

    public FieldEntry withDesc(TypeDescriptor desc) {
        return new FieldEntry((ClassEntry)this.parent, this.name, desc, null);
    }

    public FieldEntry withParent(ClassEntry parent) {
        return new FieldEntry(parent, this.name, this.desc, null);
    }

    @Override
    protected TranslateResult<FieldEntry> extendedTranslate(Translator translator, @NotNull EntryMapping mapping) {
        String translatedName = mapping.targetName() != null ? mapping.targetName() : this.name;
        String docs = mapping.javadoc();
        return TranslateResult.of(mapping.targetName() == null ? RenamableTokenType.OBFUSCATED : RenamableTokenType.DEOBFUSCATED, new FieldEntry((ClassEntry)this.parent, translatedName, translator.translate(this.desc), docs));
    }

    public int hashCode() {
        return Objects.hash(this.parent, this.name, this.desc);
    }

    public boolean equals(Object other) {
        return other instanceof FieldEntry && this.equals((FieldEntry)other);
    }

    public boolean equals(FieldEntry other) {
        return ((ClassEntry)this.parent).equals((ClassEntry)other.parent) && this.name.equals(other.name) && this.desc.equals(other.desc);
    }

    @Override
    public boolean canConflictWith(Entry<?> entry) {
        FieldEntry fieldEntry;
        return entry instanceof FieldEntry && ((ClassEntry)(fieldEntry = (FieldEntry)entry).getParent()).equals((ClassEntry)this.parent);
    }

    @Override
    public boolean canShadow(Entry<?> entry) {
        return entry instanceof FieldEntry;
    }

    public String toString() {
        return this.getFullName() + ":" + String.valueOf(this.desc);
    }

    @Override
    public int compareTo(FieldEntry entry) {
        return (this.name + this.desc.toString()).compareTo(entry.name + entry.desc.toString());
    }
}

