/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.main.decompiler;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.extern.IFernflowerLogger;
import org.jetbrains.java.decompiler.main.extern.IResultSaver;
import org.jetbrains.java.decompiler.util.InterpreterUtil;
import org.jetbrains.java.decompiler.util.ZipFileCache;

public class SingleFileSaver
implements IResultSaver,
AutoCloseable {
    public static final String MANIFEST = "META-INF/MANIFEST.MF";
    private final File target;
    private ZipOutputStream output;
    private boolean isJar;
    private Set<String> entries = new HashSet<String>();
    private final ZipFileCache openZips = new ZipFileCache();

    public SingleFileSaver(File target) {
        this.target = target;
        if (target.isDirectory()) {
            throw new IllegalStateException("Trying to save " + target.getAbsolutePath() + " as a file but there's a directory there already!");
        }
    }

    @Override
    public void saveFolder(String path) {
    }

    @Override
    public void copyFile(String source, String path, String entryName) {
        if (!this.checkEntry(entryName)) {
            return;
        }
        try {
            this.output.putNextEntry(new ZipEntry(entryName));
            InterpreterUtil.copyStream(new FileInputStream(source), this.output);
        }
        catch (IOException ex) {
            String message = "Cannot write entry " + entryName + " to " + this.target;
            DecompilerContext.getLogger().writeMessage(message, ex);
        }
    }

    @Override
    public void saveClassFile(String path, String qualifiedName, String entryName, String content, int[] mapping) {
        if (!this.checkEntry(qualifiedName + ".java")) {
            return;
        }
        try {
            this.output.putNextEntry(new ZipEntry(qualifiedName + ".java"));
            if (content != null) {
                this.output.write(content.getBytes(StandardCharsets.UTF_8));
            }
        }
        catch (IOException ex) {
            String message = "Cannot write entry " + entryName + " to " + this.target;
            DecompilerContext.getLogger().writeMessage(message, ex);
        }
    }

    @Override
    public void createArchive(String path, String archiveName, Manifest manifest) {
        if (this.output != null) {
            throw new UnsupportedOperationException("Attempted to write multiple archives at the same time");
        }
        try {
            FileOutputStream stream = new FileOutputStream(this.target);
            this.isJar = manifest != null;
            this.output = this.isJar ? new JarOutputStream((OutputStream)stream, manifest) : new ZipOutputStream(stream);
        }
        catch (IOException e) {
            DecompilerContext.getLogger().writeMessage("Cannot create archive " + this.target, e);
        }
    }

    @Override
    public void saveDirEntry(String path, String archiveName, String entryName) {
    }

    @Override
    public void copyEntry(String source, String path, String archiveName, String entryName) {
        block10: {
            if (!this.checkEntry(entryName)) {
                return;
            }
            try {
                ZipFile srcArchive = this.openZips.get(source);
                ZipEntry entry = srcArchive.getEntry(entryName);
                if (entry == null) break block10;
                if (this.isJar && MANIFEST.equals(entryName)) {
                    return;
                }
                try (InputStream in = srcArchive.getInputStream(entry);){
                    this.output.putNextEntry(new ZipEntry(entryName));
                    InterpreterUtil.copyStream(in, this.output);
                }
            }
            catch (IOException ex) {
                String message = "Cannot copy entry " + entryName + " from " + source + " to " + this.target;
                DecompilerContext.getLogger().writeMessage(message, ex);
            }
        }
    }

    @Override
    public void saveClassEntry(String path, String archiveName, String qualifiedName, String entryName, String content) {
        this.saveClassEntry(path, archiveName, qualifiedName, entryName, content, null);
    }

    @Override
    public void saveClassEntry(String path, String archiveName, String qualifiedName, String entryName, String content, int[] mapping) {
        if (!this.checkEntry(entryName)) {
            return;
        }
        try {
            ZipEntry entry = new ZipEntry(entryName);
            if (mapping != null && DecompilerContext.getOption("dump-code-lines")) {
                entry.setExtra(this.getCodeLineData(mapping));
            }
            this.output.putNextEntry(entry);
            if (content != null) {
                this.output.write(content.getBytes(StandardCharsets.UTF_8));
            }
        }
        catch (IOException ex) {
            String message = "Cannot write entry " + entryName + " to " + this.target;
            DecompilerContext.getLogger().writeMessage(message, ex);
        }
    }

    @Override
    public void closeArchive(String path, String archiveName) {
        try {
            if (this.output != null) {
                this.output.close();
                this.entries.clear();
                this.output = null;
            }
        }
        catch (IOException ex) {
            DecompilerContext.getLogger().writeMessage("Cannot close " + this.target, IFernflowerLogger.Severity.WARN);
        }
    }

    private boolean checkEntry(String entryName) {
        boolean added = this.entries.add(entryName);
        if (!added) {
            String message = "Zip entry " + entryName + " already exists in " + this.target;
            DecompilerContext.getLogger().writeMessage(message, IFernflowerLogger.Severity.WARN);
        }
        return added;
    }

    @Override
    public void close() throws IOException {
        this.openZips.close();
    }
}

