/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.vars;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.java.decompiler.modules.decompiler.ValidationHelper;
import org.jetbrains.java.decompiler.modules.decompiler.decompose.IGraphNode;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarVersionPair;
import org.jetbrains.java.decompiler.struct.attr.StructLocalVariableTableAttribute;
import org.jetbrains.java.decompiler.util.collections.SFormsFastMapDirect;

public class VarVersionNode
implements IGraphNode {
    public final int var;
    public final int version;
    public final Set<VarVersionNode> successors = new LinkedHashSet<VarVersionNode>();
    public final Set<VarVersionNode> predecessors = new LinkedHashSet<VarVersionNode>();
    public VarVersionNode phantomNode = null;
    public VarVersionNode phantomParentNode = null;
    public SFormsFastMapDirect live = null;
    public StructLocalVariableTableAttribute.LocalVariable lvt;
    public State state = null;

    VarVersionNode(int var, int version, StructLocalVariableTableAttribute.LocalVariable lvt) {
        this.var = var;
        this.version = version;
        this.lvt = lvt;
    }

    public Collection<VarVersionNode> getPredecessors() {
        return this.predecessors;
    }

    public void removeSuccessor(VarVersionNode node) {
        this.successors.remove(node);
    }

    public void removePredecessor(VarVersionNode node) {
        this.predecessors.remove(node);
    }

    public boolean hasSinglePredecessor() {
        return this.predecessors.size() == 1;
    }

    public boolean hasAnySuccessors() {
        return !this.successors.isEmpty();
    }

    public VarVersionNode getSinglePredecessor() {
        ValidationHelper.validateTrue(this.hasSinglePredecessor(), "Expected only a single predecessor");
        return this.predecessors.iterator().next();
    }

    public String toString() {
        return "(" + this.var + "_" + this.version + ")";
    }

    public VarVersionPair asPair() {
        return new VarVersionPair(this.var, this.version);
    }

    public static enum State {
        WRITE,
        READ,
        PHI,
        DEAD_READ,
        PHANTOM,
        PARAM,
        CATCH;

    }
}

