/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.gui.config;

import com.formdev.flatlaf.FlatDarkLaf;
import com.formdev.flatlaf.FlatLightLaf;
import cuchaz.enigma.gui.config.UiConfig;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;

public enum LookAndFeel {
    DEFAULT(false),
    DARCULA(false),
    METAL(true),
    SYSTEM(true),
    NONE(true);

    private static final javax.swing.LookAndFeel NONE_LAF;
    private final boolean needsScaling;
    private static Boolean isDarkLaf;

    private LookAndFeel(boolean needsScaling) {
        this.needsScaling = needsScaling;
    }

    public boolean needsScaling() {
        return this.needsScaling;
    }

    public void setGlobalLAF() {
        System.setProperty("flatlaf.uiScale", Float.toString(UiConfig.getActiveScaleFactor()));
        try {
            switch (this.ordinal()) {
                case 4: {
                    UIManager.setLookAndFeel(NONE_LAF);
                    break;
                }
                case 0: {
                    UIManager.setLookAndFeel((javax.swing.LookAndFeel)new FlatLightLaf());
                    break;
                }
                case 2: {
                    UIManager.setLookAndFeel(new MetalLookAndFeel());
                    break;
                }
                case 1: {
                    UIManager.setLookAndFeel((javax.swing.LookAndFeel)new FlatDarkLaf());
                    break;
                }
                case 3: {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
            }
        }
        catch (Exception e) {
            throw new Error("Failed to set global look and feel", e);
        }
    }

    public static boolean isDarkLaf() {
        if (isDarkLaf != null) {
            return isDarkLaf;
        }
        JPanel panel = new JPanel();
        panel.setSize(new Dimension(10, 10));
        panel.doLayout();
        BufferedImage image = new BufferedImage(panel.getSize().width, panel.getSize().height, 1);
        panel.printAll(image.getGraphics());
        Color c = new Color(image.getRGB(0, 0));
        int b = (int)(0.3 * (double)c.getRed() + 0.59 * (double)c.getGreen() + 0.11 * (double)c.getBlue());
        isDarkLaf = b < 85;
        return isDarkLaf;
    }

    static {
        NONE_LAF = UIManager.getLookAndFeel();
        isDarkLaf = null;
    }
}

