/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma;

import cuchaz.enigma.Deobfuscator;
import cuchaz.enigma.mapping.Mappings;
import cuchaz.enigma.mapping.MappingsEnigmaReader;
import java.io.File;
import java.util.jar.JarFile;

public class CommandMain {
    public static void main(String[] args) throws Exception {
        block7: {
            try {
                String command = CommandMain.getArg(args, 0, "command", true);
                if (command.equalsIgnoreCase("deobfuscate")) {
                    CommandMain.deobfuscate(args);
                    break block7;
                }
                if (command.equalsIgnoreCase("decompile")) {
                    CommandMain.decompile(args);
                    break block7;
                }
                if (command.equalsIgnoreCase("protectify")) {
                    CommandMain.protectify(args);
                    break block7;
                }
                if (command.equalsIgnoreCase("publify")) {
                    CommandMain.publify(args);
                    break block7;
                }
                if (command.equalsIgnoreCase("convertmappings")) {
                    CommandMain.convertMappings(args);
                    break block7;
                }
                throw new IllegalArgumentException("Command not recognized: " + command);
            }
            catch (IllegalArgumentException ex) {
                System.out.println(ex.getMessage());
                CommandMain.printHelp();
            }
        }
    }

    private static void printHelp() {
        System.out.println(String.format("%s - %s", "Enigma", "0.11.0 (Fabric Fork)"));
        System.out.println("Usage:");
        System.out.println("\tjava -cp enigma.jar cuchaz.enigma.CommandMain <command>");
        System.out.println("\twhere <command> is one of:");
        System.out.println("\t\tdeobfuscate <in jar> <out jar> [<mappings file>]");
        System.out.println("\t\tdecompile <in jar> <out folder> [<mappings file>]");
        System.out.println("\t\tprotectify <in jar> <out jar>");
        System.out.println("\t\tpublify <in jar> <out jar>");
        System.out.println("\t\tconvertmappings <enigma mappings> <converted mappings> <ENIGMA_FILE|ENIGMA_DIRECTORY|SRG_FILE>");
    }

    private static void decompile(String[] args) throws Exception {
        File fileJarIn = CommandMain.getReadableFile(CommandMain.getArg(args, 1, "in jar", true));
        File fileJarOut = CommandMain.getWritableFolder(CommandMain.getArg(args, 2, "out folder", true));
        File fileMappings = CommandMain.getReadableFile(CommandMain.getArg(args, 3, "mappings file", false));
        Deobfuscator deobfuscator = CommandMain.getDeobfuscator(fileMappings, new JarFile(fileJarIn));
        deobfuscator.writeSources(fileJarOut, new ConsoleProgressListener());
    }

    private static void deobfuscate(String[] args) throws Exception {
        File fileJarIn = CommandMain.getReadableFile(CommandMain.getArg(args, 1, "in jar", true));
        File fileJarOut = CommandMain.getWritableFile(CommandMain.getArg(args, 2, "out jar", true));
        File fileMappings = CommandMain.getReadableFile(CommandMain.getArg(args, 3, "mappings file", false));
        Deobfuscator deobfuscator = CommandMain.getDeobfuscator(fileMappings, new JarFile(fileJarIn));
        deobfuscator.writeJar(fileJarOut, new ConsoleProgressListener());
    }

    private static void protectify(String[] args) throws Exception {
        File fileJarIn = CommandMain.getReadableFile(CommandMain.getArg(args, 1, "in jar", true));
        File fileJarOut = CommandMain.getWritableFile(CommandMain.getArg(args, 2, "out jar", true));
        Deobfuscator deobfuscator = CommandMain.getDeobfuscator(null, new JarFile(fileJarIn));
        deobfuscator.protectifyJar(fileJarOut, new ConsoleProgressListener());
    }

    private static void publify(String[] args) throws Exception {
        File fileJarIn = CommandMain.getReadableFile(CommandMain.getArg(args, 1, "in jar", true));
        File fileJarOut = CommandMain.getWritableFile(CommandMain.getArg(args, 2, "out jar", true));
        Deobfuscator deobfuscator = CommandMain.getDeobfuscator(null, new JarFile(fileJarIn));
        deobfuscator.publifyJar(fileJarOut, new ConsoleProgressListener());
    }

    private static Deobfuscator getDeobfuscator(File fileMappings, JarFile jar) throws Exception {
        System.out.println("Reading jar...");
        Deobfuscator deobfuscator = new Deobfuscator(jar);
        if (fileMappings != null) {
            System.out.println("Reading mappings...");
            Mappings mappings = new MappingsEnigmaReader().read(fileMappings);
            deobfuscator.setMappings(mappings);
        }
        return deobfuscator;
    }

    private static void convertMappings(String[] args) throws Exception {
        Mappings.FormatType formatType;
        File fileMappings = CommandMain.getReadableFile(CommandMain.getArg(args, 1, "enigma mapping", true));
        File result = CommandMain.getWritableFile(CommandMain.getArg(args, 2, "enigma mapping", true));
        String name = CommandMain.getArg(args, 3, "format type", true);
        try {
            formatType = Mappings.FormatType.valueOf(name.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(name + "is not a valid mapping format!");
        }
        System.out.println("Reading mappings...");
        Mappings mappings = new MappingsEnigmaReader().read(fileMappings);
        System.out.println("Saving new mappings...");
        switch (formatType) {
            case SRG_FILE: {
                mappings.saveSRGMappings(result);
                break;
            }
            default: {
                mappings.saveEnigmaMappings(result, Mappings.FormatType.ENIGMA_FILE != formatType);
            }
        }
    }

    private static String getArg(String[] args, int i, String name, boolean required) {
        if (i >= args.length) {
            if (required) {
                throw new IllegalArgumentException(name + " is required");
            }
            return null;
        }
        return args[i];
    }

    private static File getWritableFile(String path) {
        if (path == null) {
            return null;
        }
        File file = new File(path).getAbsoluteFile();
        File dir = file.getParentFile();
        if (dir == null) {
            throw new IllegalArgumentException("Cannot write file: " + path);
        }
        if (!dir.isDirectory()) {
            dir.mkdirs();
        }
        return file;
    }

    private static File getWritableFolder(String path) {
        if (path == null) {
            return null;
        }
        File dir = new File(path).getAbsoluteFile();
        if (!dir.exists()) {
            throw new IllegalArgumentException("Cannot write to folder: " + dir);
        }
        return dir;
    }

    private static File getReadableFile(String path) {
        if (path == null) {
            return null;
        }
        File file = new File(path).getAbsoluteFile();
        if (!file.exists()) {
            throw new IllegalArgumentException("Cannot find file: " + file.getAbsolutePath());
        }
        return file;
    }

    public static class ConsoleProgressListener
    implements Deobfuscator.ProgressListener {
        private static final int ReportTime = 5000;
        private int totalWork;
        private long startTime;
        private long lastReportTime;

        @Override
        public void init(int totalWork, String title) {
            this.totalWork = totalWork;
            this.lastReportTime = this.startTime = System.currentTimeMillis();
            System.out.println(title);
        }

        @Override
        public void onProgress(int numDone, String message) {
            boolean shouldReport;
            long now = System.currentTimeMillis();
            boolean isLastUpdate = numDone == this.totalWork;
            boolean bl = shouldReport = isLastUpdate || now - this.lastReportTime > 5000L;
            if (shouldReport) {
                int percent = numDone * 100 / this.totalWork;
                System.out.println(String.format("\tProgress: %3d%%", percent));
                this.lastReportTime = now;
            }
            if (isLastUpdate) {
                double elapsedSeconds = (double)(now - this.startTime) / 1000.0;
                System.out.println(String.format("Finished in %.1f seconds", elapsedSeconds));
            }
        }
    }
}

