/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma;

import cuchaz.enigma.Deobfuscator;
import cuchaz.enigma.convert.ClassMatches;
import cuchaz.enigma.convert.MappingsConverter;
import cuchaz.enigma.convert.MatchesReader;
import cuchaz.enigma.convert.MatchesWriter;
import cuchaz.enigma.convert.MemberMatches;
import cuchaz.enigma.gui.ClassMatchingGui;
import cuchaz.enigma.gui.MemberMatchingGui;
import cuchaz.enigma.mapping.BehaviorEntry;
import cuchaz.enigma.mapping.ClassEntry;
import cuchaz.enigma.mapping.ClassMapping;
import cuchaz.enigma.mapping.Entry;
import cuchaz.enigma.mapping.FieldEntry;
import cuchaz.enigma.mapping.FieldMapping;
import cuchaz.enigma.mapping.Mappings;
import cuchaz.enigma.mapping.MappingsChecker;
import cuchaz.enigma.mapping.MappingsEnigmaReader;
import cuchaz.enigma.mapping.MappingsEnigmaWriter;
import cuchaz.enigma.mapping.MethodMapping;
import cuchaz.enigma.throwables.MappingConflict;
import cuchaz.enigma.throwables.MappingParseException;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.jar.JarFile;

public class ConvertMain {
    public static void main(String[] args) throws IOException, MappingParseException {
        try {
            String JarOld = ConvertMain.getArg(args, 1, "Path to Old Jar", true);
            String JarNew = ConvertMain.getArg(args, 2, "Path to New Jar", true);
            String OldMappings = ConvertMain.getArg(args, 3, "Path to old .mappings file", true);
            String NewMappings = ConvertMain.getArg(args, 4, "Path to new .mappings file", true);
            String ClassMatches2 = ConvertMain.getArg(args, 5, "Path to Class .matches file", true);
            String FieldMatches2 = ConvertMain.getArg(args, 6, "Path to Field .matches file", true);
            String MethodMatches = ConvertMain.getArg(args, 7, "Path to Method .matches file", true);
            JarFile sourceJar = new JarFile(new File(JarOld));
            JarFile destJar = new JarFile(new File(JarNew));
            File inMappingsFile = new File(OldMappings);
            File outMappingsFile = new File(NewMappings);
            Mappings mappings = new MappingsEnigmaReader().read(inMappingsFile);
            File classMatchesFile = new File(ClassMatches2);
            File fieldMatchesFile = new File(FieldMatches2);
            File methodMatchesFile = new File(MethodMatches);
            String command = ConvertMain.getArg(args, 0, "command", true);
            if (command.equalsIgnoreCase("computeClassMatches")) {
                ConvertMain.computeClassMatches(classMatchesFile, sourceJar, destJar, mappings);
                ConvertMain.convertMappings(outMappingsFile, sourceJar, destJar, mappings, classMatchesFile);
            } else if (command.equalsIgnoreCase("editClassMatches")) {
                ConvertMain.editClasssMatches(classMatchesFile, sourceJar, destJar, mappings);
                ConvertMain.convertMappings(outMappingsFile, sourceJar, destJar, mappings, classMatchesFile);
            } else if (command.equalsIgnoreCase("computeFieldMatches")) {
                ConvertMain.computeFieldMatches(fieldMatchesFile, destJar, outMappingsFile, classMatchesFile);
                ConvertMain.convertMappings(outMappingsFile, sourceJar, destJar, mappings, classMatchesFile, fieldMatchesFile);
            } else if (command.equalsIgnoreCase("editFieldMatches")) {
                ConvertMain.editFieldMatches(sourceJar, destJar, outMappingsFile, mappings, classMatchesFile, fieldMatchesFile);
                ConvertMain.convertMappings(outMappingsFile, sourceJar, destJar, mappings, classMatchesFile, fieldMatchesFile);
            } else if (command.equalsIgnoreCase("computeMethodMatches")) {
                ConvertMain.computeMethodMatches(outMappingsFile, sourceJar, destJar, mappings, classMatchesFile, fieldMatchesFile, methodMatchesFile);
                ConvertMain.convertMappings(outMappingsFile, sourceJar, destJar, mappings, classMatchesFile, fieldMatchesFile, methodMatchesFile);
            } else if (command.equalsIgnoreCase("editMethodMatches")) {
                ConvertMain.editMethodMatches(sourceJar, destJar, outMappingsFile, mappings, classMatchesFile, methodMatchesFile);
                ConvertMain.convertMappings(outMappingsFile, sourceJar, destJar, mappings, classMatchesFile, fieldMatchesFile, methodMatchesFile);
            } else if (command.equalsIgnoreCase("convertMappings")) {
                ConvertMain.convertMappings(outMappingsFile, sourceJar, destJar, mappings, classMatchesFile, fieldMatchesFile, methodMatchesFile);
            }
        }
        catch (MappingConflict ex) {
            System.out.println(ex.getMessage());
            ex.printStackTrace();
        }
        catch (IllegalArgumentException ex) {
            System.out.println(ex.getMessage());
            ConvertMain.printHelp();
        }
    }

    private static void printHelp() {
        System.out.println(String.format("%s - %s", "Enigma", "0.11.0 (Fabric Fork)"));
        System.out.println("Usage:");
        System.out.println("\tjava -cp enigma.jar cuchaz.enigma.ConvertMain <command> <old-jar> <new-jar> <old-mappings> <new-mappings> <class-matches> <field-matches> <method-matches>");
        System.out.println("\tWhere <command> is one of:");
        System.out.println("\t\tcomputeClassMatches");
        System.out.println("\t\teditClassMatches");
        System.out.println("\t\tcomputeFieldMatches");
        System.out.println("\t\teditFieldMatches");
        System.out.println("\t\teditMethodMatches");
        System.out.println("\t\tconvertMappings");
        System.out.println("\tWhere <old-jar> is the already mapped jar.");
        System.out.println("\tWhere <new-jar> is the unmapped jar.");
        System.out.println("\tWhere <old-mappings> is the path to the mappings for the old jar.");
        System.out.println("\tWhere <new-mappings> is the new mappings. (Where you want to save them and there name)");
        System.out.println("\tWhere <class-matches> is the class matches file.");
        System.out.println("\tWhere <field-matches> is the field matches file.");
        System.out.println("\tWhere <method-matches> is the method matches file.");
    }

    private static String getArg(String[] args, int i, String name, boolean required) {
        if (i >= args.length) {
            if (required) {
                throw new IllegalArgumentException(name + " is required");
            }
            return null;
        }
        return args[i];
    }

    private static void computeClassMatches(File classMatchesFile, JarFile sourceJar, JarFile destJar, Mappings mappings) throws IOException {
        ClassMatches classMatches = MappingsConverter.computeClassMatches(sourceJar, destJar, mappings);
        MatchesWriter.writeClasses(classMatches, classMatchesFile);
        System.out.println("Wrote:\n\t" + classMatchesFile.getAbsolutePath());
    }

    private static void editClasssMatches(File classMatchesFile, JarFile sourceJar, JarFile destJar, Mappings mappings) throws IOException {
        System.out.println("Reading class matches...");
        ClassMatches classMatches = MatchesReader.readClasses(classMatchesFile);
        Deobfuscators deobfuscators = new Deobfuscators(sourceJar, destJar);
        deobfuscators.source.setMappings(mappings);
        System.out.println("Starting GUI...");
        new ClassMatchingGui(classMatches, deobfuscators.source, deobfuscators.dest).setSaveListener(matches -> {
            try {
                MatchesWriter.writeClasses(matches, classMatchesFile);
            }
            catch (IOException ex) {
                throw new Error(ex);
            }
        });
    }

    private static void convertMappings(File outMappingsFile, JarFile sourceJar, JarFile destJar, Mappings mappings, File classMatchesFile) throws IOException, MappingConflict {
        System.out.println("Reading class matches...");
        ClassMatches classMatches = MatchesReader.readClasses(classMatchesFile);
        Deobfuscators deobfuscators = new Deobfuscators(sourceJar, destJar);
        deobfuscators.source.setMappings(mappings);
        Mappings newMappings = MappingsConverter.newMappings(classMatches, mappings, deobfuscators.source, deobfuscators.dest);
        new MappingsEnigmaWriter().write(outMappingsFile, newMappings, true);
        System.out.println("Write converted mappings to: " + outMappingsFile.getAbsolutePath());
    }

    private static void computeFieldMatches(File memberMatchesFile, JarFile destJar, File destMappingsFile, File classMatchesFile) throws IOException, MappingParseException {
        System.out.println("Reading class matches...");
        ClassMatches classMatches = MatchesReader.readClasses(classMatchesFile);
        System.out.println("Reading mappings...");
        Mappings destMappings = new MappingsEnigmaReader().read(destMappingsFile);
        System.out.println("Indexing dest jar...");
        Deobfuscator destDeobfuscator = new Deobfuscator(destJar);
        System.out.println("Writing matches...");
        MemberMatches<FieldEntry> fieldMatches = MappingsConverter.computeMemberMatches(destDeobfuscator, destMappings, classMatches, MappingsConverter.getFieldDoer());
        MatchesWriter.writeMembers(fieldMatches, memberMatchesFile);
        System.out.println("Wrote:\n\t" + memberMatchesFile.getAbsolutePath());
    }

    private static void editFieldMatches(JarFile sourceJar, JarFile destJar, File destMappingsFile, Mappings sourceMappings, File classMatchesFile, File fieldMatchesFile) throws IOException, MappingParseException {
        System.out.println("Reading matches...");
        ClassMatches classMatches = MatchesReader.readClasses(classMatchesFile);
        MemberMatches fieldMatches = MatchesReader.readMembers(fieldMatchesFile);
        Deobfuscators deobfuscators = new Deobfuscators(sourceJar, destJar);
        deobfuscators.source.setMappings(sourceMappings);
        Mappings destMappings = new MappingsEnigmaReader().read(destMappingsFile);
        MappingsChecker checker = new MappingsChecker(deobfuscators.dest.getJarIndex());
        checker.dropBrokenMappings(destMappings);
        deobfuscators.dest.setMappings(destMappings);
        new MemberMatchingGui(classMatches, fieldMatches, deobfuscators.source, deobfuscators.dest).setSaveListener(matches -> {
            try {
                MatchesWriter.writeMembers(matches, fieldMatchesFile);
            }
            catch (IOException ex) {
                throw new Error(ex);
            }
        });
    }

    private static void convertMappings(File outMappingsFile, JarFile sourceJar, JarFile destJar, Mappings mappings, File classMatchesFile, File fieldMatchesFile) throws IOException, MappingConflict {
        System.out.println("Reading matches...");
        ClassMatches classMatches = MatchesReader.readClasses(classMatchesFile);
        MemberMatches fieldMatches = MatchesReader.readMembers(fieldMatchesFile);
        Deobfuscators deobfuscators = new Deobfuscators(sourceJar, destJar);
        deobfuscators.source.setMappings(mappings);
        Mappings newMappings = MappingsConverter.newMappings(classMatches, mappings, deobfuscators.source, deobfuscators.dest);
        MappingsConverter.applyMemberMatches(newMappings, classMatches, fieldMatches, MappingsConverter.getFieldDoer());
        new MappingsEnigmaWriter().write(outMappingsFile, newMappings, true);
        System.out.println("Wrote converted mappings to:\n\t" + outMappingsFile.getAbsolutePath());
    }

    private static void computeMethodMatches(File outMappingsFile, JarFile sourceJar, JarFile destJar, Mappings sourceMappings, File classMatchesFile, File fieldMatchesFile, File methodMatchesFile) throws IOException, MappingParseException {
        System.out.println("Reading class matches...");
        ClassMatches classMatches = MatchesReader.readClasses(classMatchesFile);
        System.out.println("Reading dest mappings...");
        Mappings destMappings = new MappingsEnigmaReader().read(outMappingsFile);
        System.out.println("Indexing dest jar...");
        Deobfuscator destDeobfuscator = new Deobfuscator(destJar);
        System.out.println("Indexing source jar...");
        Deobfuscator sourceDeobfuscator = new Deobfuscator(sourceJar);
        System.out.println("Writing method matches...");
        MemberMatches<BehaviorEntry> methodMatches = MappingsConverter.computeMethodsMatches(destDeobfuscator, destMappings, sourceDeobfuscator, sourceMappings, classMatches, MappingsConverter.getMethodDoer());
        MatchesWriter.writeMembers(methodMatches, methodMatchesFile);
        System.out.println("Wrote:\n\t" + methodMatchesFile.getAbsolutePath());
    }

    private static void editMethodMatches(JarFile sourceJar, JarFile destJar, File destMappingsFile, Mappings sourceMappings, File classMatchesFile, File methodMatchesFile) throws IOException, MappingParseException {
        System.out.println("Reading matches...");
        ClassMatches classMatches = MatchesReader.readClasses(classMatchesFile);
        MemberMatches methodMatches = MatchesReader.readMembers(methodMatchesFile);
        Deobfuscators deobfuscators = new Deobfuscators(sourceJar, destJar);
        deobfuscators.source.setMappings(sourceMappings);
        Mappings destMappings = new MappingsEnigmaReader().read(destMappingsFile);
        MappingsChecker checker = new MappingsChecker(deobfuscators.dest.getJarIndex());
        checker.dropBrokenMappings(destMappings);
        deobfuscators.dest.setMappings(destMappings);
        new MemberMatchingGui(classMatches, methodMatches, deobfuscators.source, deobfuscators.dest).setSaveListener(matches -> {
            try {
                MatchesWriter.writeMembers(matches, methodMatchesFile);
            }
            catch (IOException ex) {
                throw new Error(ex);
            }
        });
    }

    private static void convertMappings(File outMappingsFile, JarFile sourceJar, JarFile destJar, Mappings mappings, File classMatchesFile, File fieldMatchesFile, File methodMatchesFile) throws IOException, MappingConflict {
        System.out.println("Reading matches...");
        ClassMatches classMatches = MatchesReader.readClasses(classMatchesFile);
        MemberMatches fieldMatches = MatchesReader.readMembers(fieldMatchesFile);
        MemberMatches methodMatches = MatchesReader.readMembers(methodMatchesFile);
        Deobfuscators deobfuscators = new Deobfuscators(sourceJar, destJar);
        deobfuscators.source.setMappings(mappings);
        Mappings newMappings = MappingsConverter.newMappings(classMatches, mappings, deobfuscators.source, deobfuscators.dest);
        MappingsConverter.applyMemberMatches(newMappings, classMatches, fieldMatches, MappingsConverter.getFieldDoer());
        MappingsConverter.applyMemberMatches(newMappings, classMatches, methodMatches, MappingsConverter.getMethodDoer());
        MappingsChecker checker = new MappingsChecker(deobfuscators.dest.getJarIndex());
        checker.dropBrokenMappings(newMappings);
        for (Map.Entry<ClassEntry, ClassMapping> entry : checker.getDroppedClassMappings().entrySet()) {
            System.out.println("WARNING: Broken class entry " + entry.getKey() + " (" + entry.getValue().getDeobfName() + ")");
        }
        for (Map.Entry<ClassEntry, ClassMapping> entry : checker.getDroppedInnerClassMappings().entrySet()) {
            System.out.println("WARNING: Broken inner class entry " + entry.getKey() + " (" + entry.getValue().getDeobfName() + ")");
        }
        for (Map.Entry<Entry, Comparable<ClassMapping>> entry : checker.getDroppedFieldMappings().entrySet()) {
            System.out.println("WARNING: Broken field entry " + entry.getKey() + " (" + ((FieldMapping)entry.getValue()).getDeobfName() + ")");
        }
        for (Map.Entry<Entry, Comparable<ClassMapping>> entry : checker.getDroppedMethodMappings().entrySet()) {
            System.out.println("WARNING: Broken behavior entry " + entry.getKey() + " (" + ((MethodMapping)entry.getValue()).getDeobfName() + ")");
        }
        new MappingsEnigmaWriter().write(outMappingsFile, newMappings, true);
        System.out.println("Wrote converted mappings to:\n\t" + outMappingsFile.getAbsolutePath());
    }

    private static class IndexerThread
    extends Thread {
        public Deobfuscator deobfuscator;
        private JarFile jarFile;

        public IndexerThread(JarFile jarFile) {
            this.jarFile = jarFile;
            this.deobfuscator = null;
        }

        public void joinOrBail() {
            try {
                this.join();
            }
            catch (InterruptedException ex) {
                throw new Error(ex);
            }
        }

        @Override
        public void run() {
            this.deobfuscator = new Deobfuscator(this.jarFile);
        }
    }

    private static class Deobfuscators {
        public Deobfuscator source;
        public Deobfuscator dest;

        public Deobfuscators(JarFile sourceJar, JarFile destJar) {
            System.out.println("Indexing source jar...");
            IndexerThread sourceIndexer = new IndexerThread(sourceJar);
            sourceIndexer.start();
            System.out.println("Indexing dest jar...");
            IndexerThread destIndexer = new IndexerThread(destJar);
            destIndexer.start();
            sourceIndexer.joinOrBail();
            destIndexer.joinOrBail();
            this.source = sourceIndexer.deobfuscator;
            this.dest = destIndexer.deobfuscator;
        }
    }
}

