/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.strobel.assembler.metadata.Buffer;
import com.strobel.assembler.metadata.ClasspathTypeLoader;
import com.strobel.assembler.metadata.ITypeLoader;
import cuchaz.enigma.analysis.BridgeMarker;
import cuchaz.enigma.analysis.JarIndex;
import cuchaz.enigma.bytecode.ClassTranslator;
import cuchaz.enigma.bytecode.InnerClassWriter;
import cuchaz.enigma.bytecode.LocalVariableRenamer;
import cuchaz.enigma.bytecode.MethodParameterWriter;
import cuchaz.enigma.mapping.ClassEntry;
import cuchaz.enigma.mapping.Translator;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javassist.ByteArrayClassPath;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.NotFoundException;
import javassist.bytecode.Descriptor;

public class TranslatingTypeLoader
implements ITypeLoader {
    private JarFile jar;
    private JarIndex jarIndex;
    private Translator obfuscatingTranslator;
    private Translator deobfuscatingTranslator;
    private Map<String, byte[]> cache;
    private ClasspathTypeLoader defaultTypeLoader;

    public TranslatingTypeLoader(JarFile jar, JarIndex jarIndex, Translator obfuscatingTranslator, Translator deobfuscatingTranslator) {
        this.jar = jar;
        this.jarIndex = jarIndex;
        this.obfuscatingTranslator = obfuscatingTranslator;
        this.deobfuscatingTranslator = deobfuscatingTranslator;
        this.cache = Maps.newHashMap();
        this.defaultTypeLoader = new ClasspathTypeLoader();
    }

    public void clearCache() {
        this.cache.clear();
    }

    @Override
    public boolean tryLoadType(String className, Buffer out) {
        byte[] data;
        if (this.cache.containsKey(className)) {
            data = this.cache.get(className);
        } else {
            data = this.loadType(className);
            this.cache.put(className, data);
        }
        if (data == null) {
            return this.defaultTypeLoader.tryLoadType(className, out);
        }
        out.reset(data.length);
        System.arraycopy(data, 0, out.array(), out.position(), data.length);
        out.position(0);
        return true;
    }

    public CtClass loadClass(String deobfClassName) {
        byte[] data = this.loadType(deobfClassName);
        if (data == null) {
            return null;
        }
        String javaClassFileName = Descriptor.toJavaName(deobfClassName);
        ClassPool classPool = new ClassPool();
        classPool.insertClassPath(new ByteArrayClassPath(javaClassFileName, data));
        try {
            return classPool.get(javaClassFileName);
        }
        catch (NotFoundException ex) {
            throw new Error(ex);
        }
    }

    private byte[] loadType(String className) {
        List<ClassEntry> classChain;
        ClassEntry classEntry = new ClassEntry(className);
        ClassEntry obfClassEntry = this.obfuscatingTranslator.translateEntry(classEntry);
        if (!obfClassEntry.isInnerClass() && (classChain = this.jarIndex.getObfClassChain(obfClassEntry)).size() > 1) {
            System.err.println(String.format("WARNING: no class %s after inner class reconstruction. Try %s", className, obfClassEntry.buildClassEntry(classChain)));
            return null;
        }
        if (!this.jarIndex.containsObfClass(obfClassEntry)) {
            return null;
        }
        String classInJarName = this.findClassInJar(obfClassEntry);
        if (classInJarName == null) {
            return null;
        }
        try {
            int bytesRead;
            ByteArrayOutputStream data = new ByteArrayOutputStream();
            byte[] buf = new byte[0x100000];
            InputStream in = this.jar.getInputStream(this.jar.getJarEntry(classInJarName + ".class"));
            while ((bytesRead = in.read(buf)) > 0) {
                data.write(buf, 0, bytesRead);
            }
            data.close();
            in.close();
            buf = data.toByteArray();
            ClassPool classPool = new ClassPool();
            String classInJarJavaName = Descriptor.toJavaName(classInJarName);
            classPool.insertClassPath(new ByteArrayClassPath(classInJarJavaName, buf));
            CtClass c = classPool.get(classInJarJavaName);
            c = this.transformClass(c);
            this.assertClassName(c, classEntry);
            return c.toBytecode();
        }
        catch (IOException | CannotCompileException | NotFoundException ex) {
            throw new Error(ex);
        }
    }

    private String findClassInJar(ClassEntry obfClassEntry) {
        for (String className : this.getClassNamesToTry(obfClassEntry)) {
            JarEntry jarEntry = this.jar.getJarEntry(className + ".class");
            if (jarEntry == null) continue;
            return className;
        }
        return null;
    }

    public List<String> getClassNamesToTry(String className) {
        return this.getClassNamesToTry(this.obfuscatingTranslator.translateEntry(new ClassEntry(className)));
    }

    public List<String> getClassNamesToTry(ClassEntry obfClassEntry) {
        ArrayList<String> classNamesToTry = Lists.newArrayList();
        classNamesToTry.add(obfClassEntry.getName());
        if (obfClassEntry.isInnerClass()) {
            classNamesToTry.add(obfClassEntry.getInnermostClassName());
        }
        return classNamesToTry;
    }

    public CtClass transformClass(CtClass c) throws IOException, NotFoundException, CannotCompileException {
        new InnerClassWriter(this.jarIndex, this.deobfuscatingTranslator).write(c);
        ClassEntry obfClassEntry = new ClassEntry(Descriptor.toJvmName(c.getName()));
        String javaClassReconstructedName = Descriptor.toJavaName(obfClassEntry.getName());
        ClassPool classPool = new ClassPool();
        classPool.insertClassPath(new ByteArrayClassPath(javaClassReconstructedName, c.toBytecode()));
        c = classPool.get(javaClassReconstructedName);
        this.assertClassName(c, obfClassEntry);
        new BridgeMarker(this.jarIndex).markBridges(c);
        new MethodParameterWriter(this.deobfuscatingTranslator).writeMethodArguments(c);
        new LocalVariableRenamer(this.deobfuscatingTranslator).rename(c);
        new ClassTranslator(this.deobfuscatingTranslator).translate(c);
        return c;
    }

    private void assertClassName(CtClass c, ClassEntry obfClassEntry) {
        String name1 = Descriptor.toJvmName(c.getName());
        assert (name1.equals(obfClassEntry.getName())) : String.format("Looking for %s, instead found %s", obfClassEntry.getName(), name1);
        String name2 = Descriptor.toJvmName(c.getClassFile().getName());
        assert (name2.equals(obfClassEntry.getName())) : String.format("Looking for %s, instead found %s", obfClassEntry.getName(), name2);
    }
}

