/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.analysis;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import cuchaz.enigma.analysis.Access;
import cuchaz.enigma.analysis.ClassImplementationsTreeNode;
import cuchaz.enigma.analysis.ClassInheritanceTreeNode;
import cuchaz.enigma.analysis.EntryReference;
import cuchaz.enigma.analysis.EntryRenamer;
import cuchaz.enigma.analysis.JarClassIterator;
import cuchaz.enigma.analysis.MethodImplementationsTreeNode;
import cuchaz.enigma.analysis.MethodInheritanceTreeNode;
import cuchaz.enigma.analysis.TranslationIndex;
import cuchaz.enigma.mapping.ArgumentEntry;
import cuchaz.enigma.mapping.BehaviorEntry;
import cuchaz.enigma.mapping.ClassEntry;
import cuchaz.enigma.mapping.ConstructorEntry;
import cuchaz.enigma.mapping.Entry;
import cuchaz.enigma.mapping.EntryFactory;
import cuchaz.enigma.mapping.FieldEntry;
import cuchaz.enigma.mapping.LocalVariableEntry;
import cuchaz.enigma.mapping.MethodEntry;
import cuchaz.enigma.mapping.Translator;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarFile;
import javassist.CannotCompileException;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMember;
import javassist.CtMethod;
import javassist.NotFoundException;
import javassist.bytecode.Descriptor;
import javassist.bytecode.EnclosingMethodAttribute;
import javassist.bytecode.FieldInfo;
import javassist.bytecode.InnerClassesAttribute;
import javassist.expr.ConstructorCall;
import javassist.expr.ExprEditor;
import javassist.expr.FieldAccess;
import javassist.expr.MethodCall;
import javassist.expr.NewExpr;

public class JarIndex {
    private Set<ClassEntry> obfClassEntries = Sets.newHashSet();
    private TranslationIndex translationIndex = new TranslationIndex();
    private Map<Entry, Access> access = Maps.newHashMap();
    private Multimap<ClassEntry, FieldEntry> fields = HashMultimap.create();
    private Multimap<ClassEntry, BehaviorEntry> behaviors = HashMultimap.create();
    private Multimap<String, MethodEntry> methodImplementations = HashMultimap.create();
    private Multimap<BehaviorEntry, EntryReference<BehaviorEntry, BehaviorEntry>> behaviorReferences = HashMultimap.create();
    private Multimap<FieldEntry, EntryReference<FieldEntry, BehaviorEntry>> fieldReferences = HashMultimap.create();
    private Multimap<ClassEntry, ClassEntry> innerClassesByOuter = HashMultimap.create();
    private Map<ClassEntry, ClassEntry> outerClassesByInner = Maps.newHashMap();
    private Map<ClassEntry, BehaviorEntry> anonymousClasses = Maps.newHashMap();
    private Map<MethodEntry, MethodEntry> bridgedMethods = Maps.newHashMap();
    private Set<MethodEntry> syntheticMethods = Sets.newHashSet();

    public void indexJar(JarFile jar, boolean buildInnerClasses) {
        int n;
        this.obfClassEntries.addAll(JarClassIterator.getClassEntries(jar));
        for (CtClass c : JarClassIterator.classes(jar)) {
            for (CtField field : c.getDeclaredFields()) {
                FieldEntry fieldEntry = EntryFactory.getFieldEntry(field);
                this.access.put(fieldEntry, Access.get(field));
                this.fields.put(fieldEntry.getClassEntry(), fieldEntry);
            }
            CtMember[] ctMemberArray = c.getDeclaredBehaviors();
            int n2 = ctMemberArray.length;
            for (n = 0; n < n2; ++n) {
                CtMember behavior = ctMemberArray[n];
                BehaviorEntry behaviorEntry = EntryFactory.getBehaviorEntry((CtBehavior)behavior);
                this.access.put(behaviorEntry, Access.get((CtBehavior)behavior));
                this.behaviors.put(behaviorEntry.getClassEntry(), behaviorEntry);
            }
        }
        for (CtClass c : JarClassIterator.classes(jar)) {
            this.translationIndex.indexClass(c);
            Object className = Descriptor.toJvmName(c.getName());
            for (String interfaceName : c.getClassFile().getInterfaces()) {
                if (!((String)(className = Descriptor.toJvmName((String)className))).equals(interfaceName = Descriptor.toJvmName(interfaceName))) continue;
                throw new IllegalArgumentException("Class cannot be its own interface! " + (String)className);
            }
            Object[] objectArray = c.getDeclaredBehaviors();
            n = objectArray.length;
            for (int behavior = 0; behavior < n; ++behavior) {
                Object behavior2 = objectArray[behavior];
                this.indexBehavior((CtBehavior)behavior2);
            }
        }
        for (CtClass c : JarClassIterator.classes(jar)) {
            for (CtBehavior behavior : c.getDeclaredBehaviors()) {
                this.indexBehaviorReferences(behavior);
            }
        }
        if (buildInnerClasses) {
            for (CtClass c : JarClassIterator.classes(jar)) {
                boolean innerWasAdded;
                ClassEntry innerClassEntry = EntryFactory.getClassEntry(c);
                ClassEntry outerClassEntry = this.findOuterClass(c);
                if (outerClassEntry == null) continue;
                this.innerClassesByOuter.put(outerClassEntry, innerClassEntry);
                boolean bl = innerWasAdded = this.outerClassesByInner.put(innerClassEntry, outerClassEntry) == null;
                assert (innerWasAdded);
                BehaviorEntry enclosingBehavior = this.isAnonymousClass(c, outerClassEntry);
                if (enclosingBehavior == null) continue;
                this.anonymousClasses.put(innerClassEntry, enclosingBehavior);
            }
            HashMap<String, String> renames = Maps.newHashMap();
            for (ClassEntry innerClassEntry : this.innerClassesByOuter.values()) {
                String newName = innerClassEntry.buildClassEntry(this.getObfClassChain(innerClassEntry)).getName();
                if (innerClassEntry.getName().equals(newName)) continue;
                renames.put(innerClassEntry.getName(), newName);
            }
            EntryRenamer.renameClassesInSet(renames, this.obfClassEntries);
            this.translationIndex.renameClasses(renames);
            EntryRenamer.renameClassesInMultimap(renames, this.methodImplementations);
            EntryRenamer.renameClassesInMultimap(renames, this.behaviorReferences);
            EntryRenamer.renameClassesInMultimap(renames, this.fieldReferences);
            EntryRenamer.renameClassesInMap(renames, this.access);
        }
    }

    private void indexBehavior(CtBehavior behavior) {
        BehaviorEntry behaviorEntry = EntryFactory.getBehaviorEntry(behavior);
        if (behaviorEntry instanceof MethodEntry) {
            MethodEntry methodEntry = (MethodEntry)behaviorEntry;
            if ((behavior.getModifiers() & 0x1000) != 0) {
                this.syntheticMethods.add(methodEntry);
            }
            this.methodImplementations.put(behaviorEntry.getClassName(), methodEntry);
            CtMethod bridgedMethod = this.getBridgedMethod((CtMethod)behavior);
            if (bridgedMethod != null) {
                this.bridgedMethods.put(methodEntry, EntryFactory.getMethodEntry(bridgedMethod));
            }
        }
    }

    private void indexBehaviorReferences(CtBehavior behavior) {
        final BehaviorEntry behaviorEntry = EntryFactory.getBehaviorEntry(behavior);
        try {
            behavior.instrument(new ExprEditor(){

                @Override
                public void edit(MethodCall call) {
                    MethodEntry calledMethodEntry = EntryFactory.getMethodEntry(call);
                    ClassEntry resolvedClassEntry = JarIndex.this.translationIndex.resolveEntryClass(calledMethodEntry);
                    if (resolvedClassEntry != null && !resolvedClassEntry.equals(calledMethodEntry.getClassEntry())) {
                        calledMethodEntry = new MethodEntry(resolvedClassEntry, calledMethodEntry.getName(), calledMethodEntry.getSignature());
                    }
                    EntryReference<MethodEntry, BehaviorEntry> reference = new EntryReference<MethodEntry, BehaviorEntry>(calledMethodEntry, call.getMethodName(), behaviorEntry);
                    JarIndex.this.behaviorReferences.put(calledMethodEntry, reference);
                }

                @Override
                public void edit(FieldAccess call) {
                    FieldEntry calledFieldEntry = EntryFactory.getFieldEntry(call);
                    ClassEntry resolvedClassEntry = JarIndex.this.translationIndex.resolveEntryClass(calledFieldEntry);
                    if (resolvedClassEntry != null && !resolvedClassEntry.equals(calledFieldEntry.getClassEntry())) {
                        calledFieldEntry = new FieldEntry(calledFieldEntry, resolvedClassEntry);
                    }
                    EntryReference<FieldEntry, BehaviorEntry> reference = new EntryReference<FieldEntry, BehaviorEntry>(calledFieldEntry, call.getFieldName(), behaviorEntry);
                    JarIndex.this.fieldReferences.put(calledFieldEntry, reference);
                }

                @Override
                public void edit(ConstructorCall call) {
                    ConstructorEntry calledConstructorEntry = EntryFactory.getConstructorEntry(call);
                    EntryReference<ConstructorEntry, BehaviorEntry> reference = new EntryReference<ConstructorEntry, BehaviorEntry>(calledConstructorEntry, call.getMethodName(), behaviorEntry);
                    JarIndex.this.behaviorReferences.put(calledConstructorEntry, reference);
                }

                @Override
                public void edit(NewExpr call) {
                    ConstructorEntry calledConstructorEntry = EntryFactory.getConstructorEntry(call);
                    EntryReference<ConstructorEntry, BehaviorEntry> reference = new EntryReference<ConstructorEntry, BehaviorEntry>(calledConstructorEntry, call.getClassName(), behaviorEntry);
                    JarIndex.this.behaviorReferences.put(calledConstructorEntry, reference);
                }
            });
        }
        catch (CannotCompileException ex) {
            throw new Error(ex);
        }
    }

    private CtMethod getBridgedMethod(CtMethod method) {
        if ((method.getModifiers() & 0x1000) == 0) {
            return null;
        }
        final ArrayList methodCalls = Lists.newArrayList();
        try {
            method.instrument(new ExprEditor(){

                @Override
                public void edit(MethodCall call) {
                    methodCalls.add(call);
                }
            });
        }
        catch (CannotCompileException ex) {
            throw new Error(ex);
        }
        if (methodCalls.size() != 1) {
            return null;
        }
        MethodCall call = (MethodCall)methodCalls.get(0);
        try {
            return call.getMethod();
        }
        catch (NotFoundException ex) {
            return null;
        }
    }

    private ClassEntry findOuterClass(CtClass c) {
        ClassEntry classEntry = EntryFactory.getClassEntry(c);
        if (classEntry.isInnerClass()) {
            return classEntry.getOuterClassEntry();
        }
        for (CtConstructor constructor : c.getDeclaredConstructors()) {
            HashSet<String> syntheticFieldTypes = Sets.newHashSet();
            if (!this.isIllegalConstructor(syntheticFieldTypes, constructor)) continue;
            ConstructorEntry constructorEntry = EntryFactory.getConstructorEntry(constructor);
            HashSet<ClassEntry> illegallySetClasses = Sets.newHashSet();
            for (String string : syntheticFieldTypes) {
                ClassEntry outerClassEntry;
                if (!string.startsWith("L") || !this.isSaneOuterClass(outerClassEntry = new ClassEntry(string.substring(1, string.length() - 1)), classEntry)) continue;
                illegallySetClasses.add(outerClassEntry);
            }
            HashSet<ClassEntry> callerClasses = Sets.newHashSet();
            for (EntryReference<BehaviorEntry, BehaviorEntry> reference : this.getBehaviorReferences(constructorEntry)) {
                if (reference.entry instanceof ConstructorEntry && reference.context instanceof ConstructorEntry) {
                    ClassEntry calledClassEntry = ((BehaviorEntry)reference.entry).getClassEntry();
                    ClassEntry superclassEntry = this.translationIndex.getSuperclass(((BehaviorEntry)reference.context).getClassEntry());
                    if (superclassEntry != null && superclassEntry.equals(calledClassEntry)) continue;
                }
                if (!this.isSaneOuterClass(((BehaviorEntry)reference.context).getClassEntry(), classEntry)) continue;
                callerClasses.add(((BehaviorEntry)reference.context).getClassEntry());
            }
            if (callerClasses.isEmpty()) {
                if (illegallySetClasses.size() == 1) {
                    return (ClassEntry)illegallySetClasses.iterator().next();
                }
                System.out.println(String.format("WARNING: Unable to find outer class for %s. No caller and no illegally set field classes.", classEntry));
                continue;
            }
            if (callerClasses.size() == 1) {
                return (ClassEntry)callerClasses.iterator().next();
            }
            HashSet hashSet = Sets.newHashSet(callerClasses);
            hashSet.retainAll(illegallySetClasses);
            if (hashSet.size() == 1) {
                return (ClassEntry)hashSet.iterator().next();
            }
            System.out.println(String.format("WARNING: Unable to choose outer class for %s among options: %s", classEntry, callerClasses));
        }
        return null;
    }

    private boolean isSaneOuterClass(ClassEntry outerClassEntry, ClassEntry innerClassEntry) {
        if (outerClassEntry.equals(innerClassEntry)) {
            return false;
        }
        return this.obfClassEntries.contains(outerClassEntry);
    }

    private boolean isIllegalConstructor(Set<String> syntheticFieldTypes, CtConstructor constructor) {
        String className = constructor.getDeclaringClass().getName();
        final ArrayList<FieldAccess> illegalFieldWrites = Lists.newArrayList();
        final ArrayList constructorCalls = Lists.newArrayList();
        try {
            constructor.instrument(new ExprEditor(){

                @Override
                public void edit(FieldAccess fieldAccess) {
                    if (fieldAccess.isWriter() && constructorCalls.isEmpty()) {
                        illegalFieldWrites.add(fieldAccess);
                    }
                }

                @Override
                public void edit(ConstructorCall constructorCall) {
                    constructorCalls.add(constructorCall);
                }
            });
        }
        catch (CannotCompileException ex) {
            throw new Error(ex);
        }
        if (illegalFieldWrites.isEmpty()) {
            return false;
        }
        for (FieldAccess fieldWrite : illegalFieldWrites) {
            boolean isSynthetic;
            if (!fieldWrite.getClassName().equals(className)) {
                System.err.println(String.format("WARNING: illegal write to non-member field %s.%s", fieldWrite.getClassName(), fieldWrite.getFieldName()));
                return false;
            }
            FieldInfo fieldInfo = null;
            for (FieldInfo info : constructor.getDeclaringClass().getClassFile().getFields()) {
                if (!info.getName().equals(fieldWrite.getFieldName()) || !info.getDescriptor().equals(fieldWrite.getSignature())) continue;
                fieldInfo = info;
                break;
            }
            if (fieldInfo == null) {
                return false;
            }
            boolean bl = isSynthetic = (fieldInfo.getAccessFlags() & 0x1000) != 0;
            if (isSynthetic) {
                syntheticFieldTypes.add(fieldInfo.getDescriptor());
                continue;
            }
            System.err.println(String.format("WARNING: illegal write to non synthetic field %s %s.%s", fieldInfo.getDescriptor(), className, fieldInfo.getName()));
            return false;
        }
        return true;
    }

    private BehaviorEntry isAnonymousClass(CtClass c, ClassEntry outerClassEntry) {
        EnclosingMethodAttribute enclosingMethodAttribute = (EnclosingMethodAttribute)c.getClassFile().getAttribute("EnclosingMethod");
        if (enclosingMethodAttribute != null) {
            if (enclosingMethodAttribute.methodIndex() > 0) {
                return EntryFactory.getBehaviorEntry(Descriptor.toJvmName(enclosingMethodAttribute.className()), enclosingMethodAttribute.methodName(), enclosingMethodAttribute.methodDescriptor());
            }
            return null;
        }
        InnerClassesAttribute innerClassesAttribute = (InnerClassesAttribute)c.getClassFile().getAttribute("InnerClasses");
        if (innerClassesAttribute != null) {
            return null;
        }
        ClassEntry innerClassEntry = new ClassEntry(Descriptor.toJvmName(c.getName()));
        if (Modifier.isAbstract(c.getModifiers())) {
            return null;
        }
        if (c.getDeclaredConstructors().length != 1) {
            return null;
        }
        CtConstructor constructor = c.getDeclaredConstructors()[0];
        ConstructorEntry constructorEntry = EntryFactory.getConstructorEntry(constructor);
        Collection<EntryReference<BehaviorEntry, BehaviorEntry>> references = this.getBehaviorReferences(constructorEntry);
        if (references.size() != 1) {
            return null;
        }
        BehaviorEntry caller = (BehaviorEntry)references.iterator().next().context;
        for (FieldEntry fieldEntry : this.getReferencedFields(caller)) {
            if (!fieldEntry.getType().hasClass() || !fieldEntry.getType().getClassEntry().equals(innerClassEntry)) continue;
            return null;
        }
        for (BehaviorEntry behaviorEntry : this.getReferencedBehaviors(caller)) {
            if (!behaviorEntry.getSignature().hasClass(innerClassEntry)) continue;
            return null;
        }
        return caller;
    }

    public Set<ClassEntry> getObfClassEntries() {
        return this.obfClassEntries;
    }

    public Collection<FieldEntry> getObfFieldEntries() {
        return this.fields.values();
    }

    public Collection<FieldEntry> getObfFieldEntries(ClassEntry classEntry) {
        return this.fields.get(classEntry);
    }

    public Collection<BehaviorEntry> getObfBehaviorEntries() {
        return this.behaviors.values();
    }

    public Collection<BehaviorEntry> getObfBehaviorEntries(ClassEntry classEntry) {
        return this.behaviors.get(classEntry);
    }

    public TranslationIndex getTranslationIndex() {
        return this.translationIndex;
    }

    public Access getAccess(Entry entry) {
        return this.access.get(entry);
    }

    public ClassInheritanceTreeNode getClassInheritance(Translator deobfuscatingTranslator, ClassEntry obfClassEntry) {
        ArrayList<String> ancestry = Lists.newArrayList();
        ancestry.add(obfClassEntry.getName());
        for (ClassEntry classEntry : this.translationIndex.getAncestry(obfClassEntry)) {
            if (!this.containsObfClass(classEntry)) continue;
            ancestry.add(classEntry.getName());
        }
        ClassInheritanceTreeNode rootNode = new ClassInheritanceTreeNode(deobfuscatingTranslator, (String)ancestry.get(ancestry.size() - 1));
        rootNode.load(this.translationIndex, true);
        return rootNode;
    }

    public ClassImplementationsTreeNode getClassImplementations(Translator deobfuscatingTranslator, ClassEntry obfClassEntry) {
        if (this.isInterface(obfClassEntry.getClassName())) {
            ClassImplementationsTreeNode node = new ClassImplementationsTreeNode(deobfuscatingTranslator, obfClassEntry);
            node.load(this);
            return node;
        }
        return null;
    }

    public MethodInheritanceTreeNode getMethodInheritance(Translator deobfuscatingTranslator, MethodEntry obfMethodEntry) {
        ClassEntry baseImplementationClassEntry = obfMethodEntry.getClassEntry();
        for (ClassEntry ancestorClassEntry : this.translationIndex.getAncestry(obfMethodEntry.getClassEntry())) {
            MethodEntry ancestorMethodEntry = new MethodEntry(new ClassEntry(ancestorClassEntry), obfMethodEntry.getName(), obfMethodEntry.getSignature());
            if (!this.containsObfBehavior(ancestorMethodEntry)) continue;
            baseImplementationClassEntry = ancestorClassEntry;
        }
        MethodEntry methodEntry = new MethodEntry(baseImplementationClassEntry, obfMethodEntry.getName(), obfMethodEntry.getSignature());
        MethodInheritanceTreeNode rootNode = new MethodInheritanceTreeNode(deobfuscatingTranslator, methodEntry, this.containsObfBehavior(methodEntry));
        rootNode.load(this, true);
        return rootNode;
    }

    public List<MethodImplementationsTreeNode> getMethodImplementations(Translator deobfuscatingTranslator, MethodEntry obfMethodEntry) {
        ArrayList<MethodEntry> interfaceMethodEntries = Lists.newArrayList();
        if (this.isInterface(obfMethodEntry.getClassName())) {
            interfaceMethodEntries.add(obfMethodEntry);
        } else {
            for (ClassEntry interfaceEntry : this.getInterfaces(obfMethodEntry.getClassName())) {
                MethodEntry methodInterface = new MethodEntry(interfaceEntry, obfMethodEntry.getName(), obfMethodEntry.getSignature());
                if (!this.containsObfBehavior(methodInterface)) continue;
                interfaceMethodEntries.add(methodInterface);
            }
        }
        ArrayList<MethodImplementationsTreeNode> nodes = Lists.newArrayList();
        if (!interfaceMethodEntries.isEmpty()) {
            for (MethodEntry interfaceMethodEntry : interfaceMethodEntries) {
                MethodImplementationsTreeNode node = new MethodImplementationsTreeNode(deobfuscatingTranslator, interfaceMethodEntry);
                node.load(this);
                nodes.add(node);
            }
        }
        return nodes;
    }

    public Set<MethodEntry> getRelatedMethodImplementations(MethodEntry obfMethodEntry) {
        HashSet<MethodEntry> methodEntries = Sets.newHashSet();
        this.getRelatedMethodImplementations(methodEntries, this.getMethodInheritance(new Translator(), obfMethodEntry));
        return methodEntries;
    }

    private void getRelatedMethodImplementations(Set<MethodEntry> methodEntries, MethodInheritanceTreeNode node) {
        MethodEntry methodEntry = node.getMethodEntry();
        if (this.containsObfBehavior(methodEntry)) {
            methodEntries.add(methodEntry);
        }
        MethodEntry bridgedEntry = this.getBridgedMethod(methodEntry);
        while (bridgedEntry != null) {
            methodEntries.addAll(this.getRelatedMethodImplementations(bridgedEntry));
            bridgedEntry = this.getBridgedMethod(bridgedEntry);
        }
        for (MethodImplementationsTreeNode implementationsNode : this.getMethodImplementations(new Translator(), methodEntry)) {
            this.getRelatedMethodImplementations(methodEntries, implementationsNode);
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            this.getRelatedMethodImplementations(methodEntries, (MethodInheritanceTreeNode)node.getChildAt(i));
        }
    }

    private void getRelatedMethodImplementations(Set<MethodEntry> methodEntries, MethodImplementationsTreeNode node) {
        MethodEntry methodEntry = node.getMethodEntry();
        if (this.containsObfBehavior(methodEntry)) {
            methodEntries.add(methodEntry);
        }
        MethodEntry bridgedEntry = this.getBridgedMethod(methodEntry);
        while (bridgedEntry != null) {
            methodEntries.addAll(this.getRelatedMethodImplementations(bridgedEntry));
            bridgedEntry = this.getBridgedMethod(bridgedEntry);
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            this.getRelatedMethodImplementations(methodEntries, (MethodImplementationsTreeNode)node.getChildAt(i));
        }
    }

    public Collection<EntryReference<FieldEntry, BehaviorEntry>> getFieldReferences(FieldEntry fieldEntry) {
        return this.fieldReferences.get(fieldEntry);
    }

    public Collection<FieldEntry> getReferencedFields(BehaviorEntry behaviorEntry) {
        HashSet<FieldEntry> fieldEntries = Sets.newHashSet();
        for (EntryReference<FieldEntry, BehaviorEntry> reference : this.fieldReferences.values()) {
            if (reference.context != behaviorEntry) continue;
            fieldEntries.add((FieldEntry)reference.entry);
        }
        return fieldEntries;
    }

    public Collection<EntryReference<BehaviorEntry, BehaviorEntry>> getBehaviorReferences(BehaviorEntry behaviorEntry) {
        return this.behaviorReferences.get(behaviorEntry);
    }

    public Collection<BehaviorEntry> getReferencedBehaviors(BehaviorEntry behaviorEntry) {
        HashSet<BehaviorEntry> behaviorEntries = Sets.newHashSet();
        for (EntryReference<BehaviorEntry, BehaviorEntry> reference : this.behaviorReferences.values()) {
            if (reference.context != behaviorEntry) continue;
            behaviorEntries.add((BehaviorEntry)reference.entry);
        }
        return behaviorEntries;
    }

    public Collection<ClassEntry> getInnerClasses(ClassEntry obfOuterClassEntry) {
        return this.innerClassesByOuter.get(obfOuterClassEntry);
    }

    public ClassEntry getOuterClass(ClassEntry obfInnerClassEntry) {
        return this.outerClassesByInner.get(obfInnerClassEntry);
    }

    public boolean isAnonymousClass(ClassEntry obfInnerClassEntry) {
        return this.anonymousClasses.containsKey(obfInnerClassEntry);
    }

    public boolean isSyntheticMethod(MethodEntry methodEntry) {
        return this.syntheticMethods.contains(methodEntry);
    }

    public BehaviorEntry getAnonymousClassCaller(ClassEntry obfInnerClassName) {
        return this.anonymousClasses.get(obfInnerClassName);
    }

    public Set<ClassEntry> getInterfaces(String className) {
        ClassEntry classEntry = new ClassEntry(className);
        HashSet<ClassEntry> interfaces = new HashSet<ClassEntry>();
        interfaces.addAll(this.translationIndex.getInterfaces(classEntry));
        for (ClassEntry ancestor : this.translationIndex.getAncestry(classEntry)) {
            interfaces.addAll(this.translationIndex.getInterfaces(ancestor));
        }
        return interfaces;
    }

    public Set<String> getImplementingClasses(String targetInterfaceName) {
        HashSet<String> classNames = Sets.newHashSet();
        for (Map.Entry<ClassEntry, ClassEntry> entry : this.translationIndex.getClassInterfaces()) {
            ClassEntry classEntry = entry.getKey();
            ClassEntry interfaceEntry = entry.getValue();
            if (!interfaceEntry.getName().equals(targetInterfaceName)) continue;
            String className = classEntry.getClassName();
            classNames.add(className);
            if (this.isInterface(className)) {
                classNames.addAll(this.getImplementingClasses(className));
            }
            this.translationIndex.getSubclassNamesRecursively(classNames, classEntry);
        }
        return classNames;
    }

    public boolean isInterface(String className) {
        return this.translationIndex.isInterface(new ClassEntry(className));
    }

    public boolean containsObfClass(ClassEntry obfClassEntry) {
        return this.obfClassEntries.contains(obfClassEntry);
    }

    public boolean containsObfField(FieldEntry obfFieldEntry) {
        return this.access.containsKey(obfFieldEntry);
    }

    public boolean containsObfBehavior(BehaviorEntry obfBehaviorEntry) {
        return this.access.containsKey(obfBehaviorEntry);
    }

    public boolean containsEntryWithSameName(Entry entry) {
        for (Entry target : this.access.keySet()) {
            if (!target.getName().equals(entry.getName()) || !entry.getClass().isInstance(target.getClass())) continue;
            return true;
        }
        return false;
    }

    public boolean containsObfArgument(ArgumentEntry obfArgumentEntry) {
        if (!this.containsObfBehavior(obfArgumentEntry.getBehaviorEntry())) {
            return false;
        }
        return obfArgumentEntry.getIndex() < obfArgumentEntry.getBehaviorEntry().getSignature().getArgumentTypes().size();
    }

    public boolean containsObfEntry(Entry obfEntry) {
        if (obfEntry instanceof ClassEntry) {
            return this.containsObfClass((ClassEntry)obfEntry);
        }
        if (obfEntry instanceof FieldEntry) {
            return this.containsObfField((FieldEntry)obfEntry);
        }
        if (obfEntry instanceof BehaviorEntry) {
            return this.containsObfBehavior((BehaviorEntry)obfEntry);
        }
        if (obfEntry instanceof ArgumentEntry) {
            return this.containsObfArgument((ArgumentEntry)obfEntry);
        }
        if (obfEntry instanceof LocalVariableEntry) {
            return false;
        }
        throw new Error("Entry type not supported: " + obfEntry.getClass().getName());
    }

    public MethodEntry getBridgedMethod(MethodEntry bridgeMethodEntry) {
        return this.bridgedMethods.get(bridgeMethodEntry);
    }

    public List<ClassEntry> getObfClassChain(ClassEntry obfClassEntry) {
        ClassEntry obfOuterClassEntry;
        ArrayList<ClassEntry> obfClassChain = Lists.newArrayList(obfClassEntry);
        ClassEntry checkClassEntry = obfClassEntry;
        while ((obfOuterClassEntry = this.getOuterClass(checkClassEntry)) != null) {
            obfClassChain.add(obfOuterClassEntry);
            checkClassEntry = obfOuterClassEntry;
        }
        Collections.reverse(obfClassChain);
        return obfClassChain;
    }
}

