/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.analysis;

import com.google.common.collect.Lists;
import cuchaz.enigma.analysis.JarIndex;
import cuchaz.enigma.mapping.ClassEntry;
import cuchaz.enigma.mapping.MethodEntry;
import cuchaz.enigma.mapping.Translator;
import java.util.ArrayList;
import javax.swing.tree.DefaultMutableTreeNode;

public class MethodImplementationsTreeNode
extends DefaultMutableTreeNode {
    private Translator deobfuscatingTranslator;
    private MethodEntry entry;

    public MethodImplementationsTreeNode(Translator deobfuscatingTranslator, MethodEntry entry) {
        if (entry == null) {
            throw new IllegalArgumentException("Entry cannot be null!");
        }
        this.deobfuscatingTranslator = deobfuscatingTranslator;
        this.entry = entry;
    }

    public static MethodImplementationsTreeNode findNode(MethodImplementationsTreeNode node, MethodEntry entry) {
        if (node.getMethodEntry().equals(entry)) {
            return node;
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            MethodImplementationsTreeNode foundNode = MethodImplementationsTreeNode.findNode((MethodImplementationsTreeNode)node.getChildAt(i), entry);
            if (foundNode == null) continue;
            return foundNode;
        }
        return null;
    }

    public MethodEntry getMethodEntry() {
        return this.entry;
    }

    public String getDeobfClassName() {
        return this.deobfuscatingTranslator.translateClass(this.entry.getClassName());
    }

    public String getDeobfMethodName() {
        return this.deobfuscatingTranslator.translate(this.entry);
    }

    @Override
    public String toString() {
        String methodName;
        String className = this.getDeobfClassName();
        if (className == null) {
            className = this.entry.getClassName();
        }
        if ((methodName = this.getDeobfMethodName()) == null) {
            methodName = this.entry.getName();
        }
        return className + "." + methodName + "()";
    }

    public void load(JarIndex index) {
        ArrayList<MethodImplementationsTreeNode> nodes = Lists.newArrayList();
        for (String implementingClassName : index.getImplementingClasses(this.entry.getClassName())) {
            MethodEntry methodEntry = new MethodEntry(new ClassEntry(implementingClassName), this.entry.getName(), this.entry.getSignature());
            if (!index.containsObfBehavior(methodEntry)) continue;
            nodes.add(new MethodImplementationsTreeNode(this.deobfuscatingTranslator, methodEntry));
        }
        nodes.forEach(this::add);
    }
}

