/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.analysis;

import com.google.common.collect.Lists;
import cuchaz.enigma.analysis.JarIndex;
import cuchaz.enigma.mapping.ClassEntry;
import cuchaz.enigma.mapping.MethodEntry;
import cuchaz.enigma.mapping.Translator;
import java.util.ArrayList;
import javax.swing.tree.DefaultMutableTreeNode;

public class MethodInheritanceTreeNode
extends DefaultMutableTreeNode {
    private Translator deobfuscatingTranslator;
    private MethodEntry entry;
    private boolean isImplemented;

    public MethodInheritanceTreeNode(Translator deobfuscatingTranslator, MethodEntry entry, boolean isImplemented) {
        this.deobfuscatingTranslator = deobfuscatingTranslator;
        this.entry = entry;
        this.isImplemented = isImplemented;
    }

    public static MethodInheritanceTreeNode findNode(MethodInheritanceTreeNode node, MethodEntry entry) {
        if (node.getMethodEntry().equals(entry)) {
            return node;
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            MethodInheritanceTreeNode foundNode = MethodInheritanceTreeNode.findNode((MethodInheritanceTreeNode)node.getChildAt(i), entry);
            if (foundNode == null) continue;
            return foundNode;
        }
        return null;
    }

    public MethodEntry getMethodEntry() {
        return this.entry;
    }

    public String getDeobfClassName() {
        return this.deobfuscatingTranslator.translateClass(this.entry.getClassName());
    }

    public String getDeobfMethodName() {
        return this.deobfuscatingTranslator.translate(this.entry);
    }

    public boolean isImplemented() {
        return this.isImplemented;
    }

    @Override
    public String toString() {
        String className = this.getDeobfClassName();
        if (className == null) {
            className = this.entry.getClassName();
        }
        if (!this.isImplemented) {
            return className;
        }
        String methodName = this.getDeobfMethodName();
        if (methodName == null) {
            methodName = this.entry.getName();
        }
        return className + "." + methodName + "()";
    }

    public void load(JarIndex index, boolean recurse) {
        ArrayList<MethodInheritanceTreeNode> nodes = Lists.newArrayList();
        for (ClassEntry subclassEntry : index.getTranslationIndex().getSubclass(this.entry.getClassEntry())) {
            MethodEntry methodEntry = new MethodEntry(subclassEntry, this.entry.getName(), this.entry.getSignature());
            nodes.add(new MethodInheritanceTreeNode(this.deobfuscatingTranslator, methodEntry, index.containsObfBehavior(methodEntry)));
        }
        nodes.forEach(this::add);
        if (recurse) {
            for (MethodInheritanceTreeNode node : nodes) {
                node.load(index, true);
            }
        }
    }
}

