/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.bytecode;

import com.google.common.collect.Maps;
import cuchaz.enigma.bytecode.ConstPoolEditor;
import cuchaz.enigma.bytecode.accessors.ClassInfoAccessor;
import cuchaz.enigma.bytecode.accessors.ConstInfoAccessor;
import cuchaz.enigma.bytecode.accessors.InvokeDynamicInfoAccessor;
import cuchaz.enigma.bytecode.accessors.MemberRefInfoAccessor;
import cuchaz.enigma.bytecode.accessors.MethodHandleInfoAccessor;
import cuchaz.enigma.bytecode.accessors.MethodTypeInfoAccessor;
import cuchaz.enigma.bytecode.accessors.NameAndTypeInfoAccessor;
import cuchaz.enigma.bytecode.accessors.StringInfoAccessor;
import java.util.Collection;
import java.util.Map;

public enum InfoType {
    Utf8Info(1),
    IntegerInfo(3),
    FloatInfo(4),
    LongInfo(5),
    DoubleInfo(6),
    ClassInfo(7){

        @Override
        public void gatherIndexTree(Collection<Integer> indices, ConstPoolEditor editor, ConstInfoAccessor entry) {
            ClassInfoAccessor accessor = new ClassInfoAccessor(entry.getItem());
            1.gatherIndexTree(indices, editor, accessor.getNameIndex());
        }

        @Override
        public void remapIndices(Map<Integer, Integer> map, ConstInfoAccessor entry) {
            ClassInfoAccessor accessor = new ClassInfoAccessor(entry.getItem());
            accessor.setNameIndex(InfoType.remapIndex(map, accessor.getNameIndex()));
        }

        @Override
        public boolean subIndicesAreValid(ConstInfoAccessor entry, ConstPoolEditor pool) {
            ClassInfoAccessor accessor = new ClassInfoAccessor(entry.getItem());
            ConstInfoAccessor nameEntry = pool.getItem(accessor.getNameIndex());
            return nameEntry != null && nameEntry.getTag() == Utf8Info.getTag();
        }
    }
    ,
    StringInfo(8){

        @Override
        public void gatherIndexTree(Collection<Integer> indices, ConstPoolEditor editor, ConstInfoAccessor entry) {
            StringInfoAccessor accessor = new StringInfoAccessor(entry.getItem());
            2.gatherIndexTree(indices, editor, accessor.getStringIndex());
        }

        @Override
        public void remapIndices(Map<Integer, Integer> map, ConstInfoAccessor entry) {
            StringInfoAccessor accessor = new StringInfoAccessor(entry.getItem());
            accessor.setStringIndex(InfoType.remapIndex(map, accessor.getStringIndex()));
        }

        @Override
        public boolean subIndicesAreValid(ConstInfoAccessor entry, ConstPoolEditor pool) {
            StringInfoAccessor accessor = new StringInfoAccessor(entry.getItem());
            ConstInfoAccessor stringEntry = pool.getItem(accessor.getStringIndex());
            return stringEntry != null && stringEntry.getTag() == Utf8Info.getTag();
        }
    }
    ,
    FieldRefInfo(9){

        @Override
        public void gatherIndexTree(Collection<Integer> indices, ConstPoolEditor editor, ConstInfoAccessor entry) {
            MemberRefInfoAccessor accessor = new MemberRefInfoAccessor(entry.getItem());
            3.gatherIndexTree(indices, editor, accessor.getClassIndex());
            3.gatherIndexTree(indices, editor, accessor.getNameAndTypeIndex());
        }

        @Override
        public void remapIndices(Map<Integer, Integer> map, ConstInfoAccessor entry) {
            MemberRefInfoAccessor accessor = new MemberRefInfoAccessor(entry.getItem());
            accessor.setClassIndex(InfoType.remapIndex(map, accessor.getClassIndex()));
            accessor.setNameAndTypeIndex(InfoType.remapIndex(map, accessor.getNameAndTypeIndex()));
        }

        @Override
        public boolean subIndicesAreValid(ConstInfoAccessor entry, ConstPoolEditor pool) {
            MemberRefInfoAccessor accessor = new MemberRefInfoAccessor(entry.getItem());
            ConstInfoAccessor classEntry = pool.getItem(accessor.getClassIndex());
            ConstInfoAccessor nameAndTypeEntry = pool.getItem(accessor.getNameAndTypeIndex());
            return classEntry != null && classEntry.getTag() == ClassInfo.getTag() && nameAndTypeEntry != null && nameAndTypeEntry.getTag() == NameAndTypeInfo.getTag();
        }
    }
    ,
    MethodRefInfo(10){

        @Override
        public void gatherIndexTree(Collection<Integer> indices, ConstPoolEditor editor, ConstInfoAccessor entry) {
            FieldRefInfo.gatherIndexTree(indices, editor, entry);
        }

        @Override
        public void remapIndices(Map<Integer, Integer> map, ConstInfoAccessor entry) {
            FieldRefInfo.remapIndices(map, entry);
        }

        @Override
        public boolean subIndicesAreValid(ConstInfoAccessor entry, ConstPoolEditor pool) {
            return FieldRefInfo.subIndicesAreValid(entry, pool);
        }
    }
    ,
    InterfaceMethodRefInfo(11){

        @Override
        public void gatherIndexTree(Collection<Integer> indices, ConstPoolEditor editor, ConstInfoAccessor entry) {
            FieldRefInfo.gatherIndexTree(indices, editor, entry);
        }

        @Override
        public void remapIndices(Map<Integer, Integer> map, ConstInfoAccessor entry) {
            FieldRefInfo.remapIndices(map, entry);
        }

        @Override
        public boolean subIndicesAreValid(ConstInfoAccessor entry, ConstPoolEditor pool) {
            return FieldRefInfo.subIndicesAreValid(entry, pool);
        }
    }
    ,
    NameAndTypeInfo(12){

        @Override
        public void gatherIndexTree(Collection<Integer> indices, ConstPoolEditor editor, ConstInfoAccessor entry) {
            NameAndTypeInfoAccessor accessor = new NameAndTypeInfoAccessor(entry.getItem());
            6.gatherIndexTree(indices, editor, accessor.getNameIndex());
            6.gatherIndexTree(indices, editor, accessor.getTypeIndex());
        }

        @Override
        public void remapIndices(Map<Integer, Integer> map, ConstInfoAccessor entry) {
            NameAndTypeInfoAccessor accessor = new NameAndTypeInfoAccessor(entry.getItem());
            accessor.setNameIndex(InfoType.remapIndex(map, accessor.getNameIndex()));
            accessor.setTypeIndex(InfoType.remapIndex(map, accessor.getTypeIndex()));
        }

        @Override
        public boolean subIndicesAreValid(ConstInfoAccessor entry, ConstPoolEditor pool) {
            NameAndTypeInfoAccessor accessor = new NameAndTypeInfoAccessor(entry.getItem());
            ConstInfoAccessor nameEntry = pool.getItem(accessor.getNameIndex());
            ConstInfoAccessor typeEntry = pool.getItem(accessor.getTypeIndex());
            return nameEntry != null && nameEntry.getTag() == Utf8Info.getTag() && typeEntry != null && typeEntry.getTag() == Utf8Info.getTag();
        }
    }
    ,
    MethodHandleInfo(15){

        @Override
        public void gatherIndexTree(Collection<Integer> indices, ConstPoolEditor editor, ConstInfoAccessor entry) {
            MethodHandleInfoAccessor accessor = new MethodHandleInfoAccessor(entry.getItem());
            7.gatherIndexTree(indices, editor, accessor.getTypeIndex());
            7.gatherIndexTree(indices, editor, accessor.getMethodRefIndex());
        }

        @Override
        public void remapIndices(Map<Integer, Integer> map, ConstInfoAccessor entry) {
            MethodHandleInfoAccessor accessor = new MethodHandleInfoAccessor(entry.getItem());
            accessor.setTypeIndex(InfoType.remapIndex(map, accessor.getTypeIndex()));
            accessor.setMethodRefIndex(InfoType.remapIndex(map, accessor.getMethodRefIndex()));
        }

        @Override
        public boolean subIndicesAreValid(ConstInfoAccessor entry, ConstPoolEditor pool) {
            MethodHandleInfoAccessor accessor = new MethodHandleInfoAccessor(entry.getItem());
            ConstInfoAccessor typeEntry = pool.getItem(accessor.getTypeIndex());
            ConstInfoAccessor methodRefEntry = pool.getItem(accessor.getMethodRefIndex());
            return typeEntry != null && typeEntry.getTag() == Utf8Info.getTag() && methodRefEntry != null && methodRefEntry.getTag() == MethodRefInfo.getTag();
        }
    }
    ,
    MethodTypeInfo(16){

        @Override
        public void gatherIndexTree(Collection<Integer> indices, ConstPoolEditor editor, ConstInfoAccessor entry) {
            MethodTypeInfoAccessor accessor = new MethodTypeInfoAccessor(entry.getItem());
            8.gatherIndexTree(indices, editor, accessor.getTypeIndex());
        }

        @Override
        public void remapIndices(Map<Integer, Integer> map, ConstInfoAccessor entry) {
            MethodTypeInfoAccessor accessor = new MethodTypeInfoAccessor(entry.getItem());
            accessor.setTypeIndex(InfoType.remapIndex(map, accessor.getTypeIndex()));
        }

        @Override
        public boolean subIndicesAreValid(ConstInfoAccessor entry, ConstPoolEditor pool) {
            MethodTypeInfoAccessor accessor = new MethodTypeInfoAccessor(entry.getItem());
            ConstInfoAccessor typeEntry = pool.getItem(accessor.getTypeIndex());
            return typeEntry != null && typeEntry.getTag() == Utf8Info.getTag();
        }
    }
    ,
    InvokeDynamicInfo(18){

        @Override
        public void gatherIndexTree(Collection<Integer> indices, ConstPoolEditor editor, ConstInfoAccessor entry) {
            InvokeDynamicInfoAccessor accessor = new InvokeDynamicInfoAccessor(entry.getItem());
            9.gatherIndexTree(indices, editor, accessor.getBootstrapIndex());
            9.gatherIndexTree(indices, editor, accessor.getNameAndTypeIndex());
        }

        @Override
        public void remapIndices(Map<Integer, Integer> map, ConstInfoAccessor entry) {
            InvokeDynamicInfoAccessor accessor = new InvokeDynamicInfoAccessor(entry.getItem());
            accessor.setBootstrapIndex(InfoType.remapIndex(map, accessor.getBootstrapIndex()));
            accessor.setNameAndTypeIndex(InfoType.remapIndex(map, accessor.getNameAndTypeIndex()));
        }

        @Override
        public boolean subIndicesAreValid(ConstInfoAccessor entry, ConstPoolEditor pool) {
            InvokeDynamicInfoAccessor accessor = new InvokeDynamicInfoAccessor(entry.getItem());
            ConstInfoAccessor bootstrapEntry = pool.getItem(accessor.getBootstrapIndex());
            ConstInfoAccessor nameAndTypeEntry = pool.getItem(accessor.getNameAndTypeIndex());
            return bootstrapEntry != null && bootstrapEntry.getTag() == Utf8Info.getTag() && nameAndTypeEntry != null && nameAndTypeEntry.getTag() == NameAndTypeInfo.getTag();
        }
    };

    private static Map<Integer, InfoType> types;
    private int tag;

    private InfoType(int tag) {
        this.tag = tag;
    }

    public static InfoType getByTag(int tag) {
        return types.get(tag);
    }

    public static void gatherIndexTree(Collection<Integer> indices, ConstPoolEditor editor, int index) {
        indices.add(index);
        ConstInfoAccessor entry = editor.getItem(index);
        entry.getType().gatherIndexTree(indices, editor, entry);
    }

    private static int remapIndex(Map<Integer, Integer> map, int index) {
        Integer newIndex = map.get(index);
        if (newIndex == null) {
            newIndex = index;
        }
        return newIndex;
    }

    public int getTag() {
        return this.tag;
    }

    public void gatherIndexTree(Collection<Integer> indices, ConstPoolEditor editor, ConstInfoAccessor entry) {
    }

    public void remapIndices(Map<Integer, Integer> map, ConstInfoAccessor entry) {
    }

    public boolean subIndicesAreValid(ConstInfoAccessor entry, ConstPoolEditor pool) {
        return true;
    }

    static {
        types = Maps.newTreeMap();
        for (InfoType type : InfoType.values()) {
            types.put(type.getTag(), type);
        }
    }
}

