/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.bytecode;

import com.google.common.collect.Lists;
import cuchaz.enigma.analysis.JarIndex;
import cuchaz.enigma.bytecode.ClassRenamer;
import cuchaz.enigma.mapping.BehaviorEntry;
import cuchaz.enigma.mapping.ClassEntry;
import cuchaz.enigma.mapping.EntryFactory;
import cuchaz.enigma.mapping.Mappings;
import cuchaz.enigma.mapping.Translator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.NotFoundException;
import javassist.bytecode.ConstPool;
import javassist.bytecode.Descriptor;
import javassist.bytecode.EnclosingMethodAttribute;
import javassist.bytecode.InnerClassesAttribute;

public class InnerClassWriter {
    private JarIndex index;
    private Translator deobfuscatorTranslator;

    public InnerClassWriter(JarIndex index, Translator deobfuscatorTranslator) {
        this.index = index;
        this.deobfuscatorTranslator = deobfuscatorTranslator;
    }

    public static void changeModifier(CtClass c, InnerClassesAttribute attr, Translator translator) {
        ClassPool pool = c.getClassPool();
        for (int i = 0; i < attr.tableLength(); ++i) {
            String innerName = attr.innerClass(i);
            ClassEntry classEntry = new ClassEntry(Descriptor.toJvmName(innerName));
            try {
                CtClass innerClass = pool.get(innerName);
                Mappings.EntryModifier modifier = translator.getModifier(classEntry);
                if (modifier == null || modifier == Mappings.EntryModifier.UNCHANGED) continue;
                ClassRenamer.applyModifier(innerClass, modifier);
                continue;
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
        }
    }

    public void write(CtClass c) {
        boolean isInnerClass;
        InnerClassesAttribute oldAttr = (InnerClassesAttribute)c.getClassFile().getAttribute("InnerClasses");
        if (oldAttr != null) {
            return;
        }
        ClassEntry obfClassEntry = EntryFactory.getClassEntry(c);
        List<ClassEntry> obfClassChain = this.index.getObfClassChain(obfClassEntry);
        boolean bl = isInnerClass = obfClassChain.size() > 1;
        if (isInnerClass) {
            c.setName(obfClassEntry.buildClassEntry(obfClassChain).getName());
            BehaviorEntry caller = this.index.getAnonymousClassCaller(obfClassEntry);
            if (caller != null) {
                if (caller.getName().equals("<clinit>")) {
                    c.getClassFile().addAttribute(new EnclosingMethodAttribute(c.getClassFile().getConstPool(), caller.getClassName()));
                } else {
                    c.getClassFile().addAttribute(new EnclosingMethodAttribute(c.getClassFile().getConstPool(), caller.getClassName(), caller.getName(), caller.getSignature().toString()));
                }
            }
        }
        Collection<ClassEntry> obfInnerClassEntries = this.index.getInnerClasses(obfClassEntry);
        if (isInnerClass || !obfInnerClassEntries.isEmpty()) {
            InnerClassesAttribute attr = new InnerClassesAttribute(c.getClassFile().getConstPool());
            c.getClassFile().addAttribute(attr);
            for (int i = 1; i < obfClassChain.size(); ++i) {
                ClassEntry obfInnerClassEntry = obfClassChain.get(i);
                this.writeInnerClass(attr, obfClassChain, obfInnerClassEntry);
                c.replaceClassName(obfInnerClassEntry.getName(), obfInnerClassEntry.buildClassEntry(obfClassChain).getName());
            }
            for (ClassEntry obfInnerClassEntry : obfInnerClassEntries) {
                ArrayList<ClassEntry> extendedObfClassChain = Lists.newArrayList(obfClassChain);
                extendedObfClassChain.add(obfInnerClassEntry);
                this.writeInnerClass(attr, extendedObfClassChain, obfInnerClassEntry);
                c.replaceClassName(obfInnerClassEntry.getName(), obfInnerClassEntry.buildClassEntry(extendedObfClassChain).getName());
            }
        }
    }

    private void writeInnerClass(InnerClassesAttribute attr, List<ClassEntry> obfClassChain, ClassEntry obfClassEntry) {
        ClassEntry obfInnerClassEntry = obfClassEntry.buildClassEntry(obfClassChain);
        ClassEntry obfOuterClassEntry = obfInnerClassEntry.getOuterClassEntry();
        ConstPool constPool = attr.getConstPool();
        int innerClassIndex = constPool.addClassInfo(obfInnerClassEntry.getName());
        int parentClassIndex = constPool.addClassInfo(obfOuterClassEntry.getName());
        int innerClassNameIndex = 0;
        int accessFlags = 1;
        if (!this.index.isAnonymousClass(obfClassEntry)) {
            innerClassNameIndex = constPool.addUtf8Info(obfInnerClassEntry.getInnermostClassName());
        }
        attr.append(innerClassIndex, parentClassIndex, innerClassNameIndex, accessFlags);
    }
}

