/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.bytecode;

import cuchaz.enigma.mapping.ArgumentEntry;
import cuchaz.enigma.mapping.BehaviorEntry;
import cuchaz.enigma.mapping.ClassEntry;
import cuchaz.enigma.mapping.ConstructorEntry;
import cuchaz.enigma.mapping.EntryFactory;
import cuchaz.enigma.mapping.Translator;
import cuchaz.enigma.mapping.Type;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.bytecode.ByteArray;
import javassist.bytecode.CodeAttribute;
import javassist.bytecode.ConstPool;
import javassist.bytecode.LocalVariableAttribute;
import javassist.bytecode.LocalVariableTypeAttribute;

public class LocalVariableRenamer {
    private Translator translator;

    public LocalVariableRenamer(Translator translator) {
        this.translator = translator;
    }

    public void rename(CtClass c) {
        for (CtBehavior behavior : c.getDeclaredBehaviors()) {
            LocalVariableTypeAttribute typeTable;
            CodeAttribute codeAttribute = behavior.getMethodInfo().getCodeAttribute();
            if (codeAttribute == null) continue;
            BehaviorEntry behaviorEntry = EntryFactory.getBehaviorEntry(behavior);
            ConstPool constants = c.getClassFile().getConstPool();
            LocalVariableAttribute table = (LocalVariableAttribute)codeAttribute.getAttribute("LocalVariableTable");
            if (table != null) {
                this.renameLVT(behaviorEntry, constants, table);
            }
            if ((typeTable = (LocalVariableTypeAttribute)codeAttribute.getAttribute("LocalVariableTypeTable")) == null) continue;
            this.renameLVTT(typeTable, table);
        }
    }

    private void dumpTable(LocalVariableAttribute table) {
        for (int i = 0; i < table.tableLength(); ++i) {
            System.out.println(String.format("\t%d (%d): %s %s", i, table.index(i), table.variableName(i), table.descriptor(i)));
        }
    }

    private void renameLVT(BehaviorEntry behaviorEntry, ConstPool constants, LocalVariableAttribute table) {
        if (table.tableLength() <= 0) {
            return;
        }
        int starti = 0;
        if (table.variableName(0).equals("this")) {
            starti = 1;
        }
        int numArgs = 0;
        if (behaviorEntry.getSignature() != null) {
            Type firstArg;
            numArgs = behaviorEntry.getSignature().getArgumentTypes().size();
            boolean isNestedClassConstructor = false;
            if (behaviorEntry instanceof ConstructorEntry && behaviorEntry.getClassEntry() != null && behaviorEntry.getClassEntry().isInnerClass() && numArgs >= 1 && (firstArg = behaviorEntry.getSignature().getArgumentTypes().get(0)).isClass() && firstArg.getClassEntry().equals(behaviorEntry.getClassEntry().getOuterClassEntry())) {
                isNestedClassConstructor = true;
                --numArgs;
            }
            for (int i = starti; i < starti + numArgs && i < table.tableLength(); ++i) {
                int argi = i - starti;
                String argName = this.translator.translate(new ArgumentEntry(behaviorEntry, argi, ""));
                if (argName == null) {
                    Type argType = behaviorEntry.getSignature().getArgumentTypes().get(isNestedClassConstructor ? argi + 1 : argi);
                    if (argType.isPrimitive()) {
                        Type.Primitive argCls = argType.getPrimitive();
                        argName = "a" + argCls.name() + (argi + 1);
                    } else if (argType.isArray()) {
                        argName = "aList" + (argi + 1);
                    } else if (argType.isClass()) {
                        ClassEntry argClsTrans = this.translator.translateEntry(argType.getClassEntry());
                        argName = "a" + argClsTrans.getSimpleName().replace("$", "") + (argi + 1);
                    } else {
                        argName = "a" + (argi + 1);
                    }
                }
                this.renameVariable(table, i, constants.addUtf8Info(argName));
            }
        }
        for (int i = starti + numArgs; i < table.tableLength(); ++i) {
            int firstIndex = Math.min(table.index(starti + numArgs), table.index(i));
            this.renameVariable(table, i, constants.addUtf8Info("v" + (table.index(i) - firstIndex + 1)));
        }
    }

    private void renameLVTT(LocalVariableTypeAttribute typeTable, LocalVariableAttribute table) {
        for (int i = 0; i < typeTable.tableLength(); ++i) {
            this.renameVariable(typeTable, i, this.getNameIndex(table, typeTable.index(i)));
        }
    }

    private void renameVariable(LocalVariableAttribute table, int i, int stringId) {
        ByteArray.write16bit(stringId, table.get(), i * 10 + 6);
    }

    private int getNameIndex(LocalVariableAttribute table, int index) {
        for (int i = 0; i < table.tableLength(); ++i) {
            if (table.index(i) != index) continue;
            return table.nameIndex(i);
        }
        return 0;
    }
}

