/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.bytecode;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ConstPool;
import javassist.bytecode.MethodInfo;

public class MethodParametersAttribute
extends AttributeInfo {
    private MethodParametersAttribute(ConstPool pool, List<Integer> parameterNameIndices) {
        super(pool, "MethodParameters", MethodParametersAttribute.writeStruct(parameterNameIndices));
    }

    public static void updateClass(MethodInfo info, List<String> names) {
        ConstPool constPool = info.getConstPool();
        ArrayList<Integer> parameterNameIndices = new ArrayList<Integer>();
        for (String name : names) {
            if (name != null) {
                parameterNameIndices.add(constPool.addUtf8Info(name));
                continue;
            }
            parameterNameIndices.add(0);
        }
        info.addAttribute(new MethodParametersAttribute(constPool, parameterNameIndices));
    }

    private static byte[] writeStruct(List<Integer> parameterNameIndices) {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(buf);
        boolean SIZEOF_UINT8 = true;
        int SIZEOF_UINT16 = 2;
        int MAX_UINT8 = 255;
        int MAX_UINT16 = 65535;
        try {
            assert (parameterNameIndices.size() >= 0 && parameterNameIndices.size() <= 255);
            out.writeByte(parameterNameIndices.size());
            for (Integer index : parameterNameIndices) {
                assert (index >= 0 && index <= 65535);
                out.writeShort(index);
                out.writeShort(0);
            }
            out.close();
            byte[] data = buf.toByteArray();
            assert (data.length == 1 + parameterNameIndices.size() * 4);
            return data;
        }
        catch (IOException ex) {
            throw new Error(ex);
        }
    }
}

