/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.convert;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import cuchaz.enigma.convert.ClassIdentifier;
import cuchaz.enigma.convert.ClassIdentity;
import cuchaz.enigma.mapping.ClassEntry;
import java.util.Collection;

public class ClassForest {
    private ClassIdentifier identifier;
    private Multimap<ClassIdentity, ClassEntry> forest;

    public ClassForest(ClassIdentifier identifier) {
        this.identifier = identifier;
        this.forest = HashMultimap.create();
    }

    public void addAll(Iterable<ClassEntry> entries) {
        for (ClassEntry entry : entries) {
            this.add(entry);
        }
    }

    public void add(ClassEntry entry) {
        try {
            this.forest.put(this.identifier.identify(entry), entry);
        }
        catch (ClassNotFoundException ex) {
            throw new Error("Unable to find class " + entry.getName());
        }
    }

    public Collection<ClassIdentity> identities() {
        return this.forest.keySet();
    }

    public Collection<ClassEntry> classes() {
        return this.forest.values();
    }

    public Collection<ClassEntry> getClasses(ClassIdentity identity) {
        return this.forest.get(identity);
    }

    public boolean containsIdentity(ClassIdentity identity) {
        return this.forest.containsKey(identity);
    }
}

