/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.convert;

import com.google.common.collect.Maps;
import cuchaz.enigma.TranslatingTypeLoader;
import cuchaz.enigma.analysis.JarIndex;
import cuchaz.enigma.convert.ClassIdentity;
import cuchaz.enigma.convert.ClassNamer;
import cuchaz.enigma.mapping.ClassEntry;
import cuchaz.enigma.mapping.Translator;
import java.util.Map;
import java.util.jar.JarFile;
import javassist.CtClass;

public class ClassIdentifier {
    private JarIndex index;
    private ClassNamer.SidedClassNamer namer;
    private boolean useReferences;
    private TranslatingTypeLoader loader;
    private Map<ClassEntry, ClassIdentity> cache;

    public ClassIdentifier(JarFile jar, JarIndex index, ClassNamer.SidedClassNamer namer, boolean useReferences) {
        this.index = index;
        this.namer = namer;
        this.useReferences = useReferences;
        this.loader = new TranslatingTypeLoader(jar, index, new Translator(), new Translator());
        this.cache = Maps.newHashMap();
    }

    public ClassIdentity identify(ClassEntry classEntry) throws ClassNotFoundException {
        ClassIdentity identity = this.cache.get(classEntry);
        if (identity == null) {
            CtClass c = this.loader.loadClass(classEntry.getName());
            if (c == null) {
                throw new ClassNotFoundException(classEntry.getName());
            }
            identity = new ClassIdentity(c, this.namer, this.index, this.useReferences);
            this.cache.put(classEntry, identity);
        }
        return identity;
    }
}

