/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.convert;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multiset;
import com.google.common.collect.Sets;
import cuchaz.enigma.analysis.ClassImplementationsTreeNode;
import cuchaz.enigma.analysis.EntryReference;
import cuchaz.enigma.analysis.JarIndex;
import cuchaz.enigma.bytecode.ConstPoolEditor;
import cuchaz.enigma.bytecode.InfoType;
import cuchaz.enigma.bytecode.accessors.ConstInfoAccessor;
import cuchaz.enigma.convert.ClassNamer;
import cuchaz.enigma.mapping.BehaviorEntry;
import cuchaz.enigma.mapping.ClassEntry;
import cuchaz.enigma.mapping.ClassNameReplacer;
import cuchaz.enigma.mapping.Entry;
import cuchaz.enigma.mapping.EntryFactory;
import cuchaz.enigma.mapping.FieldEntry;
import cuchaz.enigma.mapping.Signature;
import cuchaz.enigma.mapping.Type;
import cuchaz.enigma.utils.Utils;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import javassist.CannotCompileException;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMember;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.CodeIterator;
import javassist.bytecode.ConstPool;
import javassist.bytecode.Descriptor;
import javassist.expr.ConstructorCall;
import javassist.expr.ExprEditor;
import javassist.expr.FieldAccess;
import javassist.expr.MethodCall;
import javassist.expr.NewExpr;
import javax.swing.tree.TreeNode;

public class ClassIdentity {
    private ClassEntry classEntry;
    private ClassNamer.SidedClassNamer namer;
    private final ClassNameReplacer classNameReplacer = new ClassNameReplacer(){
        private Map<String, String> classNames = Maps.newHashMap();

        @Override
        public String replace(String className) {
            String newName;
            ClassEntry classEntry = new ClassEntry(className);
            if (classEntry.getPackageName() != null) {
                return className;
            }
            if (className.equals(classEntry.getName())) {
                return "CSelf";
            }
            if (ClassIdentity.this.namer != null && (newName = ClassIdentity.this.namer.getName(className)) != null) {
                return newName;
            }
            if (!this.classNames.containsKey(className)) {
                this.classNames.put(className, this.getNewClassName());
            }
            return this.classNames.get(className);
        }

        private String getNewClassName() {
            return String.format("C%03d", this.classNames.size());
        }
    };
    private Multiset<String> fields;
    private Multiset<String> methods;
    private Multiset<String> constructors;
    private String staticInitializer;
    private String extendz;
    private Multiset<String> implementz;
    private Set<String> stringLiterals;
    private Multiset<String> implementations;
    private Multiset<String> references;
    private String outer;

    public ClassIdentity(CtClass c, ClassNamer.SidedClassNamer namer, JarIndex index, boolean useReferences) {
        this.namer = namer;
        this.classEntry = EntryFactory.getClassEntry(c);
        this.fields = HashMultiset.create();
        for (CtField ctField : c.getDeclaredFields()) {
            this.fields.add(this.scrubType(ctField.getSignature()));
        }
        this.methods = HashMultiset.create();
        for (CtMember ctMember : c.getDeclaredMethods()) {
            this.methods.add(this.scrubSignature(((CtBehavior)ctMember).getSignature()) + "0x" + this.getBehaviorSignature((CtBehavior)ctMember));
        }
        this.constructors = HashMultiset.create();
        for (CtMember ctMember : c.getDeclaredConstructors()) {
            this.constructors.add(this.scrubSignature(((CtBehavior)ctMember).getSignature()) + "0x" + this.getBehaviorSignature((CtBehavior)ctMember));
        }
        this.staticInitializer = "";
        if (c.getClassInitializer() != null) {
            this.staticInitializer = this.getBehaviorSignature(c.getClassInitializer());
        }
        this.extendz = "";
        if (c.getClassFile().getSuperclass() != null) {
            this.extendz = this.scrubClassName(Descriptor.toJvmName(c.getClassFile().getSuperclass()));
        }
        this.implementz = HashMultiset.create();
        for (String string : c.getClassFile().getInterfaces()) {
            this.implementz.add(this.scrubClassName(Descriptor.toJvmName(string)));
        }
        this.stringLiterals = Sets.newHashSet();
        ConstPool constants = c.getClassFile().getConstPool();
        for (int i = 1; i < constants.getSize(); ++i) {
            if (constants.getTag(i) != 8) continue;
            this.stringLiterals.add(constants.getStringInfo(i));
        }
        this.implementations = HashMultiset.create();
        ClassImplementationsTreeNode implementationsNode = index.getClassImplementations(null, this.classEntry);
        if (implementationsNode != null) {
            Enumeration<TreeNode> implementations = implementationsNode.children();
            while (implementations.hasMoreElements()) {
                ClassImplementationsTreeNode classImplementationsTreeNode = (ClassImplementationsTreeNode)implementations.nextElement();
                this.implementations.add(this.scrubClassName(classImplementationsTreeNode.getClassEntry().getName()));
            }
        }
        this.references = HashMultiset.create();
        if (useReferences) {
            for (CtField ctField : c.getDeclaredFields()) {
                FieldEntry fieldEntry = EntryFactory.getFieldEntry(ctField);
                index.getFieldReferences(fieldEntry).forEach(this::addReference);
            }
            for (CtMember ctMember : c.getDeclaredBehaviors()) {
                BehaviorEntry behaviorEntry = EntryFactory.getBehaviorEntry((CtBehavior)ctMember);
                index.getBehaviorReferences(behaviorEntry).forEach(this::addReference);
            }
        }
        this.outer = null;
        if (this.classEntry.isInnerClass()) {
            this.outer = this.classEntry.getOuterClassName();
        }
    }

    private void addReference(EntryReference<? extends Entry, BehaviorEntry> reference) {
        if (((BehaviorEntry)reference.context).getSignature() != null) {
            this.references.add(String.format("%s_%s", this.scrubClassName(((BehaviorEntry)reference.context).getClassName()), this.scrubSignature(((BehaviorEntry)reference.context).getSignature())));
        } else {
            this.references.add(String.format("%s_<clinit>", this.scrubClassName(((BehaviorEntry)reference.context).getClassName())));
        }
    }

    public ClassEntry getClassEntry() {
        return this.classEntry;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("class: ");
        buf.append(this.classEntry.getName());
        buf.append(" ");
        buf.append(this.hashCode());
        buf.append("\n");
        for (String field : this.fields) {
            buf.append("\tfield ");
            buf.append(field);
            buf.append("\n");
        }
        for (String method : this.methods) {
            buf.append("\tmethod ");
            buf.append(method);
            buf.append("\n");
        }
        for (String constructor : this.constructors) {
            buf.append("\tconstructor ");
            buf.append(constructor);
            buf.append("\n");
        }
        if (!this.staticInitializer.isEmpty()) {
            buf.append("\tinitializer ");
            buf.append(this.staticInitializer);
            buf.append("\n");
        }
        if (!this.extendz.isEmpty()) {
            buf.append("\textends ");
            buf.append(this.extendz);
            buf.append("\n");
        }
        for (String interfaceName : this.implementz) {
            buf.append("\timplements ");
            buf.append(interfaceName);
            buf.append("\n");
        }
        for (String implementation : this.implementations) {
            buf.append("\timplemented by ");
            buf.append(implementation);
            buf.append("\n");
        }
        for (String reference : this.references) {
            buf.append("\treference ");
            buf.append(reference);
            buf.append("\n");
        }
        buf.append("\touter ");
        buf.append(this.outer);
        buf.append("\n");
        return buf.toString();
    }

    private String scrubClassName(String className) {
        return this.classNameReplacer.replace(className);
    }

    private String scrubType(String typeName) {
        return this.scrubType(new Type(typeName)).toString();
    }

    private Type scrubType(Type type) {
        if (type.hasClass()) {
            return new Type(type, this.classNameReplacer);
        }
        return type;
    }

    private String scrubSignature(String signature) {
        return this.scrubSignature(new Signature(signature)).toString();
    }

    private Signature scrubSignature(Signature signature) {
        return new Signature(signature, this.classNameReplacer);
    }

    private boolean isClassMatchedUniquely(String className) {
        return this.namer != null && this.namer.getName(Descriptor.toJvmName(className)) != null;
    }

    private String getBehaviorSignature(CtBehavior behavior) {
        try {
            if (behavior.getMethodInfo().getCodeAttribute() == null) {
                return "(none)";
            }
            ConstPool constants = behavior.getMethodInfo().getConstPool();
            final MessageDigest digest = MessageDigest.getInstance("MD5");
            CodeIterator iter = behavior.getMethodInfo().getCodeAttribute().iterator();
            while (iter.hasNext()) {
                int pos = iter.next();
                int opcode = iter.byteAt(pos);
                digest.update((byte)opcode);
                switch (opcode) {
                    case 18: {
                        int constIndex = iter.byteAt(pos + 1);
                        this.updateHashWithConstant(digest, constants, constIndex);
                        break;
                    }
                    case 19: 
                    case 20: {
                        int constIndex = iter.byteAt(pos + 1) << 8 | iter.byteAt(pos + 2);
                        this.updateHashWithConstant(digest, constants, constIndex);
                        break;
                    }
                }
            }
            behavior.instrument(new ExprEditor(){

                @Override
                public void edit(MethodCall call) {
                    ClassIdentity.this.updateHashWithString(digest, ClassIdentity.this.scrubClassName(Descriptor.toJvmName(call.getClassName())));
                    ClassIdentity.this.updateHashWithString(digest, ClassIdentity.this.scrubSignature(call.getSignature()));
                    if (ClassIdentity.this.isClassMatchedUniquely(call.getClassName())) {
                        ClassIdentity.this.updateHashWithString(digest, call.getMethodName());
                    }
                }

                @Override
                public void edit(FieldAccess access) {
                    ClassIdentity.this.updateHashWithString(digest, ClassIdentity.this.scrubClassName(Descriptor.toJvmName(access.getClassName())));
                    ClassIdentity.this.updateHashWithString(digest, ClassIdentity.this.scrubType(access.getSignature()));
                    if (ClassIdentity.this.isClassMatchedUniquely(access.getClassName())) {
                        ClassIdentity.this.updateHashWithString(digest, access.getFieldName());
                    }
                }

                @Override
                public void edit(ConstructorCall call) {
                    ClassIdentity.this.updateHashWithString(digest, ClassIdentity.this.scrubClassName(Descriptor.toJvmName(call.getClassName())));
                    ClassIdentity.this.updateHashWithString(digest, ClassIdentity.this.scrubSignature(call.getSignature()));
                }

                @Override
                public void edit(NewExpr expr) {
                    ClassIdentity.this.updateHashWithString(digest, ClassIdentity.this.scrubClassName(Descriptor.toJvmName(expr.getClassName())));
                }
            });
            return this.toHex(digest.digest());
        }
        catch (NoSuchAlgorithmException | CannotCompileException | BadBytecode ex) {
            throw new Error(ex);
        }
    }

    private void updateHashWithConstant(MessageDigest digest, ConstPool constants, int index) {
        ConstPoolEditor editor = new ConstPoolEditor(constants);
        ConstInfoAccessor item = editor.getItem(index);
        if (item.getType() == InfoType.StringInfo) {
            this.updateHashWithString(digest, constants.getStringInfo(index));
        }
    }

    private void updateHashWithString(MessageDigest digest, String val) {
        try {
            digest.update(val.getBytes("UTF8"));
        }
        catch (UnsupportedEncodingException ex) {
            throw new Error(ex);
        }
    }

    private String toHex(byte[] bytes) {
        char[] hexArray = "0123456789ABCDEF".toCharArray();
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }

    public boolean equals(Object other) {
        return other instanceof ClassIdentity && this.equals((ClassIdentity)other);
    }

    public boolean equals(ClassIdentity other) {
        return this.fields.equals(other.fields) && this.methods.equals(other.methods) && this.constructors.equals(other.constructors) && this.staticInitializer.equals(other.staticInitializer) && this.extendz.equals(other.extendz) && this.implementz.equals(other.implementz) && this.implementations.equals(other.implementations) && this.references.equals(other.references);
    }

    public int hashCode() {
        ArrayList<Object> objs = Lists.newArrayList();
        objs.addAll(this.fields);
        objs.addAll(this.methods);
        objs.addAll(this.constructors);
        objs.add(this.staticInitializer);
        objs.add(this.extendz);
        objs.addAll(this.implementz);
        objs.addAll(this.implementations);
        objs.addAll(this.references);
        return Utils.combineHashesOrdered(objs);
    }

    public int getMatchScore(ClassIdentity other) {
        return 2 * this.getNumMatches(this.extendz, other.extendz) + 2 * this.getNumMatches(this.outer, other.outer) + 2 * this.getNumMatches(this.implementz, other.implementz) + this.getNumMatches(this.stringLiterals, other.stringLiterals) + this.getNumMatches(this.fields, other.fields) + this.getNumMatches(this.methods, other.methods) + this.getNumMatches(this.constructors, other.constructors);
    }

    public int getMaxMatchScore() {
        return 4 + 2 * this.implementz.size() + this.stringLiterals.size() + this.fields.size() + this.methods.size() + this.constructors.size();
    }

    public boolean matches(CtClass c) {
        return this.fields.size() == c.getDeclaredFields().length && this.methods.size() == c.getDeclaredMethods().length && this.constructors.size() == c.getDeclaredConstructors().length;
    }

    private int getNumMatches(Set<String> a, Set<String> b) {
        int numMatches = 0;
        for (String val : a) {
            if (!b.contains(val)) continue;
            ++numMatches;
        }
        return numMatches;
    }

    private int getNumMatches(Multiset<String> a, Multiset<String> b) {
        int numMatches = 0;
        for (String val : a) {
            if (!b.contains(val)) continue;
            ++numMatches;
        }
        return numMatches;
    }

    private int getNumMatches(String a, String b) {
        if (a == null && b == null) {
            return 1;
        }
        if (a != null && b != null && a.equals(b)) {
            return 1;
        }
        return 0;
    }
}

