/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.convert;

import com.google.common.collect.Sets;
import cuchaz.enigma.mapping.ClassEntry;
import cuchaz.enigma.utils.Utils;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class ClassMatch {
    public Set<ClassEntry> sourceClasses;
    public Set<ClassEntry> destClasses;

    public ClassMatch(Collection<ClassEntry> sourceClasses, Collection<ClassEntry> destClasses) {
        this.sourceClasses = Sets.newHashSet(sourceClasses);
        this.destClasses = Sets.newHashSet(destClasses);
    }

    public ClassMatch(ClassEntry sourceClass, ClassEntry destClass) {
        this.sourceClasses = Sets.newHashSet();
        if (sourceClass != null) {
            this.sourceClasses.add(sourceClass);
        }
        this.destClasses = Sets.newHashSet();
        if (destClass != null) {
            this.destClasses.add(destClass);
        }
    }

    public boolean isMatched() {
        return !this.sourceClasses.isEmpty() && !this.destClasses.isEmpty();
    }

    public boolean isAmbiguous() {
        return this.sourceClasses.size() > 1 || this.destClasses.size() > 1;
    }

    public ClassEntry getUniqueSource() {
        if (this.sourceClasses.size() != 1) {
            throw new IllegalStateException("Match has ambiguous source!");
        }
        return this.sourceClasses.iterator().next();
    }

    public ClassEntry getUniqueDest() {
        if (this.destClasses.size() != 1) {
            throw new IllegalStateException("Match has ambiguous source!");
        }
        return this.destClasses.iterator().next();
    }

    public Set<ClassEntry> intersectSourceClasses(Set<ClassEntry> classes) {
        HashSet<ClassEntry> intersection = Sets.newHashSet(this.sourceClasses);
        intersection.retainAll(classes);
        return intersection;
    }

    public int hashCode() {
        return Utils.combineHashesOrdered(this.sourceClasses, this.destClasses);
    }

    public boolean equals(Object other) {
        return other instanceof ClassMatch && this.equals((ClassMatch)other);
    }

    public boolean equals(ClassMatch other) {
        return this.sourceClasses.equals(other.sourceClasses) && this.destClasses.equals(other.destClasses);
    }
}

