/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.convert;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import cuchaz.enigma.convert.ClassMatch;
import cuchaz.enigma.mapping.ClassEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ClassMatches
implements Iterable<ClassMatch> {
    private Collection<ClassMatch> matches;
    private Map<ClassEntry, ClassMatch> matchesBySource;
    private Map<ClassEntry, ClassMatch> matchesByDest;
    private BiMap<ClassEntry, ClassEntry> uniqueMatches;
    private Map<ClassEntry, ClassMatch> ambiguousMatchesBySource;
    private Map<ClassEntry, ClassMatch> ambiguousMatchesByDest;
    private Set<ClassEntry> unmatchedSourceClasses;
    private Set<ClassEntry> unmatchedDestClasses;

    public ClassMatches() {
        this(new ArrayList<ClassMatch>());
    }

    public ClassMatches(Collection<ClassMatch> matches) {
        this.matches = matches;
        this.matchesBySource = Maps.newHashMap();
        this.matchesByDest = Maps.newHashMap();
        this.uniqueMatches = HashBiMap.create();
        this.ambiguousMatchesBySource = Maps.newHashMap();
        this.ambiguousMatchesByDest = Maps.newHashMap();
        this.unmatchedSourceClasses = Sets.newHashSet();
        this.unmatchedDestClasses = Sets.newHashSet();
        for (ClassMatch match : matches) {
            this.indexMatch(match);
        }
    }

    public void add(ClassMatch match) {
        this.matches.add(match);
        this.indexMatch(match);
    }

    public void remove(ClassMatch match) {
        for (ClassEntry sourceClass : match.sourceClasses) {
            this.matchesBySource.remove(sourceClass);
            this.uniqueMatches.remove(sourceClass);
            this.ambiguousMatchesBySource.remove(sourceClass);
            this.unmatchedSourceClasses.remove(sourceClass);
        }
        for (ClassEntry destClass : match.destClasses) {
            this.matchesByDest.remove(destClass);
            this.uniqueMatches.inverse().remove(destClass);
            this.ambiguousMatchesByDest.remove(destClass);
            this.unmatchedDestClasses.remove(destClass);
        }
        this.matches.remove(match);
    }

    public int size() {
        return this.matches.size();
    }

    @Override
    public Iterator<ClassMatch> iterator() {
        return this.matches.iterator();
    }

    private void indexMatch(ClassMatch match) {
        if (!match.isMatched()) {
            this.unmatchedSourceClasses.addAll(match.sourceClasses);
            this.unmatchedDestClasses.addAll(match.destClasses);
        } else if (match.isAmbiguous()) {
            for (ClassEntry entry : match.sourceClasses) {
                this.ambiguousMatchesBySource.put(entry, match);
            }
            for (ClassEntry entry : match.destClasses) {
                this.ambiguousMatchesByDest.put(entry, match);
            }
        } else {
            this.uniqueMatches.put(match.getUniqueSource(), match.getUniqueDest());
        }
        for (ClassEntry entry : match.sourceClasses) {
            this.matchesBySource.put(entry, match);
        }
        for (ClassEntry entry : match.destClasses) {
            this.matchesByDest.put(entry, match);
        }
    }

    public BiMap<ClassEntry, ClassEntry> getUniqueMatches() {
        return this.uniqueMatches;
    }

    public Set<ClassEntry> getUnmatchedSourceClasses() {
        return this.unmatchedSourceClasses;
    }

    public Set<ClassEntry> getUnmatchedDestClasses() {
        return this.unmatchedDestClasses;
    }

    public Set<ClassEntry> getAmbiguouslyMatchedSourceClasses() {
        return this.ambiguousMatchesBySource.keySet();
    }

    public ClassMatch getAmbiguousMatchBySource(ClassEntry sourceClass) {
        return this.ambiguousMatchesBySource.get(sourceClass);
    }

    public ClassMatch getMatchBySource(ClassEntry sourceClass) {
        return this.matchesBySource.get(sourceClass);
    }

    public ClassMatch getMatchByDest(ClassEntry destClass) {
        return this.matchesByDest.get(destClass);
    }

    public void removeSource(ClassEntry sourceClass) {
        ClassMatch match = this.matchesBySource.get(sourceClass);
        if (match != null) {
            this.remove(match);
            match.sourceClasses.remove(sourceClass);
            if (!match.sourceClasses.isEmpty() || !match.destClasses.isEmpty()) {
                this.add(match);
            }
        }
    }

    public void removeDest(ClassEntry destClass) {
        ClassMatch match = this.matchesByDest.get(destClass);
        if (match != null) {
            this.remove(match);
            match.destClasses.remove(destClass);
            if (!match.sourceClasses.isEmpty() || !match.destClasses.isEmpty()) {
                this.add(match);
            }
        }
    }
}

