/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.convert;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import cuchaz.enigma.convert.ClassForest;
import cuchaz.enigma.convert.ClassIdentifier;
import cuchaz.enigma.convert.ClassIdentity;
import cuchaz.enigma.convert.ClassMatch;
import cuchaz.enigma.mapping.ClassEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;

public class ClassMatching {
    private ClassForest sourceClasses;
    private ClassForest destClasses;
    private BiMap<ClassEntry, ClassEntry> knownMatches;

    public ClassMatching(ClassIdentifier sourceIdentifier, ClassIdentifier destIdentifier) {
        this.sourceClasses = new ClassForest(sourceIdentifier);
        this.destClasses = new ClassForest(destIdentifier);
        this.knownMatches = HashBiMap.create();
    }

    public void addKnownMatches(BiMap<ClassEntry, ClassEntry> knownMatches) {
        this.knownMatches.putAll(knownMatches);
    }

    public void match(Iterable<ClassEntry> sourceClasses, Iterable<ClassEntry> destClasses) {
        for (ClassEntry sourceClass : sourceClasses) {
            if (this.knownMatches.containsKey(sourceClass)) continue;
            this.sourceClasses.add(sourceClass);
        }
        for (ClassEntry destClass : destClasses) {
            if (this.knownMatches.containsValue(destClass)) continue;
            this.destClasses.add(destClass);
        }
    }

    public Collection<ClassMatch> matches() {
        ArrayList<ClassMatch> matches = Lists.newArrayList();
        for (Map.Entry entry : this.knownMatches.entrySet()) {
            matches.add(new ClassMatch((ClassEntry)entry.getKey(), (ClassEntry)entry.getValue()));
        }
        for (ClassIdentity identity : this.sourceClasses.identities()) {
            matches.add(new ClassMatch(this.sourceClasses.getClasses(identity), this.destClasses.getClasses(identity)));
        }
        for (ClassIdentity identity : this.destClasses.identities()) {
            if (this.sourceClasses.containsIdentity(identity)) continue;
            matches.add(new ClassMatch(new ArrayList<ClassEntry>(), this.destClasses.getClasses(identity)));
        }
        return matches;
    }

    public Collection<ClassEntry> sourceClasses() {
        HashSet<ClassEntry> classes = Sets.newHashSet();
        for (ClassMatch match : this.matches()) {
            classes.addAll(match.sourceClasses);
        }
        return classes;
    }

    public Collection<ClassEntry> destClasses() {
        HashSet<ClassEntry> classes = Sets.newHashSet();
        for (ClassMatch match : this.matches()) {
            classes.addAll(match.destClasses);
        }
        return classes;
    }

    public BiMap<ClassEntry, ClassEntry> uniqueMatches() {
        HashBiMap<ClassEntry, ClassEntry> uniqueMatches = HashBiMap.create();
        for (ClassMatch match : this.matches()) {
            if (!match.isMatched() || match.isAmbiguous()) continue;
            uniqueMatches.put(match.getUniqueSource(), match.getUniqueDest());
        }
        return uniqueMatches;
    }

    public Collection<ClassMatch> ambiguousMatches() {
        ArrayList<ClassMatch> ambiguousMatches = Lists.newArrayList();
        for (ClassMatch match : this.matches()) {
            if (!match.isMatched() || !match.isAmbiguous()) continue;
            ambiguousMatches.add(match);
        }
        return ambiguousMatches;
    }

    public Collection<ClassEntry> unmatchedSourceClasses() {
        ArrayList<ClassEntry> classes = Lists.newArrayList();
        for (ClassMatch match : this.matches()) {
            if (match.isMatched() || match.sourceClasses.isEmpty()) continue;
            classes.addAll(match.sourceClasses);
        }
        return classes;
    }

    public Collection<ClassEntry> unmatchedDestClasses() {
        ArrayList<ClassEntry> classes = Lists.newArrayList();
        for (ClassMatch match : this.matches()) {
            if (match.isMatched() || match.destClasses.isEmpty()) continue;
            classes.addAll(match.destClasses);
        }
        return classes;
    }

    public String toString() {
        int numAmbiguousSource = 0;
        int numAmbiguousDest = 0;
        for (ClassMatch match : this.ambiguousMatches()) {
            numAmbiguousSource += match.sourceClasses.size();
            numAmbiguousDest += match.destClasses.size();
        }
        String buf = String.format("%20s%8s%8s\n", "", "Source", "Dest") + String.format("%20s%8d%8d\n", "Classes", this.sourceClasses().size(), this.destClasses().size()) + String.format("%20s%8d%8d\n", "Uniquely matched", this.uniqueMatches().size(), this.uniqueMatches().size()) + String.format("%20s%8d%8d\n", "Ambiguously matched", numAmbiguousSource, numAmbiguousDest) + String.format("%20s%8d%8d\n", "Unmatched", this.unmatchedSourceClasses().size(), this.unmatchedDestClasses().size());
        return buf;
    }
}

