/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.convert;

import com.google.common.collect.BiMap;
import com.google.common.collect.Maps;
import cuchaz.enigma.mapping.ClassEntry;
import java.util.Map;

public class ClassNamer {
    private Map<String, String> sourceNames = Maps.newHashMap();
    private Map<String, String> destNames = Maps.newHashMap();

    public ClassNamer(BiMap<ClassEntry, ClassEntry> mappings) {
        int i = 0;
        for (Map.Entry entry : mappings.entrySet()) {
            String name = String.format("M%04d", i++);
            this.sourceNames.put(((ClassEntry)entry.getKey()).getName(), name);
            this.destNames.put(((ClassEntry)entry.getValue()).getName(), name);
        }
    }

    public String getSourceName(String name) {
        return this.sourceNames.get(name);
    }

    public String getDestName(String name) {
        return this.destNames.get(name);
    }

    public SidedClassNamer getSourceNamer() {
        return this::getSourceName;
    }

    public SidedClassNamer getDestNamer() {
        return this::getDestName;
    }

    public static interface SidedClassNamer {
        public String getName(String var1);
    }
}

