/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.convert;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import cuchaz.enigma.mapping.ClassEntry;
import cuchaz.enigma.mapping.FieldEntry;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class FieldMatches {
    private BiMap<FieldEntry, FieldEntry> matches = HashBiMap.create();
    private Multimap<ClassEntry, FieldEntry> matchedSourceFields = HashMultimap.create();
    private Multimap<ClassEntry, FieldEntry> unmatchedSourceFields = HashMultimap.create();
    private Multimap<ClassEntry, FieldEntry> unmatchedDestFields = HashMultimap.create();
    private Multimap<ClassEntry, FieldEntry> unmatchableSourceFields = HashMultimap.create();

    public void addMatch(FieldEntry srcField, FieldEntry destField) {
        boolean wasAdded;
        boolean bl = wasAdded = this.matches.put(srcField, destField) == null;
        assert (wasAdded);
        wasAdded = this.matchedSourceFields.put(srcField.getClassEntry(), srcField);
        assert (wasAdded);
    }

    public void addUnmatchedSourceField(FieldEntry fieldEntry) {
        boolean wasAdded = this.unmatchedSourceFields.put(fieldEntry.getClassEntry(), fieldEntry);
        assert (wasAdded);
    }

    public void addUnmatchedSourceFields(Iterable<FieldEntry> fieldEntries) {
        for (FieldEntry fieldEntry : fieldEntries) {
            this.addUnmatchedSourceField(fieldEntry);
        }
    }

    public void addUnmatchedDestField(FieldEntry fieldEntry) {
        boolean wasAdded = this.unmatchedDestFields.put(fieldEntry.getClassEntry(), fieldEntry);
        assert (wasAdded);
    }

    public void addUnmatchedDestFields(Iterable<FieldEntry> fieldEntries) {
        for (FieldEntry fieldEntry : fieldEntries) {
            this.addUnmatchedDestField(fieldEntry);
        }
    }

    public void addUnmatchableSourceField(FieldEntry sourceField) {
        boolean wasAdded = this.unmatchableSourceFields.put(sourceField.getClassEntry(), sourceField);
        assert (wasAdded);
    }

    public Set<ClassEntry> getSourceClassesWithUnmatchedFields() {
        return this.unmatchedSourceFields.keySet();
    }

    public Collection<ClassEntry> getSourceClassesWithoutUnmatchedFields() {
        HashSet<ClassEntry> out = Sets.newHashSet();
        out.addAll(this.matchedSourceFields.keySet());
        out.removeAll(this.unmatchedSourceFields.keySet());
        return out;
    }

    public Collection<FieldEntry> getUnmatchedSourceFields() {
        return this.unmatchedSourceFields.values();
    }

    public Collection<FieldEntry> getUnmatchedSourceFields(ClassEntry sourceClass) {
        return this.unmatchedSourceFields.get(sourceClass);
    }

    public Collection<FieldEntry> getUnmatchedDestFields() {
        return this.unmatchedDestFields.values();
    }

    public Collection<FieldEntry> getUnmatchedDestFields(ClassEntry destClass) {
        return this.unmatchedDestFields.get(destClass);
    }

    public Collection<FieldEntry> getUnmatchableSourceFields() {
        return this.unmatchableSourceFields.values();
    }

    public boolean hasSource(FieldEntry fieldEntry) {
        return this.matches.containsKey(fieldEntry) || this.unmatchedSourceFields.containsValue(fieldEntry);
    }

    public boolean hasDest(FieldEntry fieldEntry) {
        return this.matches.containsValue(fieldEntry) || this.unmatchedDestFields.containsValue(fieldEntry);
    }

    public BiMap<FieldEntry, FieldEntry> matches() {
        return this.matches;
    }

    public boolean isMatchedSourceField(FieldEntry sourceField) {
        return this.matches.containsKey(sourceField);
    }

    public boolean isMatchedDestField(FieldEntry destField) {
        return this.matches.containsValue(destField);
    }

    public void makeMatch(FieldEntry sourceField, FieldEntry destField) {
        boolean wasRemoved = this.unmatchedSourceFields.remove(sourceField.getClassEntry(), sourceField);
        assert (wasRemoved);
        wasRemoved = this.unmatchedDestFields.remove(destField.getClassEntry(), destField);
        assert (wasRemoved);
        this.addMatch(sourceField, destField);
    }

    public boolean isMatched(FieldEntry sourceField, FieldEntry destField) {
        FieldEntry match = (FieldEntry)this.matches.get(sourceField);
        return match != null && match.equals(destField);
    }

    public void unmakeMatch(FieldEntry sourceField, FieldEntry destField) {
        boolean wasRemoved;
        boolean bl = wasRemoved = this.matches.remove(sourceField) != null;
        assert (wasRemoved);
        wasRemoved = this.matchedSourceFields.remove(sourceField.getClassEntry(), sourceField);
        assert (wasRemoved);
        this.addUnmatchedSourceField(sourceField);
        this.addUnmatchedDestField(destField);
    }

    public void makeSourceUnmatchable(FieldEntry sourceField) {
        assert (!this.isMatchedSourceField(sourceField));
        boolean wasRemoved = this.unmatchedSourceFields.remove(sourceField.getClassEntry(), sourceField);
        assert (wasRemoved);
        this.addUnmatchableSourceField(sourceField);
    }
}

