/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.convert;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import cuchaz.enigma.Deobfuscator;
import cuchaz.enigma.TranslatingTypeLoader;
import cuchaz.enigma.analysis.JarIndex;
import cuchaz.enigma.convert.ClassIdentifier;
import cuchaz.enigma.convert.ClassMatch;
import cuchaz.enigma.convert.ClassMatches;
import cuchaz.enigma.convert.ClassMatching;
import cuchaz.enigma.convert.ClassNamer;
import cuchaz.enigma.convert.MemberMatches;
import cuchaz.enigma.mapping.BehaviorEntry;
import cuchaz.enigma.mapping.ClassEntry;
import cuchaz.enigma.mapping.ClassMapping;
import cuchaz.enigma.mapping.ClassNameReplacer;
import cuchaz.enigma.mapping.ConstructorEntry;
import cuchaz.enigma.mapping.Entry;
import cuchaz.enigma.mapping.FieldEntry;
import cuchaz.enigma.mapping.FieldMapping;
import cuchaz.enigma.mapping.Mappings;
import cuchaz.enigma.mapping.MappingsChecker;
import cuchaz.enigma.mapping.MemberMapping;
import cuchaz.enigma.mapping.MethodEntry;
import cuchaz.enigma.mapping.MethodMapping;
import cuchaz.enigma.mapping.Signature;
import cuchaz.enigma.mapping.Type;
import cuchaz.enigma.throwables.MappingConflict;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarFile;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.NotFoundException;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.CodeAttribute;
import javassist.bytecode.CodeIterator;

public class MappingsConverter {
    public static ClassMatches computeClassMatches(JarFile sourceJar, JarFile destJar, Mappings mappings) {
        System.out.println("Indexing source jar...");
        JarIndex sourceIndex = new JarIndex();
        sourceIndex.indexJar(sourceJar, false);
        System.out.println("Indexing dest jar...");
        JarIndex destIndex = new JarIndex();
        destIndex.indexJar(destJar, false);
        ClassMatching matching = MappingsConverter.computeMatching(sourceJar, sourceIndex, destJar, destIndex, null);
        return new ClassMatches(matching.matches());
    }

    public static ClassMatching computeMatching(JarFile sourceJar, JarIndex sourceIndex, JarFile destJar, JarIndex destIndex, BiMap<ClassEntry, ClassEntry> knownMatches) {
        System.out.println("Iteratively matching classes");
        ClassMatching lastMatching = null;
        int round = 0;
        ClassNamer.SidedClassNamer sourceNamer = null;
        ClassNamer.SidedClassNamer destNamer = null;
        block0: for (boolean useReferences : Arrays.asList(false, true)) {
            int numUniqueMatchesLastTime = 0;
            if (lastMatching != null) {
                numUniqueMatchesLastTime = lastMatching.uniqueMatches().size();
            }
            while (true) {
                System.out.println("Round " + ++round + "...");
                ClassMatching matching = new ClassMatching(new ClassIdentifier(sourceJar, sourceIndex, sourceNamer, useReferences), new ClassIdentifier(destJar, destIndex, destNamer, useReferences));
                if (knownMatches != null) {
                    matching.addKnownMatches(knownMatches);
                }
                if (lastMatching == null) {
                    matching.match(sourceIndex.getObfClassEntries(), destIndex.getObfClassEntries());
                } else {
                    matching.addKnownMatches(lastMatching.uniqueMatches());
                    matching.match(lastMatching.unmatchedSourceClasses(), lastMatching.unmatchedDestClasses());
                    for (ClassMatch match : lastMatching.ambiguousMatches()) {
                        matching.match(match.sourceClasses, match.destClasses);
                    }
                }
                System.out.println(matching);
                BiMap<ClassEntry, ClassEntry> uniqueMatches = matching.uniqueMatches();
                if (uniqueMatches.size() <= numUniqueMatchesLastTime) continue block0;
                numUniqueMatchesLastTime = uniqueMatches.size();
                lastMatching = matching;
                ClassNamer namer = new ClassNamer(uniqueMatches);
                sourceNamer = namer.getSourceNamer();
                destNamer = namer.getDestNamer();
            }
        }
        return lastMatching;
    }

    public static Mappings newMappings(ClassMatches matches, Mappings oldMappings, Deobfuscator sourceDeobfuscator, Deobfuscator destDeobfuscator) throws MappingConflict {
        HashMultimap matchesByDestChainSize = HashMultimap.create();
        for (Map.Entry match : matches.getUniqueMatches().entrySet()) {
            int chainSize = destDeobfuscator.getJarIndex().getObfClassChain((ClassEntry)match.getValue()).size();
            matchesByDestChainSize.put(chainSize, match);
        }
        Mappings newMappings = new Mappings();
        ArrayList chainSizes = Lists.newArrayList(matchesByDestChainSize.keySet());
        Collections.sort(chainSizes);
        Iterator iterator = chainSizes.iterator();
        while (iterator.hasNext()) {
            int chainSize = (Integer)iterator.next();
            for (Map.Entry match : matchesByDestChainSize.get(chainSize)) {
                ClassMapping sourceMapping;
                ClassEntry obfSourceClassEntry = (ClassEntry)match.getKey();
                ClassEntry obfDestClassEntry = (ClassEntry)match.getValue();
                List<ClassEntry> destClassChain = destDeobfuscator.getJarIndex().getObfClassChain(obfDestClassEntry);
                if (obfSourceClassEntry.isInnerClass()) {
                    List<ClassMapping> srcClassChain = sourceDeobfuscator.getMappings().getClassMappingChain(obfSourceClassEntry);
                    sourceMapping = srcClassChain.get(srcClassChain.size() - 1);
                } else {
                    sourceMapping = sourceDeobfuscator.getMappings().getClassByObf(obfSourceClassEntry);
                }
                if (sourceMapping == null) continue;
                if (destClassChain.size() == 1) {
                    newMappings.addClassMapping(MappingsConverter.migrateClassMapping(obfDestClassEntry, sourceMapping, matches, false));
                    continue;
                }
                ClassMapping destMapping = null;
                for (int i = 0; i < destClassChain.size() - 1; ++i) {
                    ClassEntry destChainClassEntry = destClassChain.get(i);
                    if (destMapping == null) {
                        destMapping = newMappings.getClassByObf(destChainClassEntry);
                        if (destMapping != null) continue;
                        destMapping = new ClassMapping(destChainClassEntry.getName());
                        newMappings.addClassMapping(destMapping);
                        continue;
                    }
                    if ((destMapping = destMapping.getInnerClassByObfSimple(destChainClassEntry.getInnermostClassName())) != null) continue;
                    destMapping = new ClassMapping(destChainClassEntry.getName());
                    destMapping.addInnerClassMapping(destMapping);
                }
                destMapping.addInnerClassMapping(MappingsConverter.migrateClassMapping(obfDestClassEntry, sourceMapping, matches, true));
            }
        }
        return newMappings;
    }

    private static ClassMapping migrateClassMapping(ClassEntry newObfClass, ClassMapping oldClassMapping, ClassMatches matches, boolean useSimpleName) {
        ClassMapping newClassMapping;
        ClassNameReplacer replacer = className -> {
            ClassEntry newClassEntry = (ClassEntry)matches.getUniqueMatches().get(new ClassEntry(className));
            if (newClassEntry != null) {
                return newClassEntry.getName();
            }
            return null;
        };
        String deobfName = oldClassMapping.getDeobfName();
        if (deobfName != null) {
            if (useSimpleName) {
                deobfName = new ClassEntry(deobfName).getSimpleName();
            }
            newClassMapping = new ClassMapping(newObfClass.getName(), deobfName);
        } else {
            newClassMapping = new ClassMapping(newObfClass.getName());
        }
        for (FieldMapping oldFieldMapping : oldClassMapping.fields()) {
            if (MappingsConverter.canMigrate(oldFieldMapping.getObfType(), matches)) {
                newClassMapping.addFieldMapping(new FieldMapping(oldFieldMapping, replacer));
                continue;
            }
            System.out.println(String.format("Can't map field, dropping: %s.%s %s", oldClassMapping.getDeobfName(), oldFieldMapping.getDeobfName(), oldFieldMapping.getObfType()));
        }
        for (MethodMapping oldMethodMapping : oldClassMapping.methods()) {
            if (MappingsConverter.canMigrate(oldMethodMapping.getObfSignature(), matches)) {
                newClassMapping.addMethodMapping(new MethodMapping(oldMethodMapping, replacer));
                continue;
            }
            System.out.println(String.format("Can't map method, dropping: %s.%s %s", oldClassMapping.getDeobfName(), oldMethodMapping.getDeobfName(), oldMethodMapping.getObfSignature()));
        }
        return newClassMapping;
    }

    private static boolean canMigrate(Signature oldObfSignature, ClassMatches classMatches) {
        for (Type oldObfType : oldObfSignature.types()) {
            if (MappingsConverter.canMigrate(oldObfType, classMatches)) continue;
            return false;
        }
        return true;
    }

    private static boolean canMigrate(Type oldObfType, ClassMatches classMatches) {
        if (!oldObfType.hasClass()) {
            return true;
        }
        ClassEntry classEntry = oldObfType.getClassEntry();
        if (classEntry.getPackageName() != null) {
            return true;
        }
        return classMatches.getUniqueMatches().containsKey(classEntry);
    }

    public static void convertMappings(Mappings mappings, BiMap<ClassEntry, ClassEntry> changes) {
        LinkedHashMap sortedChanges = Maps.newLinkedHashMap();
        int numChangesLeft = changes.size();
        while (!changes.isEmpty()) {
            Iterator iter = changes.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry change = iter.next();
                if (!changes.containsKey(change.getValue())) continue;
                sortedChanges.put(change.getKey(), change.getValue());
                iter.remove();
            }
            if (numChangesLeft - changes.size() <= 0) break;
            numChangesLeft = changes.size();
        }
        if (!changes.isEmpty()) {
            throw new Error("Unable to sort class changes! There must be a cycle.");
        }
        for (Map.Entry entry : sortedChanges.entrySet()) {
            mappings.renameObfClass(((ClassEntry)entry.getKey()).getName(), ((ClassEntry)entry.getValue()).getName());
        }
    }

    public static Doer<FieldEntry> getFieldDoer() {
        return new Doer<FieldEntry>(){

            @Override
            public Collection<FieldEntry> getDroppedEntries(MappingsChecker checker) {
                return checker.getDroppedFieldMappings().keySet();
            }

            @Override
            public Collection<FieldEntry> getObfEntries(JarIndex jarIndex) {
                return jarIndex.getObfFieldEntries();
            }

            @Override
            public Collection<? extends MemberMapping<FieldEntry>> getMappings(ClassMapping destClassMapping) {
                return (Collection)destClassMapping.fields();
            }

            @Override
            public Set<FieldEntry> filterEntries(Collection<FieldEntry> obfDestFields, FieldEntry obfSourceField, ClassMatches classMatches) {
                HashSet<FieldEntry> out = Sets.newHashSet();
                for (FieldEntry obfDestField : obfDestFields) {
                    Type translatedDestType = MappingsConverter.translate(obfDestField.getType(), (BiMap<ClassEntry, ClassEntry>)classMatches.getUniqueMatches().inverse());
                    if (!translatedDestType.equals(obfSourceField.getType())) continue;
                    out.add(obfDestField);
                }
                return out;
            }

            @Override
            public void setUpdateObfMember(ClassMapping classMapping, MemberMapping<FieldEntry> memberMapping, FieldEntry newField) {
                FieldMapping fieldMapping = (FieldMapping)memberMapping;
                classMapping.setFieldObfNameAndType(fieldMapping.getObfName(), fieldMapping.getObfType(), newField.getName(), newField.getType());
            }

            @Override
            public boolean hasObfMember(ClassMapping classMapping, FieldEntry obfField) {
                return classMapping.getFieldByObf(obfField.getName(), obfField.getType()) != null;
            }

            @Override
            public void removeMemberByObf(ClassMapping classMapping, FieldEntry obfField) {
                classMapping.removeFieldMapping(classMapping.getFieldByObf(obfField.getName(), obfField.getType()));
            }
        };
    }

    public static Doer<BehaviorEntry> getMethodDoer() {
        return new Doer<BehaviorEntry>(){

            @Override
            public Collection<BehaviorEntry> getDroppedEntries(MappingsChecker checker) {
                return checker.getDroppedMethodMappings().keySet();
            }

            @Override
            public Collection<BehaviorEntry> getObfEntries(JarIndex jarIndex) {
                return jarIndex.getObfBehaviorEntries();
            }

            @Override
            public Collection<? extends MemberMapping<BehaviorEntry>> getMappings(ClassMapping destClassMapping) {
                return (Collection)destClassMapping.methods();
            }

            @Override
            public Set<BehaviorEntry> filterEntries(Collection<BehaviorEntry> obfDestFields, BehaviorEntry obfSourceField, ClassMatches classMatches) {
                HashSet<BehaviorEntry> out = Sets.newHashSet();
                for (BehaviorEntry obfDestField : obfDestFields) {
                    Signature translatedDestSignature = MappingsConverter.translate(obfDestField.getSignature(), (BiMap<ClassEntry, ClassEntry>)classMatches.getUniqueMatches().inverse());
                    if (translatedDestSignature == null || obfSourceField.getSignature() == null || !translatedDestSignature.equals(obfSourceField.getSignature())) continue;
                    out.add(obfDestField);
                }
                return out;
            }

            @Override
            public void setUpdateObfMember(ClassMapping classMapping, MemberMapping<BehaviorEntry> memberMapping, BehaviorEntry newBehavior) {
                MethodMapping methodMapping = (MethodMapping)memberMapping;
                classMapping.setMethodObfNameAndSignature(methodMapping.getObfName(), methodMapping.getObfSignature(), newBehavior.getName(), newBehavior.getSignature());
            }

            @Override
            public boolean hasObfMember(ClassMapping classMapping, BehaviorEntry obfBehavior) {
                return classMapping.getMethodByObf(obfBehavior.getName(), obfBehavior.getSignature()) != null;
            }

            @Override
            public void removeMemberByObf(ClassMapping classMapping, BehaviorEntry obfBehavior) {
                classMapping.removeMethodMapping(classMapping.getMethodByObf(obfBehavior.getName(), obfBehavior.getSignature()));
            }
        };
    }

    public static int compareMethodByteCode(CodeIterator sourceIt, CodeIterator destIt) {
        int sourcePos = 0;
        int destPos = 0;
        while (sourceIt.hasNext() && destIt.hasNext()) {
            try {
                sourcePos = sourceIt.next();
                destPos = destIt.next();
                if (sourceIt.byteAt(sourcePos) == destIt.byteAt(destPos)) continue;
                return sourcePos;
            }
            catch (BadBytecode badBytecode) {
            }
        }
        if (sourcePos < destPos) {
            return sourcePos;
        }
        if (destPos < sourcePos) {
            return destPos;
        }
        return sourcePos;
    }

    public static BehaviorEntry compareMethods(CtClass destCtClass, CtClass sourceCtClass, BehaviorEntry obfSourceEntry, Set<BehaviorEntry> obfDestEntries) {
        try {
            CtMethod sourceCtClassMethod = sourceCtClass.getMethod(obfSourceEntry.getName(), obfSourceEntry.getSignature().toString());
            CodeAttribute sourceAttribute = sourceCtClassMethod.getMethodInfo().getCodeAttribute();
            if (sourceAttribute == null) {
                return null;
            }
            for (BehaviorEntry desEntry : obfDestEntries) {
                try {
                    CtMethod destCtClassMethod = destCtClass.getMethod(desEntry.getName(), desEntry.getSignature().toString());
                    CodeAttribute destAttribute = destCtClassMethod.getMethodInfo().getCodeAttribute();
                    if (destAttribute == null) continue;
                    CodeIterator destIterator = destAttribute.iterator();
                    int maxPos = MappingsConverter.compareMethodByteCode(sourceAttribute.iterator(), destIterator);
                    if (sourceAttribute.getCodeLength() != maxPos + 1 || maxPos <= 1) continue;
                    return desEntry;
                }
                catch (NotFoundException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (NotFoundException e) {
            e.printStackTrace();
            return null;
        }
        return null;
    }

    public static MemberMatches<BehaviorEntry> computeMethodsMatches(Deobfuscator destDeobfuscator, Mappings destMappings, Deobfuscator sourceDeobfuscator, Mappings sourceMappings, ClassMatches classMatches, Doer<BehaviorEntry> doer) {
        MemberMatches<BehaviorEntry> memberMatches = new MemberMatches<BehaviorEntry>();
        MappingsChecker checker = new MappingsChecker(destDeobfuscator.getJarIndex());
        checker.dropBrokenMappings(destMappings);
        for (BehaviorEntry destObfEntry : doer.getDroppedEntries(checker)) {
            BehaviorEntry srcObfEntry = MappingsConverter.translate(destObfEntry, classMatches.getUniqueMatches().inverse());
            memberMatches.addUnmatchedSourceEntry(srcObfEntry);
        }
        for (ClassMapping classMapping : destMappings.classes()) {
            MappingsConverter.collectMatchedFields(memberMatches, classMapping, classMatches, doer);
        }
        doer.getObfEntries(destDeobfuscator.getJarIndex()).stream().filter(destEntry -> !memberMatches.isMatchedDestEntry((BehaviorEntry)destEntry)).forEach(memberMatches::addUnmatchedDestEntry);
        TranslatingTypeLoader destTypeLoader = destDeobfuscator.createTypeLoader();
        TranslatingTypeLoader sourceTypeLoader = sourceDeobfuscator.createTypeLoader();
        System.out.println("Automatching " + memberMatches.getUnmatchedSourceEntries().size() + " unmatched source entries...");
        for (ClassEntry obfSourceClass : Lists.newArrayList(memberMatches.getSourceClassesWithUnmatchedEntries())) {
            for (BehaviorEntry obfSourceEntry : Lists.newArrayList(memberMatches.getUnmatchedSourceEntries(obfSourceClass))) {
                CtClass sourceCtClass;
                ClassEntry obfDestClass = (ClassEntry)classMatches.getUniqueMatches().get(obfSourceClass);
                Set<BehaviorEntry> obfDestEntries = doer.filterEntries(memberMatches.getUnmatchedDestEntries(obfDestClass), obfSourceEntry, classMatches);
                if (obfDestEntries.size() == 1) {
                    memberMatches.makeMatch(obfSourceEntry, (BehaviorEntry)((Entry)obfDestEntries.iterator().next()));
                    continue;
                }
                if (obfDestEntries.isEmpty()) {
                    memberMatches.makeSourceUnmatchable(obfSourceEntry, null);
                    continue;
                }
                CtClass destCtClass = destTypeLoader.loadClass(obfDestClass.getClassName());
                BehaviorEntry match = MappingsConverter.compareMethods(destCtClass, sourceCtClass = sourceTypeLoader.loadClass(obfSourceClass.getClassName()), obfSourceEntry, obfDestEntries);
                if (match == null) continue;
                memberMatches.makeMatch(obfSourceEntry, match);
            }
        }
        System.out.println(String.format("Ended up with %d ambiguous and %d unmatchable source entries", memberMatches.getUnmatchedSourceEntries().size(), memberMatches.getUnmatchableSourceEntries().size()));
        return memberMatches;
    }

    public static <T extends Entry> MemberMatches<T> computeMemberMatches(Deobfuscator destDeobfuscator, Mappings destMappings, ClassMatches classMatches, Doer<T> doer) {
        MemberMatches<Entry> memberMatches = new MemberMatches<Entry>();
        MappingsChecker checker = new MappingsChecker(destDeobfuscator.getJarIndex());
        checker.dropBrokenMappings(destMappings);
        for (Entry destObfEntry : doer.getDroppedEntries(checker)) {
            Entry srcObfEntry = MappingsConverter.translate(destObfEntry, classMatches.getUniqueMatches().inverse());
            memberMatches.addUnmatchedSourceEntry(srcObfEntry);
        }
        for (ClassMapping classMapping : destMappings.classes()) {
            MappingsConverter.collectMatchedFields(memberMatches, classMapping, classMatches, doer);
        }
        for (Entry destEntry : doer.getObfEntries(destDeobfuscator.getJarIndex())) {
            if (memberMatches.isMatchedDestEntry(destEntry)) continue;
            memberMatches.addUnmatchedDestEntry(destEntry);
        }
        System.out.println("Automatching " + memberMatches.getUnmatchedSourceEntries().size() + " unmatched source entries...");
        for (ClassEntry obfSourceClass : Lists.newArrayList(memberMatches.getSourceClassesWithUnmatchedEntries())) {
            for (Entry obfSourceEntry : Lists.newArrayList(memberMatches.getUnmatchedSourceEntries(obfSourceClass))) {
                ClassEntry obfDestClass = (ClassEntry)classMatches.getUniqueMatches().get(obfSourceClass);
                Set<Entry> obfDestEntries = doer.filterEntries(memberMatches.getUnmatchedDestEntries(obfDestClass), obfSourceEntry, classMatches);
                if (obfDestEntries.size() == 1) {
                    memberMatches.makeMatch(obfSourceEntry, obfDestEntries.iterator().next());
                    continue;
                }
                if (!obfDestEntries.isEmpty()) continue;
                memberMatches.makeSourceUnmatchable(obfSourceEntry, null);
            }
        }
        System.out.println(String.format("Ended up with %d ambiguous and %d unmatchable source entries", memberMatches.getUnmatchedSourceEntries().size(), memberMatches.getUnmatchableSourceEntries().size()));
        return memberMatches;
    }

    private static <T extends Entry> void collectMatchedFields(MemberMatches<T> memberMatches, ClassMapping destClassMapping, ClassMatches classMatches, Doer<T> doer) {
        for (MemberMapping<T> destEntryMapping : doer.getMappings(destClassMapping)) {
            T destObfField = destEntryMapping.getObfEntry(destClassMapping.getObfEntry());
            T srcObfField = MappingsConverter.translate(destObfField, classMatches.getUniqueMatches().inverse());
            memberMatches.addMatch(srcObfField, destObfField);
        }
        for (ClassMapping destInnerClassMapping : destClassMapping.innerClasses()) {
            MappingsConverter.collectMatchedFields(memberMatches, destInnerClassMapping, classMatches, doer);
        }
    }

    private static <T extends Entry> T translate(T in, BiMap<ClassEntry, ClassEntry> map) {
        if (in instanceof FieldEntry) {
            return (T)new FieldEntry((ClassEntry)map.get(in.getClassEntry()), in.getName(), MappingsConverter.translate(((FieldEntry)in).getType(), map));
        }
        if (in instanceof MethodEntry) {
            return (T)new MethodEntry((ClassEntry)map.get(in.getClassEntry()), in.getName(), MappingsConverter.translate(((MethodEntry)in).getSignature(), map));
        }
        if (in instanceof ConstructorEntry) {
            return (T)new ConstructorEntry((ClassEntry)map.get(in.getClassEntry()), MappingsConverter.translate(((ConstructorEntry)in).getSignature(), map));
        }
        throw new Error("Unhandled entry type: " + in.getClass());
    }

    private static Type translate(Type type, BiMap<ClassEntry, ClassEntry> map) {
        return new Type(type, inClassName -> {
            ClassEntry outClassEntry = (ClassEntry)map.get(new ClassEntry(inClassName));
            if (outClassEntry == null) {
                return null;
            }
            return outClassEntry.getName();
        });
    }

    private static Signature translate(Signature signature, BiMap<ClassEntry, ClassEntry> map) {
        if (signature == null) {
            return null;
        }
        return new Signature(signature, inClassName -> {
            ClassEntry outClassEntry = (ClassEntry)map.get(new ClassEntry(inClassName));
            if (outClassEntry == null) {
                return null;
            }
            return outClassEntry.getName();
        });
    }

    public static <T extends Entry> void applyMemberMatches(Mappings mappings, ClassMatches classMatches, MemberMatches<T> memberMatches, Doer<T> doer) {
        for (ClassMapping classMapping : mappings.classes()) {
            MappingsConverter.applyMemberMatches(classMapping, classMatches, memberMatches, doer);
        }
    }

    private static <T extends Entry> void applyMemberMatches(ClassMapping classMapping, ClassMatches classMatches, MemberMatches<T> memberMatches, Doer<T> doer) {
        Entry obfNewDestEntry;
        ClassEntry obfDestClass = new ClassEntry(classMapping.getObfFullName());
        HashMap<Entry, Entry> renames = Maps.newHashMap();
        for (MemberMapping<Entry> memberMapping : Lists.newArrayList(doer.getMappings(classMapping))) {
            Entry entry = memberMapping.getObfEntry(obfDestClass);
            Entry obfSourceEntry = MappingsConverter.getSourceEntryFromDestMapping(memberMapping, obfDestClass, classMatches);
            if (memberMatches.isUnmatchableSourceEntry(obfSourceEntry)) {
                doer.removeMemberByObf(classMapping, entry);
                continue;
            }
            obfNewDestEntry = (Entry)memberMatches.matches().get(obfSourceEntry);
            if (obfNewDestEntry == null || entry.getName().equals(obfNewDestEntry.getName())) continue;
            renames.put(entry, obfNewDestEntry);
        }
        if (!renames.isEmpty()) {
            int numRenamesAppliedThisRound;
            do {
                numRenamesAppliedThisRound = 0;
                for (MemberMapping<Entry> memberMapping : Lists.newArrayList(doer.getMappings(classMapping))) {
                    Entry obfOldDestEntry = memberMapping.getObfEntry(obfDestClass);
                    obfNewDestEntry = (Entry)renames.get(obfOldDestEntry);
                    if (obfNewDestEntry == null || doer.hasObfMember(classMapping, obfNewDestEntry)) continue;
                    doer.setUpdateObfMember(classMapping, memberMapping, obfNewDestEntry);
                    renames.remove(obfOldDestEntry);
                    ++numRenamesAppliedThisRound;
                }
            } while (numRenamesAppliedThisRound > 0);
            if (!renames.isEmpty()) {
                System.err.println(String.format("WARNING: Couldn't apply all the renames for class %s. %d renames left.", classMapping.getObfFullName(), renames.size()));
                for (Map.Entry entry : renames.entrySet()) {
                    System.err.println(String.format("\t%s -> %s", ((Entry)entry.getKey()).getName(), ((Entry)entry.getValue()).getName()));
                }
            }
        }
        for (ClassMapping classMapping2 : classMapping.innerClasses()) {
            MappingsConverter.applyMemberMatches(classMapping2, classMatches, memberMatches, doer);
        }
    }

    private static <T extends Entry> T getSourceEntryFromDestMapping(MemberMapping<T> destMemberMapping, ClassEntry obfDestClass, ClassMatches classMatches) {
        return MappingsConverter.translate(destMemberMapping.getObfEntry(obfDestClass), classMatches.getUniqueMatches().inverse());
    }

    public static interface Doer<T extends Entry> {
        public Collection<T> getDroppedEntries(MappingsChecker var1);

        public Collection<T> getObfEntries(JarIndex var1);

        public Collection<? extends MemberMapping<T>> getMappings(ClassMapping var1);

        public Set<T> filterEntries(Collection<T> var1, T var2, ClassMatches var3);

        public void setUpdateObfMember(ClassMapping var1, MemberMapping<T> var2, T var3);

        public boolean hasObfMember(ClassMapping var1, T var2);

        public void removeMemberByObf(ClassMapping var1, T var2);
    }
}

