/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.convert;

import com.google.common.collect.Lists;
import cuchaz.enigma.convert.ClassMatch;
import cuchaz.enigma.convert.ClassMatches;
import cuchaz.enigma.convert.MemberMatches;
import cuchaz.enigma.mapping.ClassEntry;
import cuchaz.enigma.mapping.Entry;
import cuchaz.enigma.mapping.EntryFactory;
import cuchaz.enigma.mapping.FieldEntry;
import cuchaz.enigma.mapping.Type;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;

public class MatchesReader {
    public static ClassMatches readClasses(File file) throws IOException {
        try (BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), Charset.forName("UTF-8")));){
            String line;
            ClassMatches matches = new ClassMatches();
            while ((line = in.readLine()) != null) {
                matches.add(MatchesReader.readClassMatch(line));
            }
            ClassMatches classMatches = matches;
            return classMatches;
        }
    }

    private static ClassMatch readClassMatch(String line) {
        String[] sides = line.split(":", 2);
        return new ClassMatch(MatchesReader.readClasses(sides[0]), MatchesReader.readClasses(sides[1]));
    }

    private static Collection<ClassEntry> readClasses(String in) {
        ArrayList<ClassEntry> entries = Lists.newArrayList();
        for (String className : in.split(",")) {
            if ((className = className.trim()).isEmpty()) continue;
            entries.add(new ClassEntry(className));
        }
        return entries;
    }

    public static <T extends Entry> MemberMatches<T> readMembers(File file) throws IOException {
        try (BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), Charset.forName("UTF-8")));){
            String line;
            MemberMatches matches = new MemberMatches();
            while ((line = in.readLine()) != null) {
                MatchesReader.readMemberMatch(matches, line);
            }
            MemberMatches memberMatches = matches;
            return memberMatches;
        }
    }

    private static <T extends Entry> void readMemberMatch(MemberMatches<T> matches, String line) {
        if (line.startsWith("!")) {
            T source = MatchesReader.readEntry(line.substring(1));
            matches.addUnmatchableSourceEntry(source);
        } else {
            String[] parts = line.split(":", 2);
            T source = MatchesReader.readEntry(parts[0]);
            T dest = MatchesReader.readEntry(parts[1]);
            if (source != null && dest != null) {
                matches.addMatch(source, dest);
            } else if (source != null) {
                matches.addUnmatchedSourceEntry(source);
            } else if (dest != null) {
                matches.addUnmatchedDestEntry(dest);
            }
        }
    }

    private static <T extends Entry> T readEntry(String in) {
        if (in.length() <= 0) {
            return null;
        }
        String[] parts = in.split(" ");
        if (parts.length == 3 && parts[2].indexOf(40) < 0) {
            return (T)new FieldEntry(new ClassEntry(parts[0]), parts[1], new Type(parts[2]));
        }
        assert (parts.length == 2 || parts.length == 3);
        if (parts.length == 2) {
            return (T)EntryFactory.getBehaviorEntry(parts[0], parts[1]);
        }
        if (parts.length == 3) {
            return (T)EntryFactory.getBehaviorEntry(parts[0], parts[1], parts[2]);
        }
        throw new Error("Malformed behavior entry: " + in);
    }
}

