/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.convert;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import cuchaz.enigma.Deobfuscator;
import cuchaz.enigma.mapping.ClassEntry;
import cuchaz.enigma.mapping.Entry;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class MemberMatches<T extends Entry> {
    private BiMap<T, T> matches = HashBiMap.create();
    private Multimap<ClassEntry, T> matchedSourceEntries = HashMultimap.create();
    private Multimap<ClassEntry, T> unmatchedSourceEntries = HashMultimap.create();
    private Multimap<ClassEntry, T> unmatchedDestEntries = HashMultimap.create();
    private Multimap<ClassEntry, T> unmatchableSourceEntries = HashMultimap.create();

    public void addMatch(T srcEntry, T destEntry) {
        boolean wasAdded;
        boolean bl = wasAdded = this.matches.put(srcEntry, destEntry) == null;
        assert (wasAdded);
        wasAdded = this.matchedSourceEntries.put(srcEntry.getClassEntry(), srcEntry);
        assert (wasAdded);
    }

    public void addUnmatchedSourceEntry(T sourceEntry) {
        boolean wasAdded = this.unmatchedSourceEntries.put(sourceEntry.getClassEntry(), sourceEntry);
        assert (wasAdded);
    }

    public void addUnmatchedSourceEntries(Iterable<T> sourceEntries) {
        for (Entry sourceEntry : sourceEntries) {
            this.addUnmatchedSourceEntry(sourceEntry);
        }
    }

    public void addUnmatchedDestEntry(T destEntry) {
        if (destEntry.getName().equals("<clinit>") || destEntry.getName().equals("<init>")) {
            return;
        }
        boolean wasAdded = this.unmatchedDestEntries.put(destEntry.getClassEntry(), destEntry);
        assert (wasAdded);
    }

    public void addUnmatchedDestEntries(Iterable<T> destEntriesntries) {
        for (Entry entry : destEntriesntries) {
            this.addUnmatchedDestEntry(entry);
        }
    }

    public void addUnmatchableSourceEntry(T sourceEntry) {
        boolean wasAdded = this.unmatchableSourceEntries.put(sourceEntry.getClassEntry(), sourceEntry);
        assert (wasAdded);
    }

    public Set<ClassEntry> getSourceClassesWithUnmatchedEntries() {
        return this.unmatchedSourceEntries.keySet();
    }

    public Collection<ClassEntry> getSourceClassesWithoutUnmatchedEntries() {
        HashSet<ClassEntry> out = Sets.newHashSet();
        out.addAll(this.matchedSourceEntries.keySet());
        out.removeAll(this.unmatchedSourceEntries.keySet());
        return out;
    }

    public Collection<T> getUnmatchedSourceEntries() {
        return this.unmatchedSourceEntries.values();
    }

    public Collection<T> getUnmatchedSourceEntries(ClassEntry sourceClass) {
        return this.unmatchedSourceEntries.get(sourceClass);
    }

    public Collection<T> getUnmatchedDestEntries() {
        return this.unmatchedDestEntries.values();
    }

    public Collection<T> getUnmatchedDestEntries(ClassEntry destClass) {
        return this.unmatchedDestEntries.get(destClass);
    }

    public Collection<T> getUnmatchableSourceEntries() {
        return this.unmatchableSourceEntries.values();
    }

    public boolean hasSource(T sourceEntry) {
        return this.matches.containsKey(sourceEntry) || this.unmatchedSourceEntries.containsValue(sourceEntry);
    }

    public boolean hasDest(T destEntry) {
        return this.matches.containsValue(destEntry) || this.unmatchedDestEntries.containsValue(destEntry);
    }

    public BiMap<T, T> matches() {
        return this.matches;
    }

    public boolean isMatchedSourceEntry(T sourceEntry) {
        return this.matches.containsKey(sourceEntry);
    }

    public boolean isMatchedDestEntry(T destEntry) {
        return this.matches.containsValue(destEntry);
    }

    public boolean isUnmatchableSourceEntry(T sourceEntry) {
        return this.unmatchableSourceEntries.containsEntry(sourceEntry.getClassEntry(), sourceEntry);
    }

    public void makeMatch(T sourceEntry, T destEntry) {
        this.makeMatch(sourceEntry, destEntry, null, null);
    }

    public void makeMatch(T sourceEntry, T destEntry, Deobfuscator sourceDeobfuscator, Deobfuscator destDeobfuscator) {
        if (sourceDeobfuscator != null && destDeobfuscator != null) {
            this.makeMatch(sourceEntry, destEntry);
            sourceEntry = sourceEntry.cloneToNewClass(sourceDeobfuscator.getJarIndex().getTranslationIndex().resolveEntryClass((Entry)sourceEntry, true));
            destEntry = destEntry.cloneToNewClass(destDeobfuscator.getJarIndex().getTranslationIndex().resolveEntryClass((Entry)destEntry, true));
        }
        boolean wasRemoved = this.unmatchedSourceEntries.remove(sourceEntry.getClassEntry(), sourceEntry);
        assert (wasRemoved);
        wasRemoved = this.unmatchedDestEntries.remove(destEntry.getClassEntry(), destEntry);
        assert (wasRemoved);
        this.addMatch(sourceEntry, destEntry);
    }

    public boolean isMatched(T sourceEntry, T destEntry) {
        Entry match = (Entry)this.matches.get(sourceEntry);
        return match != null && match.equals(destEntry);
    }

    public void unmakeMatch(T sourceEntry, T destEntry, Deobfuscator sourceDeobfuscator, Deobfuscator destDeobfuscator) {
        boolean wasRemoved;
        if (sourceDeobfuscator != null && destDeobfuscator != null) {
            this.unmakeMatch(sourceEntry, destEntry, null, null);
            sourceEntry = sourceEntry.cloneToNewClass(sourceDeobfuscator.getJarIndex().getTranslationIndex().resolveEntryClass((Entry)sourceEntry, true));
            destEntry = destEntry.cloneToNewClass(destDeobfuscator.getJarIndex().getTranslationIndex().resolveEntryClass((Entry)destEntry, true));
        }
        boolean bl = wasRemoved = this.matches.remove(sourceEntry) != null;
        assert (wasRemoved);
        wasRemoved = this.matchedSourceEntries.remove(sourceEntry.getClassEntry(), sourceEntry);
        assert (wasRemoved);
        this.addUnmatchedSourceEntry(sourceEntry);
        this.addUnmatchedDestEntry(destEntry);
    }

    public void makeSourceUnmatchable(T sourceEntry, Deobfuscator sourceDeobfuscator) {
        if (sourceDeobfuscator != null) {
            this.makeSourceUnmatchable(sourceEntry, null);
            sourceEntry = sourceEntry.cloneToNewClass(sourceDeobfuscator.getJarIndex().getTranslationIndex().resolveEntryClass((Entry)sourceEntry, true));
        }
        assert (!this.isMatchedSourceEntry(sourceEntry));
        boolean wasRemoved = this.unmatchedSourceEntries.remove(sourceEntry.getClassEntry(), sourceEntry);
        assert (wasRemoved);
        this.addUnmatchableSourceEntry(sourceEntry);
    }
}

