/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.gui;

import com.google.common.collect.BiMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import cuchaz.enigma.Deobfuscator;
import cuchaz.enigma.convert.ClassIdentifier;
import cuchaz.enigma.convert.ClassIdentity;
import cuchaz.enigma.convert.ClassMatch;
import cuchaz.enigma.convert.ClassMatches;
import cuchaz.enigma.convert.ClassMatching;
import cuchaz.enigma.convert.ClassNamer;
import cuchaz.enigma.convert.MappingsConverter;
import cuchaz.enigma.gui.ClassSelector;
import cuchaz.enigma.gui.CodeReader;
import cuchaz.enigma.gui.GuiTricks;
import cuchaz.enigma.gui.ScoredClassEntry;
import cuchaz.enigma.gui.node.ClassSelectorClassNode;
import cuchaz.enigma.gui.node.ClassSelectorPackageNode;
import cuchaz.enigma.mapping.ClassEntry;
import cuchaz.enigma.mapping.Mappings;
import cuchaz.enigma.mapping.MappingsChecker;
import cuchaz.enigma.throwables.MappingConflict;
import de.sciss.syntaxpane.DefaultSyntaxKit;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;

public class ClassMatchingGui {
    private JFrame frame;
    private ClassSelector sourceClasses;
    private ClassSelector destClasses;
    private CodeReader sourceReader;
    private CodeReader destReader;
    private JLabel sourceClassLabel;
    private JLabel destClassLabel;
    private JButton matchButton;
    private Map<SourceType, JRadioButton> sourceTypeButtons;
    private JCheckBox advanceCheck;
    private JCheckBox top10Matches;
    private ClassMatches classMatches;
    private Deobfuscator sourceDeobfuscator;
    private Deobfuscator destDeobfuscator;
    private ClassEntry sourceClass;
    private ClassEntry destClass;
    private SourceType sourceType;
    private SaveListener saveListener;

    public ClassMatchingGui(ClassMatches matches, Deobfuscator sourceDeobfuscator, Deobfuscator destDeobfuscator) {
        this.classMatches = matches;
        this.sourceDeobfuscator = sourceDeobfuscator;
        this.destDeobfuscator = destDeobfuscator;
        this.frame = new JFrame("Enigma - Class Matcher");
        Container pane = this.frame.getContentPane();
        pane.setLayout(new BorderLayout());
        JPanel sourcePanel = new JPanel();
        sourcePanel.setLayout(new BoxLayout(sourcePanel, 3));
        sourcePanel.setPreferredSize(new Dimension(200, 0));
        pane.add((Component)sourcePanel, "West");
        sourcePanel.add(new JLabel("Source Classes"));
        JPanel sourceTypePanel = new JPanel();
        sourcePanel.add(sourceTypePanel);
        sourceTypePanel.setLayout(new BoxLayout(sourceTypePanel, 3));
        ActionListener sourceTypeListener = event -> this.setSourceType(SourceType.valueOf(event.getActionCommand()));
        ButtonGroup sourceTypeButtons = new ButtonGroup();
        this.sourceTypeButtons = Maps.newHashMap();
        for (SourceType sourceType : SourceType.values()) {
            JRadioButton button = sourceType.newRadio(sourceTypeListener, sourceTypeButtons);
            this.sourceTypeButtons.put(sourceType, button);
            sourceTypePanel.add(button);
        }
        this.sourceClasses = new ClassSelector(null, ClassSelector.DEOBF_CLASS_COMPARATOR, false);
        this.sourceClasses.setSelectionListener(this::setSourceClass);
        JScrollPane sourceScroller = new JScrollPane(this.sourceClasses);
        sourcePanel.add(sourceScroller);
        JPanel destPanel = new JPanel();
        destPanel.setLayout(new BoxLayout(destPanel, 3));
        destPanel.setPreferredSize(new Dimension(200, 0));
        pane.add((Component)destPanel, "West");
        destPanel.add(new JLabel("Destination Classes"));
        this.top10Matches = new JCheckBox("Show only top 10 matches");
        destPanel.add(this.top10Matches);
        this.top10Matches.addActionListener(event -> this.toggleTop10Matches());
        this.destClasses = new ClassSelector(null, ClassSelector.DEOBF_CLASS_COMPARATOR, false);
        this.destClasses.setSelectionListener(this::setDestClass);
        JScrollPane destScroller = new JScrollPane(this.destClasses);
        destPanel.add(destScroller);
        JButton autoMatchButton = new JButton("AutoMatch");
        autoMatchButton.addActionListener(event -> this.autoMatch());
        destPanel.add(autoMatchButton);
        DefaultSyntaxKit.initKit();
        this.sourceReader = new CodeReader();
        this.destReader = new CodeReader();
        JSplitPane splitLeft = new JSplitPane(1, true, sourcePanel, new JScrollPane(this.sourceReader));
        splitLeft.setResizeWeight(0.0);
        JSplitPane splitRight = new JSplitPane(1, true, new JScrollPane(this.destReader), destPanel);
        splitRight.setResizeWeight(1.0);
        JSplitPane splitCenter = new JSplitPane(1, true, splitLeft, splitRight);
        splitCenter.setResizeWeight(0.5);
        pane.add((Component)splitCenter, "Center");
        splitCenter.resetToPreferredSizes();
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new FlowLayout());
        this.sourceClassLabel = new JLabel();
        this.sourceClassLabel.setHorizontalAlignment(4);
        this.destClassLabel = new JLabel();
        this.destClassLabel.setHorizontalAlignment(2);
        this.matchButton = new JButton();
        this.advanceCheck = new JCheckBox("Advance to next likely match");
        this.advanceCheck.addActionListener(event -> {
            if (this.advanceCheck.isSelected()) {
                this.advance();
            }
        });
        bottomPanel.add(this.sourceClassLabel);
        bottomPanel.add(this.matchButton);
        bottomPanel.add(this.destClassLabel);
        bottomPanel.add(this.advanceCheck);
        pane.add((Component)bottomPanel, "South");
        pane.doLayout();
        this.frame.setSize(1024, 576);
        this.frame.setMinimumSize(new Dimension(640, 480));
        this.frame.setVisible(true);
        this.frame.setDefaultCloseOperation(2);
        this.updateDestMappings();
        this.setSourceType(SourceType.getDefault());
        this.updateMatchButton();
        this.saveListener = null;
    }

    public void setSaveListener(SaveListener val) {
        this.saveListener = val;
    }

    private void updateDestMappings() {
        try {
            Mappings newMappings = MappingsConverter.newMappings(this.classMatches, this.sourceDeobfuscator.getMappings(), this.sourceDeobfuscator, this.destDeobfuscator);
            MappingsChecker checker = new MappingsChecker(this.destDeobfuscator.getJarIndex());
            checker.dropBrokenMappings(newMappings);
            int numDroppedFields = checker.getDroppedFieldMappings().size();
            int numDroppedMethods = checker.getDroppedMethodMappings().size();
            System.out.println(String.format("%d mappings from matched classes don't match the dest jar:\n\t%5d fields\n\t%5d methods", numDroppedFields + numDroppedMethods, numDroppedFields, numDroppedMethods));
            this.destDeobfuscator.setMappings(newMappings);
        }
        catch (MappingConflict ex) {
            System.out.println(ex.getMessage());
            ex.printStackTrace();
            return;
        }
    }

    protected void setSourceType(SourceType val) {
        this.sourceType = val;
        this.sourceClasses.setClasses(this.deobfuscateClasses(this.sourceType.getSourceClasses(this.classMatches), this.sourceDeobfuscator));
        for (SourceType sourceType : SourceType.values()) {
            this.sourceTypeButtons.get((Object)sourceType).setText(String.format("%s (%d)", sourceType.name(), sourceType.getSourceClasses(this.classMatches).size()));
        }
    }

    private Collection<ClassEntry> deobfuscateClasses(Collection<ClassEntry> in, Deobfuscator deobfuscator) {
        ArrayList<ClassEntry> out = Lists.newArrayList();
        for (ClassEntry entry : in) {
            ClassEntry deobf = deobfuscator.deobfuscateEntry(entry);
            if (entry instanceof ScoredClassEntry) {
                deobf = new ScoredClassEntry(deobf, ((ScoredClassEntry)entry).getScore());
            }
            out.add(deobf);
        }
        return out;
    }

    protected void setSourceClass(ClassEntry classEntry) {
        Runnable onGetDestClasses = null;
        if (this.advanceCheck.isSelected()) {
            onGetDestClasses = this::pickBestDestClass;
        }
        this.setSourceClass(classEntry, onGetDestClasses);
    }

    protected void setSourceClass(ClassEntry classEntry, Runnable onGetDestClasses) {
        this.sourceClass = classEntry;
        this.sourceClassLabel.setText(this.sourceClass != null ? this.sourceClass.getName() : "");
        if (this.sourceClass != null) {
            ClassMatch match = this.classMatches.getMatchBySource(this.sourceDeobfuscator.obfuscateEntry(this.sourceClass));
            assert (match != null);
            if (match.destClasses.isEmpty()) {
                this.destClasses.setClasses(null);
                new Thread(() -> {
                    this.destClasses.setClasses(this.deobfuscateClasses(this.getLikelyMatches(this.sourceClass), this.destDeobfuscator));
                    this.destClasses.expandAll();
                    if (onGetDestClasses != null) {
                        onGetDestClasses.run();
                    }
                }).start();
            } else {
                this.destClasses.setClasses(this.deobfuscateClasses(match.destClasses, this.destDeobfuscator));
                this.destClasses.expandAll();
                if (onGetDestClasses != null) {
                    onGetDestClasses.run();
                }
            }
        }
        this.setDestClass(null);
        this.sourceReader.decompileClass(this.sourceClass, this.sourceDeobfuscator, () -> this.sourceReader.navigateToClassDeclaration(this.sourceClass));
        this.updateMatchButton();
    }

    private Collection<ClassEntry> getLikelyMatches(ClassEntry sourceClass) {
        ClassEntry obfSourceClass = this.sourceDeobfuscator.obfuscateEntry(sourceClass);
        ClassNamer namer = new ClassNamer(this.classMatches.getUniqueMatches());
        ClassIdentifier sourceIdentifier = new ClassIdentifier(this.sourceDeobfuscator.getJar(), this.sourceDeobfuscator.getJarIndex(), namer.getSourceNamer(), true);
        ClassIdentifier destIdentifier = new ClassIdentifier(this.destDeobfuscator.getJar(), this.destDeobfuscator.getJarIndex(), namer.getDestNamer(), true);
        try {
            ClassIdentity sourceIdentity = sourceIdentifier.identify(obfSourceClass);
            List<ClassEntry> scoredDestClasses = Lists.newArrayList();
            for (ClassEntry unmatchedDestClass : this.classMatches.getUnmatchedDestClasses()) {
                ClassIdentity destIdentity = destIdentifier.identify(unmatchedDestClass);
                float score = 100.0f * (float)(sourceIdentity.getMatchScore(destIdentity) + destIdentity.getMatchScore(sourceIdentity)) / (float)(sourceIdentity.getMaxMatchScore() + destIdentity.getMaxMatchScore());
                scoredDestClasses.add(new ScoredClassEntry(unmatchedDestClass, score));
            }
            if (this.top10Matches.isSelected() && scoredDestClasses.size() > 10) {
                scoredDestClasses.sort((a, b) -> {
                    ScoredClassEntry sa = (ScoredClassEntry)a;
                    ScoredClassEntry sb = (ScoredClassEntry)b;
                    return -Float.compare(sa.getScore(), sb.getScore());
                });
                scoredDestClasses = scoredDestClasses.subList(0, 10);
            }
            return scoredDestClasses;
        }
        catch (ClassNotFoundException ex) {
            throw new Error("Unable to find class " + ex.getMessage());
        }
    }

    protected void setDestClass(ClassEntry classEntry) {
        this.destClass = classEntry;
        this.destClassLabel.setText(this.destClass != null ? this.destClass.getName() : "");
        this.destReader.decompileClass(this.destClass, this.destDeobfuscator, () -> this.destReader.navigateToClassDeclaration(this.destClass));
        this.updateMatchButton();
    }

    private void updateMatchButton() {
        ClassEntry obfSource = this.sourceDeobfuscator.obfuscateEntry(this.sourceClass);
        ClassEntry obfDest = this.destDeobfuscator.obfuscateEntry(this.destClass);
        BiMap<ClassEntry, ClassEntry> uniqueMatches = this.classMatches.getUniqueMatches();
        boolean twoSelected = this.sourceClass != null && this.destClass != null;
        boolean isMatched = uniqueMatches.containsKey(obfSource) && uniqueMatches.containsValue(obfDest);
        boolean canMatch = !uniqueMatches.containsKey(obfSource) && !uniqueMatches.containsValue(obfDest);
        GuiTricks.deactivateButton(this.matchButton);
        if (twoSelected) {
            if (isMatched) {
                GuiTricks.activateButton(this.matchButton, "Unmatch", event -> this.onUnmatchClick());
            } else if (canMatch) {
                GuiTricks.activateButton(this.matchButton, "Match", event -> this.onMatchClick());
            }
        }
    }

    private void onMatchClick() {
        ClassEntry obfSource = this.sourceDeobfuscator.obfuscateEntry(this.sourceClass);
        ClassEntry obfDest = this.destDeobfuscator.obfuscateEntry(this.destClass);
        this.classMatches.removeSource(obfSource);
        this.classMatches.removeDest(obfDest);
        this.classMatches.add(new ClassMatch(obfSource, obfDest));
        ClassEntry nextClass = null;
        if (this.advanceCheck.isSelected()) {
            nextClass = this.sourceClasses.getNextClass(this.sourceClass);
        }
        this.save();
        this.updateMatches();
        if (nextClass != null) {
            this.advance(nextClass);
        }
    }

    private void onUnmatchClick() {
        ClassEntry obfSource = this.sourceDeobfuscator.obfuscateEntry(this.sourceClass);
        this.classMatches.removeSource(obfSource);
        this.classMatches.add(new ClassMatch(obfSource, null));
        this.save();
        this.updateMatches();
    }

    private void updateMatches() {
        this.updateDestMappings();
        this.setDestClass(null);
        this.destClasses.setClasses(null);
        this.updateMatchButton();
        String packageName = this.sourceClasses.getSelectedPackage();
        this.setSourceType(this.sourceType);
        this.sourceClasses.expandPackage(packageName);
    }

    private void save() {
        if (this.saveListener != null) {
            this.saveListener.save(this.classMatches);
        }
    }

    private void autoMatch() {
        System.out.println("Automatching...");
        ClassMatching matching = MappingsConverter.computeMatching(this.sourceDeobfuscator.getJar(), this.sourceDeobfuscator.getJarIndex(), this.destDeobfuscator.getJar(), this.destDeobfuscator.getJarIndex(), this.classMatches.getUniqueMatches());
        ClassMatches newMatches = new ClassMatches(matching.matches());
        System.out.println(String.format("Automatch found %d new matches", newMatches.getUniqueMatches().size() - this.classMatches.getUniqueMatches().size()));
        this.classMatches = newMatches;
        this.save();
        this.updateMatches();
    }

    private void advance() {
        this.advance(null);
    }

    private void advance(ClassEntry sourceClass) {
        if (sourceClass == null) {
            sourceClass = this.sourceClasses.getSelectedClass();
            sourceClass = sourceClass != null ? this.sourceClasses.getNextClass(sourceClass) : this.sourceClasses.getFirstClass();
        }
        this.setSourceClass(sourceClass, this::pickBestDestClass);
        this.sourceClasses.setSelectionClass(sourceClass);
    }

    private void pickBestDestClass() {
        ClassEntry firstClass = null;
        ClassEntry bestDestClass = null;
        for (ClassSelectorPackageNode packageNode : this.destClasses.packageNodes()) {
            for (ClassSelectorClassNode classNode : this.destClasses.classNodes(packageNode)) {
                if (firstClass == null) {
                    firstClass = classNode.getClassEntry();
                }
                if (!(classNode.getClassEntry() instanceof ScoredClassEntry)) continue;
                ScoredClassEntry scoredClass = (ScoredClassEntry)classNode.getClassEntry();
                if (bestDestClass != null && !(((ScoredClassEntry)bestDestClass).getScore() < scoredClass.getScore())) continue;
                bestDestClass = scoredClass;
            }
        }
        ClassEntry destClass = null;
        if (bestDestClass != null) {
            destClass = bestDestClass;
        } else if (firstClass != null) {
            destClass = firstClass;
        }
        this.setDestClass(destClass);
        this.destClasses.setSelectionClass(destClass);
    }

    private void toggleTop10Matches() {
        if (this.sourceClass != null) {
            this.destClasses.clearSelection();
            this.destClasses.setClasses(this.deobfuscateClasses(this.getLikelyMatches(this.sourceClass), this.destDeobfuscator));
            this.destClasses.expandAll();
        }
    }

    public static interface SaveListener {
        public void save(ClassMatches var1);
    }

    private static enum SourceType {
        Matched{

            @Override
            public Collection<ClassEntry> getSourceClasses(ClassMatches matches) {
                return matches.getUniqueMatches().keySet();
            }
        }
        ,
        Unmatched{

            @Override
            public Collection<ClassEntry> getSourceClasses(ClassMatches matches) {
                return matches.getUnmatchedSourceClasses();
            }
        }
        ,
        Ambiguous{

            @Override
            public Collection<ClassEntry> getSourceClasses(ClassMatches matches) {
                return matches.getAmbiguouslyMatchedSourceClasses();
            }
        };


        public static SourceType getDefault() {
            return SourceType.values()[0];
        }

        public JRadioButton newRadio(ActionListener listener, ButtonGroup group) {
            JRadioButton button = new JRadioButton(this.name(), this == SourceType.getDefault());
            button.setActionCommand(this.name());
            button.addActionListener(listener);
            group.add(button);
            return button;
        }

        public abstract Collection<ClassEntry> getSourceClasses(ClassMatches var1);
    }
}

