/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.gui;

import com.google.common.collect.Lists;
import cuchaz.enigma.ExceptionIgnorer;
import cuchaz.enigma.analysis.BehaviorReferenceTreeNode;
import cuchaz.enigma.analysis.ClassImplementationsTreeNode;
import cuchaz.enigma.analysis.ClassInheritanceTreeNode;
import cuchaz.enigma.analysis.EntryReference;
import cuchaz.enigma.analysis.FieldReferenceTreeNode;
import cuchaz.enigma.analysis.MethodImplementationsTreeNode;
import cuchaz.enigma.analysis.MethodInheritanceTreeNode;
import cuchaz.enigma.analysis.ReferenceTreeNode;
import cuchaz.enigma.analysis.Token;
import cuchaz.enigma.gui.CodeReader;
import cuchaz.enigma.gui.GuiController;
import cuchaz.enigma.gui.TokenListCellRenderer;
import cuchaz.enigma.gui.dialog.CrashDialog;
import cuchaz.enigma.gui.elements.MenuBar;
import cuchaz.enigma.gui.elements.PopupMenuBar;
import cuchaz.enigma.gui.filechooser.FileChooserAny;
import cuchaz.enigma.gui.filechooser.FileChooserFile;
import cuchaz.enigma.gui.filechooser.FileChooserFolder;
import cuchaz.enigma.gui.highlight.DeobfuscatedHighlightPainter;
import cuchaz.enigma.gui.highlight.ObfuscatedHighlightPainter;
import cuchaz.enigma.gui.highlight.OtherHighlightPainter;
import cuchaz.enigma.gui.highlight.SelectionHighlightPainter;
import cuchaz.enigma.gui.node.ClassSelectorPackageNode;
import cuchaz.enigma.gui.panels.PanelDeobf;
import cuchaz.enigma.gui.panels.PanelEditor;
import cuchaz.enigma.gui.panels.PanelIdentifier;
import cuchaz.enigma.gui.panels.PanelObf;
import cuchaz.enigma.mapping.ArgumentEntry;
import cuchaz.enigma.mapping.ClassEntry;
import cuchaz.enigma.mapping.ConstructorEntry;
import cuchaz.enigma.mapping.Entry;
import cuchaz.enigma.mapping.FieldEntry;
import cuchaz.enigma.mapping.LocalVariableEntry;
import cuchaz.enigma.mapping.Mappings;
import cuchaz.enigma.mapping.MethodEntry;
import cuchaz.enigma.mapping.Signature;
import cuchaz.enigma.throwables.IllegalNameException;
import cuchaz.enigma.utils.Utils;
import de.sciss.syntaxpane.DefaultSyntaxKit;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Vector;
import java.util.function.Function;
import javassist.bytecode.Descriptor;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.text.BadLocationException;
import javax.swing.text.Highlighter;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class Gui {
    public final PopupMenuBar popupMenu;
    private final PanelObf obfPanel;
    private final PanelDeobf deobfPanel;
    private final MenuBar menuBar;
    public EntryReference<Entry, Entry> reference;
    public JFileChooser jarFileChooser;
    public JFileChooser tinyMappingsFileChooser;
    public JFileChooser enigmaMappingsFileChooser;
    public JFileChooser exportSourceFileChooser;
    public JFileChooser exportJarFileChooser;
    private GuiController controller;
    private JFrame frame = new JFrame("Enigma");
    private PanelEditor editor;
    private JPanel classesPanel;
    private JSplitPane splitClasses;
    private PanelIdentifier infoPanel;
    private ObfuscatedHighlightPainter obfuscatedHighlightPainter;
    private DeobfuscatedHighlightPainter deobfuscatedHighlightPainter;
    private OtherHighlightPainter otherHighlightPainter;
    private SelectionHighlightPainter selectionHighlightPainter;
    private JTree inheritanceTree;
    private JTree implementationsTree;
    private JTree callsTree;
    private JList<Token> tokens;
    private JTabbedPane tabs;

    public Gui() {
        Container pane = this.frame.getContentPane();
        pane.setLayout(new BorderLayout());
        if (Boolean.parseBoolean(System.getProperty("enigma.catchExceptions", "true"))) {
            CrashDialog.init(this.frame);
            Thread.setDefaultUncaughtExceptionHandler((thread, t) -> {
                t.printStackTrace(System.err);
                if (!ExceptionIgnorer.shouldIgnore(t)) {
                    CrashDialog.show(t);
                }
            });
        }
        this.controller = new GuiController(this);
        this.jarFileChooser = new FileChooserFile();
        this.tinyMappingsFileChooser = new FileChooserFile();
        this.enigmaMappingsFileChooser = new FileChooserAny();
        this.exportSourceFileChooser = new FileChooserFolder();
        this.exportJarFileChooser = new FileChooserFile();
        this.obfPanel = new PanelObf(this);
        this.deobfPanel = new PanelDeobf(this);
        this.splitClasses = new JSplitPane(0, true, this.obfPanel, this.deobfPanel);
        this.splitClasses.setResizeWeight(0.3);
        this.classesPanel = new JPanel();
        this.classesPanel.setLayout(new BorderLayout());
        this.classesPanel.setPreferredSize(new Dimension(250, 0));
        this.infoPanel = new PanelIdentifier(this);
        this.infoPanel.clearReference();
        DefaultSyntaxKit.initKit();
        this.obfuscatedHighlightPainter = new ObfuscatedHighlightPainter();
        this.deobfuscatedHighlightPainter = new DeobfuscatedHighlightPainter();
        this.otherHighlightPainter = new OtherHighlightPainter();
        this.selectionHighlightPainter = new SelectionHighlightPainter();
        this.editor = new PanelEditor(this);
        JScrollPane sourceScroller = new JScrollPane(this.editor);
        this.editor.setContentType("text/java");
        DefaultSyntaxKit kit = (DefaultSyntaxKit)this.editor.getEditorKit();
        kit.toggleComponent(this.editor, "de.sciss.syntaxpane.components.TokenMarker");
        this.popupMenu = new PopupMenuBar(this);
        this.editor.setComponentPopupMenu(this.popupMenu);
        this.inheritanceTree = new JTree();
        this.inheritanceTree.setModel(null);
        this.inheritanceTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                if (event.getClickCount() == 2) {
                    MethodInheritanceTreeNode methodNode;
                    TreePath path = Gui.this.inheritanceTree.getSelectionPath();
                    if (path == null) {
                        return;
                    }
                    Object node = path.getLastPathComponent();
                    if (node instanceof ClassInheritanceTreeNode) {
                        ClassInheritanceTreeNode classNode = (ClassInheritanceTreeNode)node;
                        Gui.this.navigateTo(new ClassEntry(classNode.getObfClassName()));
                    } else if (node instanceof MethodInheritanceTreeNode && (methodNode = (MethodInheritanceTreeNode)node).isImplemented()) {
                        Gui.this.navigateTo(methodNode.getMethodEntry());
                    }
                }
            }
        });
        JPanel inheritancePanel = new JPanel();
        inheritancePanel.setLayout(new BorderLayout());
        inheritancePanel.add(new JScrollPane(this.inheritanceTree));
        this.implementationsTree = new JTree();
        this.implementationsTree.setModel(null);
        this.implementationsTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                if (event.getClickCount() == 2) {
                    TreePath path = Gui.this.implementationsTree.getSelectionPath();
                    if (path == null) {
                        return;
                    }
                    Object node = path.getLastPathComponent();
                    if (node instanceof ClassImplementationsTreeNode) {
                        ClassImplementationsTreeNode classNode = (ClassImplementationsTreeNode)node;
                        Gui.this.navigateTo(classNode.getClassEntry());
                    } else if (node instanceof MethodImplementationsTreeNode) {
                        MethodImplementationsTreeNode methodNode = (MethodImplementationsTreeNode)node;
                        Gui.this.navigateTo(methodNode.getMethodEntry());
                    }
                }
            }
        });
        JPanel implementationsPanel = new JPanel();
        implementationsPanel.setLayout(new BorderLayout());
        implementationsPanel.add(new JScrollPane(this.implementationsTree));
        this.callsTree = new JTree();
        this.callsTree.setModel(null);
        this.callsTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                if (event.getClickCount() == 2) {
                    TreePath path = Gui.this.callsTree.getSelectionPath();
                    if (path == null) {
                        return;
                    }
                    Object node = path.getLastPathComponent();
                    if (node instanceof ReferenceTreeNode) {
                        ReferenceTreeNode referenceNode = (ReferenceTreeNode)node;
                        if (referenceNode.getReference() != null) {
                            Gui.this.navigateTo(referenceNode.getReference());
                        } else {
                            Gui.this.navigateTo((Entry)referenceNode.getEntry());
                        }
                    }
                }
            }
        });
        this.tokens = new JList();
        this.tokens.setCellRenderer(new TokenListCellRenderer(this.controller));
        this.tokens.setSelectionMode(0);
        this.tokens.setLayoutOrientation(0);
        this.tokens.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                Token selected;
                if (event.getClickCount() == 2 && (selected = (Token)Gui.this.tokens.getSelectedValue()) != null) {
                    Gui.this.showToken(selected);
                }
            }
        });
        this.tokens.setPreferredSize(new Dimension(0, 200));
        this.tokens.setMinimumSize(new Dimension(0, 200));
        JSplitPane callPanel = new JSplitPane(0, true, new JScrollPane(this.callsTree), new JScrollPane(this.tokens));
        callPanel.setResizeWeight(1.0);
        callPanel.resetToPreferredSizes();
        JPanel centerPanel = new JPanel();
        centerPanel.setLayout(new BorderLayout());
        centerPanel.add((Component)this.infoPanel, "North");
        centerPanel.add((Component)sourceScroller, "Center");
        this.tabs = new JTabbedPane();
        this.tabs.setPreferredSize(new Dimension(250, 0));
        this.tabs.addTab("Inheritance", inheritancePanel);
        this.tabs.addTab("Implementations", implementationsPanel);
        this.tabs.addTab("Call Graph", callPanel);
        JSplitPane splitRight = new JSplitPane(1, true, centerPanel, this.tabs);
        splitRight.setResizeWeight(1.0);
        splitRight.resetToPreferredSizes();
        JSplitPane splitCenter = new JSplitPane(1, true, this.classesPanel, splitRight);
        splitCenter.setResizeWeight(0.0);
        pane.add((Component)splitCenter, "Center");
        this.menuBar = new MenuBar(this);
        this.frame.setJMenuBar(this.menuBar);
        this.onCloseJar();
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                Gui.this.close();
            }
        });
        pane.doLayout();
        this.frame.setSize(1024, 576);
        this.frame.setMinimumSize(new Dimension(640, 480));
        this.frame.setVisible(true);
        this.frame.setDefaultCloseOperation(0);
    }

    public JFrame getFrame() {
        return this.frame;
    }

    public GuiController getController() {
        return this.controller;
    }

    public void onStartOpenJar() {
        this.classesPanel.removeAll();
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout());
        panel.add(new JLabel("Loading..."));
        this.classesPanel.add(panel);
        this.redraw();
    }

    public void onFinishOpenJar(String jarName) {
        this.frame.setTitle("Enigma - " + jarName);
        this.classesPanel.removeAll();
        this.classesPanel.add(this.splitClasses);
        this.setSource(null);
        this.menuBar.closeJarMenu.setEnabled(true);
        this.menuBar.openTinyMappingsMenu.setEnabled(true);
        this.menuBar.openEnigmaMappingsMenu.setEnabled(true);
        this.menuBar.saveMappingsMenu.setEnabled(false);
        this.menuBar.saveMappingEnigmaFileMenu.setEnabled(true);
        this.menuBar.saveMappingEnigmaDirectoryMenu.setEnabled(true);
        this.menuBar.saveMappingsSrgMenu.setEnabled(true);
        this.menuBar.closeMappingsMenu.setEnabled(true);
        this.menuBar.exportSourceMenu.setEnabled(true);
        this.menuBar.exportJarMenu.setEnabled(true);
        this.redraw();
    }

    public void onCloseJar() {
        this.frame.setTitle("Enigma");
        this.setObfClasses(null);
        this.setDeobfClasses(null);
        this.setSource(null);
        this.classesPanel.removeAll();
        this.menuBar.closeJarMenu.setEnabled(false);
        this.menuBar.openTinyMappingsMenu.setEnabled(false);
        this.menuBar.openEnigmaMappingsMenu.setEnabled(false);
        this.menuBar.saveMappingsMenu.setEnabled(false);
        this.menuBar.saveMappingEnigmaFileMenu.setEnabled(false);
        this.menuBar.saveMappingEnigmaDirectoryMenu.setEnabled(false);
        this.menuBar.saveMappingsSrgMenu.setEnabled(false);
        this.menuBar.closeMappingsMenu.setEnabled(false);
        this.menuBar.exportSourceMenu.setEnabled(false);
        this.menuBar.exportJarMenu.setEnabled(false);
        this.redraw();
    }

    public void setObfClasses(Collection<ClassEntry> obfClasses) {
        this.obfPanel.obfClasses.setClasses(obfClasses);
    }

    public void setDeobfClasses(Collection<ClassEntry> deobfClasses) {
        this.deobfPanel.deobfClasses.setClasses(deobfClasses);
    }

    public void setMappingsFile(File file) {
        this.enigmaMappingsFileChooser.setSelectedFile(file);
        this.menuBar.saveMappingsMenu.setEnabled(file != null);
    }

    public void setSource(String source) {
        this.editor.getHighlighter().removeAllHighlights();
        this.editor.setText(source);
    }

    public void showToken(Token token) {
        if (token == null) {
            throw new IllegalArgumentException("Token cannot be null!");
        }
        CodeReader.navigateToToken(this.editor, token, this.selectionHighlightPainter);
        this.redraw();
    }

    public void showTokens(Collection<Token> tokens) {
        Vector<Token> sortedTokens = new Vector<Token>(tokens);
        Collections.sort(sortedTokens);
        if (sortedTokens.size() > 1) {
            this.tokens.setListData(sortedTokens);
            this.tokens.setSelectedIndex(0);
        } else {
            this.tokens.setListData(new Vector());
        }
        this.showToken(sortedTokens.get(0));
    }

    public void setHighlightedTokens(Iterable<Token> obfuscatedTokens, Iterable<Token> deobfuscatedTokens, Iterable<Token> otherTokens) {
        this.editor.getHighlighter().removeAllHighlights();
        if (obfuscatedTokens != null) {
            this.setHighlightedTokens(obfuscatedTokens, this.obfuscatedHighlightPainter);
        }
        if (deobfuscatedTokens != null) {
            this.setHighlightedTokens(deobfuscatedTokens, this.deobfuscatedHighlightPainter);
        }
        if (otherTokens != null) {
            this.setHighlightedTokens(otherTokens, this.otherHighlightPainter);
        }
        this.redraw();
    }

    private void setHighlightedTokens(Iterable<Token> tokens, Highlighter.HighlightPainter painter) {
        for (Token token : tokens) {
            try {
                this.editor.getHighlighter().addHighlight(token.start, token.end, painter);
            }
            catch (BadLocationException ex) {
                throw new IllegalArgumentException(ex);
            }
        }
    }

    private void showReference(EntryReference<Entry, Entry> reference) {
        if (reference == null) {
            this.infoPanel.clearReference();
            return;
        }
        this.reference = reference;
        this.infoPanel.removeAll();
        if (reference.entry instanceof ClassEntry) {
            this.showClassEntry((ClassEntry)this.reference.entry);
        } else if (this.reference.entry instanceof FieldEntry) {
            this.showFieldEntry((FieldEntry)this.reference.entry);
        } else if (this.reference.entry instanceof MethodEntry) {
            this.showMethodEntry((MethodEntry)this.reference.entry);
        } else if (this.reference.entry instanceof ConstructorEntry) {
            this.showConstructorEntry((ConstructorEntry)this.reference.entry);
        } else if (this.reference.entry instanceof ArgumentEntry) {
            this.showArgumentEntry((ArgumentEntry)this.reference.entry);
        } else if (this.reference.entry instanceof LocalVariableEntry) {
            this.showLocalVariableEntry((LocalVariableEntry)this.reference.entry);
        } else {
            throw new Error("Unknown entry type: " + this.reference.entry.getClass().getName());
        }
        this.redraw();
    }

    private void showLocalVariableEntry(LocalVariableEntry entry) {
        this.addNameValue(this.infoPanel, "Variable", entry.getName());
        this.addNameValue(this.infoPanel, "Class", entry.getClassEntry().getName());
        this.addNameValue(this.infoPanel, "Method", entry.getBehaviorEntry().getName());
        this.addNameValue(this.infoPanel, "Index", Integer.toString(entry.getIndex()));
        this.addNameValue(this.infoPanel, "Type", entry.getType().toString());
    }

    private void showClassEntry(ClassEntry entry) {
        this.addNameValue(this.infoPanel, "Class", entry.getName());
        this.addModifierComboBox(this.infoPanel, "Modifier", entry);
    }

    private void showFieldEntry(FieldEntry entry) {
        this.addNameValue(this.infoPanel, "Field", entry.getName());
        this.addNameValue(this.infoPanel, "Class", entry.getClassEntry().getName());
        this.addNameValue(this.infoPanel, "Type", entry.getType().toString());
        this.addModifierComboBox(this.infoPanel, "Modifier", entry);
    }

    private void showMethodEntry(MethodEntry entry) {
        this.addNameValue(this.infoPanel, "Method", entry.getName());
        this.addNameValue(this.infoPanel, "Class", entry.getClassEntry().getName());
        this.addNameValue(this.infoPanel, "Signature", entry.getSignature().toString());
        this.addModifierComboBox(this.infoPanel, "Modifier", entry);
    }

    private void showConstructorEntry(ConstructorEntry entry) {
        this.addNameValue(this.infoPanel, "Constructor", entry.getClassEntry().getName());
        if (!entry.isStatic()) {
            this.addNameValue(this.infoPanel, "Signature", entry.getSignature().toString());
            this.addModifierComboBox(this.infoPanel, "Modifier", entry);
        }
    }

    private void showArgumentEntry(ArgumentEntry entry) {
        this.addNameValue(this.infoPanel, "Argument", entry.getName());
        this.addNameValue(this.infoPanel, "Class", entry.getClassEntry().getName());
        this.addNameValue(this.infoPanel, "Method", entry.getBehaviorEntry().getName());
        this.addNameValue(this.infoPanel, "Index", Integer.toString(entry.getIndex()));
    }

    private void addNameValue(JPanel container, String name, String value) {
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout(0, 6, 0));
        container.add(panel);
        JLabel label = new JLabel(name + ":", 4);
        label.setPreferredSize(new Dimension(100, label.getPreferredSize().height));
        panel.add(label);
        panel.add(Utils.unboldLabel(new JLabel(value, 2)));
    }

    private JComboBox<Mappings.EntryModifier> addModifierComboBox(JPanel container, String name, Entry entry) {
        if (!this.getController().entryIsInJar(entry)) {
            return null;
        }
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout(0, 6, 0));
        container.add(panel);
        JLabel label = new JLabel(name + ":", 4);
        label.setPreferredSize(new Dimension(100, label.getPreferredSize().height));
        panel.add(label);
        JComboBox<Mappings.EntryModifier> combo = new JComboBox<Mappings.EntryModifier>(Mappings.EntryModifier.values());
        ((JLabel)((Object)combo.getRenderer())).setHorizontalAlignment(2);
        combo.setPreferredSize(new Dimension(100, label.getPreferredSize().height));
        combo.setSelectedIndex(this.getController().getDeobfuscator().getModifier(entry).ordinal());
        combo.addItemListener(this.getController()::modifierChange);
        panel.add(combo);
        return combo;
    }

    public void onCaretMove(int pos) {
        boolean isRenameable;
        Token token = this.controller.getToken(pos);
        boolean isToken = token != null;
        this.reference = this.controller.getDeobfReference(token);
        boolean isClassEntry = isToken && this.reference.entry instanceof ClassEntry;
        boolean isFieldEntry = isToken && this.reference.entry instanceof FieldEntry;
        boolean isMethodEntry = isToken && this.reference.entry instanceof MethodEntry;
        boolean isConstructorEntry = isToken && this.reference.entry instanceof ConstructorEntry;
        boolean isInJar = isToken && this.controller.entryIsInJar((Entry)this.reference.entry);
        boolean bl = isRenameable = isToken && this.controller.referenceIsRenameable(this.reference);
        if (isToken) {
            this.showReference(this.reference);
        } else {
            this.infoPanel.clearReference();
        }
        this.popupMenu.renameMenu.setEnabled(isRenameable);
        this.popupMenu.showInheritanceMenu.setEnabled(isClassEntry || isMethodEntry || isConstructorEntry);
        this.popupMenu.showImplementationsMenu.setEnabled(isClassEntry || isMethodEntry);
        this.popupMenu.showCallsMenu.setEnabled(isClassEntry || isFieldEntry || isMethodEntry || isConstructorEntry);
        this.popupMenu.openEntryMenu.setEnabled(isInJar && (isClassEntry || isFieldEntry || isMethodEntry || isConstructorEntry));
        this.popupMenu.openPreviousMenu.setEnabled(this.controller.hasPreviousLocation());
        this.popupMenu.toggleMappingMenu.setEnabled(isRenameable);
        if (isToken && this.controller.entryHasDeobfuscatedName((Entry)this.reference.entry)) {
            this.popupMenu.toggleMappingMenu.setText("Reset to obfuscated");
        } else {
            this.popupMenu.toggleMappingMenu.setText("Mark as deobfuscated");
        }
    }

    public void navigateTo(Entry entry) {
        if (!this.controller.entryIsInJar(entry)) {
            return;
        }
        if (this.reference != null) {
            this.controller.savePreviousReference(this.reference);
        }
        this.controller.openDeclaration(entry);
    }

    private void navigateTo(EntryReference<Entry, Entry> reference) {
        if (!this.controller.entryIsInJar(reference.getLocationClassEntry())) {
            return;
        }
        if (this.reference != null) {
            this.controller.savePreviousReference(this.reference);
        }
        this.controller.openReference(reference);
    }

    public void startRename() {
        final JTextField text = new JTextField();
        text.setText(this.reference.getNamableName());
        text.setPreferredSize(new Dimension(360, text.getPreferredSize().height));
        text.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent event) {
                switch (event.getKeyCode()) {
                    case 10: {
                        Gui.this.finishRename(text, true);
                        break;
                    }
                    case 27: {
                        Gui.this.finishRename(text, false);
                        break;
                    }
                }
            }
        });
        JPanel panel = (JPanel)this.infoPanel.getComponent(0);
        panel.remove(panel.getComponentCount() - 1);
        panel.add(text);
        text.grabFocus();
        int offset = text.getText().lastIndexOf(47) + 1;
        if (this.reference.getNameableEntry() instanceof ClassEntry && text.getText().contains("/") && offset != 0) {
            text.select(offset, text.getText().length());
        } else {
            text.selectAll();
        }
        this.redraw();
    }

    private void finishRename(JTextField text, boolean saveName) {
        String newName = text.getText();
        if (saveName && newName != null && !newName.isEmpty()) {
            try {
                this.controller.rename(this.reference, newName);
            }
            catch (IllegalNameException ex) {
                text.setBorder(BorderFactory.createLineBorder(Color.red, 1));
                text.setToolTipText(ex.getReason());
                Utils.showToolTipNow(text);
            }
            return;
        }
        JPanel panel = (JPanel)this.infoPanel.getComponent(0);
        panel.remove(panel.getComponentCount() - 1);
        panel.add(Utils.unboldLabel(new JLabel(this.reference.getNamableName(), 2)));
        this.editor.grabFocus();
        this.redraw();
    }

    public void showInheritance() {
        if (this.reference == null) {
            return;
        }
        this.inheritanceTree.setModel(null);
        if (this.reference.entry instanceof ClassEntry) {
            ClassInheritanceTreeNode classNode = this.controller.getClassInheritance((ClassEntry)this.reference.entry);
            TreePath path = this.getPathToRoot(classNode);
            this.inheritanceTree.setModel(new DefaultTreeModel((TreeNode)path.getPathComponent(0)));
            this.inheritanceTree.expandPath(path);
            this.inheritanceTree.setSelectionRow(this.inheritanceTree.getRowForPath(path));
        } else if (this.reference.entry instanceof MethodEntry) {
            MethodInheritanceTreeNode classNode = this.controller.getMethodInheritance((MethodEntry)this.reference.entry);
            TreePath path = this.getPathToRoot(classNode);
            this.inheritanceTree.setModel(new DefaultTreeModel((TreeNode)path.getPathComponent(0)));
            this.inheritanceTree.expandPath(path);
            this.inheritanceTree.setSelectionRow(this.inheritanceTree.getRowForPath(path));
        }
        this.tabs.setSelectedIndex(0);
        this.redraw();
    }

    public void showImplementations() {
        if (this.reference == null) {
            return;
        }
        this.implementationsTree.setModel(null);
        DefaultMutableTreeNode node = null;
        if (this.reference.entry instanceof ClassEntry) {
            node = this.controller.getClassImplementations((ClassEntry)this.reference.entry);
        } else if (this.reference.entry instanceof MethodEntry) {
            node = this.controller.getMethodImplementations((MethodEntry)this.reference.entry);
        }
        if (node != null) {
            TreePath path = this.getPathToRoot(node);
            this.implementationsTree.setModel(new DefaultTreeModel((TreeNode)path.getPathComponent(0)));
            this.implementationsTree.expandPath(path);
            this.implementationsTree.setSelectionRow(this.implementationsTree.getRowForPath(path));
        }
        this.tabs.setSelectedIndex(1);
        this.redraw();
    }

    public void showCalls() {
        if (this.reference == null) {
            return;
        }
        if (this.reference.entry instanceof ClassEntry) {
            BehaviorReferenceTreeNode node = this.controller.getMethodReferences(new ConstructorEntry((ClassEntry)this.reference.entry, new Signature("()V")));
            this.callsTree.setModel(new DefaultTreeModel(node));
        } else if (this.reference.entry instanceof FieldEntry) {
            FieldReferenceTreeNode node = this.controller.getFieldReferences((FieldEntry)this.reference.entry);
            this.callsTree.setModel(new DefaultTreeModel(node));
        } else if (this.reference.entry instanceof MethodEntry) {
            BehaviorReferenceTreeNode node = this.controller.getMethodReferences((MethodEntry)this.reference.entry);
            this.callsTree.setModel(new DefaultTreeModel(node));
        } else if (this.reference.entry instanceof ConstructorEntry) {
            BehaviorReferenceTreeNode node = this.controller.getMethodReferences((ConstructorEntry)this.reference.entry);
            this.callsTree.setModel(new DefaultTreeModel(node));
        }
        this.tabs.setSelectedIndex(2);
        this.redraw();
    }

    public void toggleMapping() {
        if (this.controller.entryHasDeobfuscatedName((Entry)this.reference.entry)) {
            this.controller.removeMapping(this.reference);
        } else {
            this.controller.markAsDeobfuscated(this.reference);
        }
    }

    private TreePath getPathToRoot(TreeNode node) {
        ArrayList<TreeNode> nodes = Lists.newArrayList();
        TreeNode n = node;
        do {
            nodes.add(n);
        } while ((n = n.getParent()) != null);
        Collections.reverse(nodes);
        return new TreePath(nodes.toArray());
    }

    public void showDiscardDiag(Function<Integer, Void> callback, String ... options) {
        int response = JOptionPane.showOptionDialog(this.frame, "Your mappings have not been saved yet. Do you want to save?", "Save your changes?", 1, 3, null, options, options[2]);
        callback.apply(response);
    }

    public void saveMapping() throws IOException {
        if (this.enigmaMappingsFileChooser.getSelectedFile() != null || this.enigmaMappingsFileChooser.showSaveDialog(this.frame) == 0) {
            this.controller.saveMappings(this.enigmaMappingsFileChooser.getSelectedFile());
        }
    }

    public void close() {
        if (!this.controller.isDirty()) {
            this.frame.dispose();
            System.exit(0);
        } else {
            this.showDiscardDiag(response -> {
                if (response == 0) {
                    try {
                        this.saveMapping();
                        this.frame.dispose();
                    }
                    catch (IOException ex) {
                        throw new Error(ex);
                    }
                } else if (response == 1) {
                    this.frame.dispose();
                }
                return null;
            }, "Save and exit", "Discard changes", "Cancel");
        }
    }

    public void redraw() {
        this.frame.validate();
        this.frame.repaint();
    }

    public void onPanelRename(Object prevData, Object data, DefaultMutableTreeNode node) throws IllegalNameException {
        if (data instanceof String) {
            for (int i = 0; i < node.getChildCount(); ++i) {
                data = Descriptor.toJvmName((String)data);
                DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)node.getChildAt(i);
                ClassEntry prevDataChild = (ClassEntry)childNode.getUserObject();
                ClassEntry dataChild = new ClassEntry(data + "/" + prevDataChild.getSimpleName());
                this.controller.rename(new EntryReference<Entry, Entry>(prevDataChild, prevDataChild.getName()), dataChild.getName(), false, i + 1 == node.getChildCount());
                childNode.setUserObject(dataChild);
            }
            node.setUserObject(data);
            this.deobfPanel.deobfClasses.reload();
        } else if (data instanceof ClassEntry) {
            this.controller.rename(new EntryReference<Entry, Entry>((ClassEntry)prevData, ((ClassEntry)prevData).getName()), ((ClassEntry)data).getName(), false, true);
        }
    }

    public void moveClassTree(EntryReference<Entry, Entry> deobfReference, String newName) {
        String oldEntry = deobfReference.entry.getClassEntry().getPackageName();
        String newEntry = new ClassEntry(Descriptor.toJvmName(newName)).getPackageName();
        this.moveClassTree(deobfReference, newName, oldEntry == null, newEntry == null);
    }

    public void moveClassTree(EntryReference<Entry, Entry> deobfReference, String newName, boolean isOldOb, boolean isNewOb) {
        ClassEntry oldEntry = deobfReference.entry.getClassEntry();
        ClassEntry newEntry = new ClassEntry(Descriptor.toJvmName(newName));
        if (isOldOb && !isNewOb) {
            this.deobfPanel.deobfClasses.moveClassTree(oldEntry, newEntry, this.obfPanel.obfClasses);
            ClassSelectorPackageNode packageNode = this.obfPanel.obfClasses.getPackageNode(oldEntry);
            this.obfPanel.obfClasses.removeNode(packageNode, oldEntry);
            this.obfPanel.obfClasses.removeNodeIfEmpty(packageNode);
            this.deobfPanel.deobfClasses.reload();
            this.obfPanel.obfClasses.reload();
        } else if (isNewOb && !isOldOb) {
            this.obfPanel.obfClasses.moveClassTree(oldEntry, newEntry, this.deobfPanel.deobfClasses);
            ClassSelectorPackageNode packageNode = this.deobfPanel.deobfClasses.getPackageNode(oldEntry);
            this.deobfPanel.deobfClasses.removeNode(packageNode, oldEntry);
            this.deobfPanel.deobfClasses.removeNodeIfEmpty(packageNode);
            this.deobfPanel.deobfClasses.reload();
            this.obfPanel.obfClasses.reload();
        } else if (isOldOb) {
            this.obfPanel.obfClasses.moveClassTree(oldEntry, newEntry, null);
            this.obfPanel.obfClasses.removeNodeIfEmpty(this.obfPanel.obfClasses.getPackageNode(oldEntry));
            this.obfPanel.obfClasses.reload();
        } else {
            this.deobfPanel.deobfClasses.moveClassTree(oldEntry, newEntry, null);
            this.deobfPanel.deobfClasses.removeNodeIfEmpty(this.deobfPanel.deobfClasses.getPackageNode(oldEntry));
            this.deobfPanel.deobfClasses.reload();
        }
    }
}

