/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.gui;

import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.strobel.decompiler.languages.java.ast.CompilationUnit;
import cuchaz.enigma.Deobfuscator;
import cuchaz.enigma.analysis.BehaviorReferenceTreeNode;
import cuchaz.enigma.analysis.ClassImplementationsTreeNode;
import cuchaz.enigma.analysis.ClassInheritanceTreeNode;
import cuchaz.enigma.analysis.EntryReference;
import cuchaz.enigma.analysis.FieldReferenceTreeNode;
import cuchaz.enigma.analysis.MethodImplementationsTreeNode;
import cuchaz.enigma.analysis.MethodInheritanceTreeNode;
import cuchaz.enigma.analysis.SourceIndex;
import cuchaz.enigma.analysis.Token;
import cuchaz.enigma.gui.Gui;
import cuchaz.enigma.gui.dialog.ProgressDialog;
import cuchaz.enigma.mapping.BehaviorEntry;
import cuchaz.enigma.mapping.ClassEntry;
import cuchaz.enigma.mapping.Entry;
import cuchaz.enigma.mapping.FieldEntry;
import cuchaz.enigma.mapping.Mappings;
import cuchaz.enigma.mapping.MappingsEnigmaReader;
import cuchaz.enigma.mapping.MappingsTinyReader;
import cuchaz.enigma.mapping.MethodEntry;
import cuchaz.enigma.mapping.TranslationDirection;
import cuchaz.enigma.throwables.MappingParseException;
import cuchaz.enigma.utils.ReadableToken;
import java.awt.event.ItemEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.jar.JarFile;

public class GuiController {
    private Deobfuscator deobfuscator;
    private Gui gui;
    private SourceIndex index;
    private ClassEntry currentObfClass;
    private boolean isDirty;
    private Deque<EntryReference<Entry, Entry>> referenceStack;

    public GuiController(Gui gui) {
        this.gui = gui;
        this.deobfuscator = null;
        this.index = null;
        this.currentObfClass = null;
        this.isDirty = false;
        this.referenceStack = Queues.newArrayDeque();
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public void openJar(JarFile jar) {
        this.gui.onStartOpenJar();
        this.deobfuscator = new Deobfuscator(jar);
        this.gui.onFinishOpenJar(this.deobfuscator.getJarName());
        this.refreshClasses();
    }

    public void closeJar() {
        this.deobfuscator = null;
        this.gui.onCloseJar();
    }

    public void openEnigmaMappings(File file) throws IOException, MappingParseException {
        this.deobfuscator.setMappings(new MappingsEnigmaReader().read(file));
        this.isDirty = false;
        this.gui.setMappingsFile(file);
        this.refreshClasses();
        this.refreshCurrentClass();
    }

    public void openTinyMappings(File file) throws IOException, MappingParseException {
        this.deobfuscator.setMappings(new MappingsTinyReader().read(file));
        this.isDirty = false;
        this.gui.setMappingsFile(file);
        this.refreshClasses();
        this.refreshCurrentClass();
    }

    public void saveMappings(File file) throws IOException {
        Mappings mappings = this.deobfuscator.getMappings();
        switch (mappings.getOriginMappingFormat()) {
            case SRG_FILE: {
                this.saveSRGMappings(file);
                break;
            }
            default: {
                this.saveEnigmaMappings(file, Mappings.FormatType.ENIGMA_FILE != mappings.getOriginMappingFormat());
            }
        }
    }

    public void saveEnigmaMappings(File file, boolean isDirectoryFormat) throws IOException {
        this.deobfuscator.getMappings().saveEnigmaMappings(file, isDirectoryFormat);
        this.isDirty = false;
    }

    public void saveSRGMappings(File file) throws IOException {
        this.deobfuscator.getMappings().saveSRGMappings(file);
        this.isDirty = false;
    }

    public void closeMappings() {
        this.deobfuscator.setMappings(null);
        this.gui.setMappingsFile(null);
        this.refreshClasses();
        this.refreshCurrentClass();
    }

    public void rebuildMethodNames() {
        ProgressDialog.runInThread(this.gui.getFrame(), progress -> this.deobfuscator.rebuildMethodNames(progress));
        this.isDirty = true;
    }

    public void exportSource(File dirOut) {
        ProgressDialog.runInThread(this.gui.getFrame(), progress -> this.deobfuscator.writeSources(dirOut, progress));
    }

    public void exportJar(File fileOut) {
        ProgressDialog.runInThread(this.gui.getFrame(), progress -> this.deobfuscator.writeJar(fileOut, progress));
    }

    public Token getToken(int pos) {
        if (this.index == null) {
            return null;
        }
        return this.index.getReferenceToken(pos);
    }

    public EntryReference<Entry, Entry> getDeobfReference(Token token) {
        if (this.index == null) {
            return null;
        }
        return this.index.getDeobfReference(token);
    }

    public ReadableToken getReadableToken(Token token) {
        if (this.index == null) {
            return null;
        }
        return new ReadableToken(this.index.getLineNumber(token.start), this.index.getColumnNumber(token.start), this.index.getColumnNumber(token.end));
    }

    public boolean entryHasDeobfuscatedName(Entry deobfEntry) {
        return this.deobfuscator.hasDeobfuscatedName(this.deobfuscator.obfuscateEntry(deobfEntry));
    }

    public boolean entryIsInJar(Entry deobfEntry) {
        return this.deobfuscator.isObfuscatedIdentifier(this.deobfuscator.obfuscateEntry(deobfEntry));
    }

    public boolean referenceIsRenameable(EntryReference<Entry, Entry> deobfReference) {
        return this.deobfuscator.isRenameable(this.deobfuscator.obfuscateReference(deobfReference), true);
    }

    public ClassInheritanceTreeNode getClassInheritance(ClassEntry deobfClassEntry) {
        ClassEntry obfClassEntry = this.deobfuscator.obfuscateEntry(deobfClassEntry);
        ClassInheritanceTreeNode rootNode = this.deobfuscator.getJarIndex().getClassInheritance(this.deobfuscator.getTranslator(TranslationDirection.Deobfuscating), obfClassEntry);
        return ClassInheritanceTreeNode.findNode(rootNode, obfClassEntry);
    }

    public ClassImplementationsTreeNode getClassImplementations(ClassEntry deobfClassEntry) {
        ClassEntry obfClassEntry = this.deobfuscator.obfuscateEntry(deobfClassEntry);
        return this.deobfuscator.getJarIndex().getClassImplementations(this.deobfuscator.getTranslator(TranslationDirection.Deobfuscating), obfClassEntry);
    }

    public MethodInheritanceTreeNode getMethodInheritance(MethodEntry deobfMethodEntry) {
        MethodEntry obfMethodEntry = this.deobfuscator.obfuscateEntry(deobfMethodEntry);
        MethodInheritanceTreeNode rootNode = this.deobfuscator.getJarIndex().getMethodInheritance(this.deobfuscator.getTranslator(TranslationDirection.Deobfuscating), obfMethodEntry);
        return MethodInheritanceTreeNode.findNode(rootNode, obfMethodEntry);
    }

    public MethodImplementationsTreeNode getMethodImplementations(MethodEntry deobfMethodEntry) {
        MethodEntry obfMethodEntry = this.deobfuscator.obfuscateEntry(deobfMethodEntry);
        List<MethodImplementationsTreeNode> rootNodes = this.deobfuscator.getJarIndex().getMethodImplementations(this.deobfuscator.getTranslator(TranslationDirection.Deobfuscating), obfMethodEntry);
        if (rootNodes.isEmpty()) {
            return null;
        }
        if (rootNodes.size() > 1) {
            System.err.println("WARNING: Method " + deobfMethodEntry + " implements multiple interfaces. Only showing first one.");
        }
        return MethodImplementationsTreeNode.findNode(rootNodes.get(0), obfMethodEntry);
    }

    public FieldReferenceTreeNode getFieldReferences(FieldEntry deobfFieldEntry) {
        FieldEntry obfFieldEntry = this.deobfuscator.obfuscateEntry(deobfFieldEntry);
        FieldReferenceTreeNode rootNode = new FieldReferenceTreeNode(this.deobfuscator.getTranslator(TranslationDirection.Deobfuscating), obfFieldEntry);
        rootNode.load(this.deobfuscator.getJarIndex(), true);
        return rootNode;
    }

    public BehaviorReferenceTreeNode getMethodReferences(BehaviorEntry deobfBehaviorEntry) {
        BehaviorEntry obfBehaviorEntry = this.deobfuscator.obfuscateEntry(deobfBehaviorEntry);
        BehaviorReferenceTreeNode rootNode = new BehaviorReferenceTreeNode(this.deobfuscator.getTranslator(TranslationDirection.Deobfuscating), obfBehaviorEntry);
        rootNode.load(this.deobfuscator.getJarIndex(), true);
        return rootNode;
    }

    public void rename(EntryReference<Entry, Entry> deobfReference, String newName) {
        this.rename(deobfReference, newName, true, true);
    }

    public void rename(EntryReference<Entry, Entry> deobfReference, String newName, boolean refreshClassTree, boolean clearTranslationCache) {
        EntryReference<Entry, Entry> obfReference = this.deobfuscator.obfuscateReference(deobfReference);
        this.deobfuscator.rename(obfReference.getNameableEntry(), newName, clearTranslationCache);
        this.isDirty = true;
        if (refreshClassTree && deobfReference.entry instanceof ClassEntry && !((ClassEntry)deobfReference.entry).isInnerClass()) {
            this.gui.moveClassTree(deobfReference, newName);
        }
        this.refreshCurrentClass(obfReference);
    }

    public void removeMapping(EntryReference<Entry, Entry> deobfReference) {
        EntryReference<Entry, Entry> obfReference = this.deobfuscator.obfuscateReference(deobfReference);
        this.deobfuscator.removeMapping(obfReference.getNameableEntry());
        this.isDirty = true;
        if (deobfReference.entry instanceof ClassEntry) {
            this.gui.moveClassTree(deobfReference, obfReference.entry.getName(), false, true);
        }
        this.refreshCurrentClass(obfReference);
    }

    public void markAsDeobfuscated(EntryReference<Entry, Entry> deobfReference) {
        EntryReference<Entry, Entry> obfReference = this.deobfuscator.obfuscateReference(deobfReference);
        this.deobfuscator.markAsDeobfuscated(obfReference.getNameableEntry());
        this.isDirty = true;
        if (deobfReference.entry instanceof ClassEntry && !((ClassEntry)deobfReference.entry).isInnerClass()) {
            this.gui.moveClassTree(deobfReference, obfReference.entry.getName(), true, false);
        }
        this.refreshCurrentClass(obfReference);
    }

    public void openDeclaration(Entry deobfEntry) {
        if (deobfEntry == null) {
            throw new IllegalArgumentException("Entry cannot be null!");
        }
        this.openReference(new EntryReference<Entry, Entry>(deobfEntry, deobfEntry.getName()));
    }

    public void openReference(EntryReference<Entry, Entry> deobfReference) {
        if (deobfReference == null) {
            throw new IllegalArgumentException("Reference cannot be null!");
        }
        EntryReference<Entry, Entry> obfReference = this.deobfuscator.obfuscateReference(deobfReference);
        ClassEntry obfClassEntry = obfReference.getLocationClassEntry().getOutermostClassEntry();
        if (!this.deobfuscator.isObfuscatedIdentifier(obfClassEntry)) {
            throw new IllegalArgumentException("Obfuscated class " + obfClassEntry + " was not found in the jar!");
        }
        if (this.currentObfClass == null || !this.currentObfClass.equals(obfClassEntry)) {
            this.currentObfClass = obfClassEntry;
            this.deobfuscate(this.currentObfClass, obfReference);
        } else {
            this.showReference(obfReference);
        }
    }

    private void showReference(EntryReference<Entry, Entry> obfReference) {
        EntryReference<Entry, Entry> deobfReference = this.deobfuscator.deobfuscateReference(obfReference);
        Collection<Token> tokens = this.index.getReferenceTokens(deobfReference);
        if (tokens.isEmpty()) {
            System.err.println(String.format("WARNING: no tokens found for %s in %s", deobfReference, this.currentObfClass));
        } else {
            this.gui.showTokens(tokens);
        }
    }

    public void savePreviousReference(EntryReference<Entry, Entry> deobfReference) {
        this.referenceStack.push(this.deobfuscator.obfuscateReference(deobfReference));
    }

    public void openPreviousReference() {
        if (this.hasPreviousLocation()) {
            this.openReference(this.deobfuscator.deobfuscateReference(this.referenceStack.pop()));
        }
    }

    public boolean hasPreviousLocation() {
        return !this.referenceStack.isEmpty();
    }

    private void refreshClasses() {
        ArrayList<ClassEntry> obfClasses = Lists.newArrayList();
        ArrayList<ClassEntry> deobfClasses = Lists.newArrayList();
        this.deobfuscator.getSeparatedClasses(obfClasses, deobfClasses);
        this.gui.setObfClasses(obfClasses);
        this.gui.setDeobfClasses(deobfClasses);
    }

    public void refreshCurrentClass() {
        this.refreshCurrentClass(null);
    }

    private void refreshCurrentClass(EntryReference<Entry, Entry> obfReference) {
        if (this.currentObfClass != null) {
            this.deobfuscate(this.currentObfClass, obfReference);
        }
    }

    private void deobfuscate(ClassEntry classEntry, EntryReference<Entry, Entry> obfReference) {
        this.gui.setSource("(deobfuscating...)");
        new Thread(() -> {
            CompilationUnit sourceTree = this.deobfuscator.getSourceTree(classEntry.getClassName());
            if (sourceTree == null) {
                this.gui.setSource("Unable to find class: " + classEntry);
                return;
            }
            String source = this.deobfuscator.getSource(sourceTree);
            this.index = this.deobfuscator.getSourceIndex(sourceTree, source);
            this.gui.setSource(this.index.getSource());
            if (obfReference != null) {
                this.showReference(obfReference);
            }
            ArrayList<Token> obfuscatedTokens = Lists.newArrayList();
            ArrayList<Token> deobfuscatedTokens = Lists.newArrayList();
            ArrayList<Token> otherTokens = Lists.newArrayList();
            for (Token token : this.index.referenceTokens()) {
                EntryReference<Entry, Entry> reference = this.index.getDeobfReference(token);
                if (this.referenceIsRenameable(reference)) {
                    if (this.entryHasDeobfuscatedName(reference.getNameableEntry())) {
                        deobfuscatedTokens.add(token);
                        continue;
                    }
                    obfuscatedTokens.add(token);
                    continue;
                }
                otherTokens.add(token);
            }
            this.gui.setHighlightedTokens(obfuscatedTokens, deobfuscatedTokens, otherTokens);
        }).start();
    }

    public Deobfuscator getDeobfuscator() {
        return this.deobfuscator;
    }

    public void modifierChange(ItemEvent event) {
        if (event.getStateChange() == 1) {
            this.deobfuscator.changeModifier((Entry)this.gui.reference.entry, (Mappings.EntryModifier)((Object)event.getItem()));
            this.isDirty = true;
            this.refreshCurrentClass();
        }
    }
}

