/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.gui;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import cuchaz.enigma.Deobfuscator;
import cuchaz.enigma.analysis.SourceIndex;
import cuchaz.enigma.analysis.Token;
import cuchaz.enigma.convert.ClassMatches;
import cuchaz.enigma.convert.MemberMatches;
import cuchaz.enigma.gui.ClassSelector;
import cuchaz.enigma.gui.CodeReader;
import cuchaz.enigma.gui.GuiTricks;
import cuchaz.enigma.gui.highlight.DeobfuscatedHighlightPainter;
import cuchaz.enigma.gui.highlight.ObfuscatedHighlightPainter;
import cuchaz.enigma.mapping.ClassEntry;
import cuchaz.enigma.mapping.Entry;
import de.sciss.syntaxpane.DefaultSyntaxKit;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.text.Highlighter;

public class MemberMatchingGui<T extends Entry> {
    private JFrame frame;
    private Map<SourceType, JRadioButton> sourceTypeButtons;
    private ClassSelector sourceClasses;
    private CodeReader sourceReader;
    private CodeReader destReader;
    private JButton matchButton;
    private JButton unmatchableButton;
    private JLabel sourceLabel;
    private JLabel destLabel;
    private Highlighter.HighlightPainter unmatchedHighlightPainter;
    private Highlighter.HighlightPainter matchedHighlightPainter;
    private ClassMatches classMatches;
    private MemberMatches<T> memberMatches;
    private Deobfuscator sourceDeobfuscator;
    private Deobfuscator destDeobfuscator;
    private SaveListener<T> saveListener;
    private SourceType sourceType;
    private ClassEntry obfSourceClass;
    private ClassEntry obfDestClass;
    private T obfSourceEntry;
    private T obfDestEntry;

    public MemberMatchingGui(ClassMatches classMatches, MemberMatches<T> fieldMatches, Deobfuscator sourceDeobfuscator, Deobfuscator destDeobfuscator) {
        this.classMatches = classMatches;
        this.memberMatches = fieldMatches;
        this.sourceDeobfuscator = sourceDeobfuscator;
        this.destDeobfuscator = destDeobfuscator;
        this.frame = new JFrame("Enigma - Member Matcher");
        Container pane = this.frame.getContentPane();
        pane.setLayout(new BorderLayout());
        JPanel classesPanel = new JPanel();
        classesPanel.setLayout(new BoxLayout(classesPanel, 3));
        classesPanel.setPreferredSize(new Dimension(200, 0));
        pane.add((Component)classesPanel, "West");
        classesPanel.add(new JLabel("Classes"));
        JPanel sourceTypePanel = new JPanel();
        classesPanel.add(sourceTypePanel);
        sourceTypePanel.setLayout(new BoxLayout(sourceTypePanel, 3));
        ActionListener sourceTypeListener = event -> this.setSourceType(SourceType.valueOf(event.getActionCommand()));
        ButtonGroup sourceTypeButtons = new ButtonGroup();
        this.sourceTypeButtons = Maps.newHashMap();
        for (SourceType sourceType : SourceType.values()) {
            JRadioButton button = sourceType.newRadio(sourceTypeListener, sourceTypeButtons);
            this.sourceTypeButtons.put(sourceType, button);
            sourceTypePanel.add(button);
        }
        this.sourceClasses = new ClassSelector(null, ClassSelector.DEOBF_CLASS_COMPARATOR, false);
        this.sourceClasses.setSelectionListener(this::setSourceClass);
        JScrollPane sourceScroller = new JScrollPane(this.sourceClasses);
        classesPanel.add(sourceScroller);
        DefaultSyntaxKit.initKit();
        this.sourceReader = new CodeReader();
        this.sourceReader.setSelectionListener(reference -> {
            if (reference != null) {
                this.onSelectSource((Entry)reference.entry);
            } else {
                this.onSelectSource(null);
            }
        });
        this.destReader = new CodeReader();
        this.destReader.setSelectionListener(reference -> {
            if (reference != null) {
                this.onSelectDest((Entry)reference.entry);
            } else {
                this.onSelectDest(null);
            }
        });
        KeyAdapter keyListener = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent event) {
                if (event.getKeyCode() == 77) {
                    MemberMatchingGui.this.matchButton.doClick();
                }
            }
        };
        this.sourceReader.addKeyListener(keyListener);
        this.destReader.addKeyListener(keyListener);
        JSplitPane splitRight = new JSplitPane(1, true, new JScrollPane(this.sourceReader), new JScrollPane(this.destReader));
        splitRight.setResizeWeight(0.5);
        JSplitPane splitLeft = new JSplitPane(1, true, classesPanel, splitRight);
        splitLeft.setResizeWeight(0.0);
        pane.add((Component)splitLeft, "Center");
        splitLeft.resetToPreferredSizes();
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new FlowLayout());
        pane.add((Component)bottomPanel, "South");
        this.matchButton = new JButton();
        this.unmatchableButton = new JButton();
        this.sourceLabel = new JLabel();
        bottomPanel.add(this.sourceLabel);
        bottomPanel.add(this.matchButton);
        bottomPanel.add(this.unmatchableButton);
        this.destLabel = new JLabel();
        bottomPanel.add(this.destLabel);
        pane.doLayout();
        this.frame.setSize(1024, 576);
        this.frame.setMinimumSize(new Dimension(640, 480));
        this.frame.setVisible(true);
        this.frame.setDefaultCloseOperation(2);
        this.unmatchedHighlightPainter = new ObfuscatedHighlightPainter();
        this.matchedHighlightPainter = new DeobfuscatedHighlightPainter();
        this.saveListener = null;
        this.obfSourceClass = null;
        this.obfDestClass = null;
        this.obfSourceEntry = null;
        this.obfDestEntry = null;
        this.setSourceType(SourceType.getDefault());
        this.updateButtons();
    }

    protected void setSourceType(SourceType val) {
        this.sourceType = val;
        this.updateSourceClasses();
    }

    public void setSaveListener(SaveListener<T> val) {
        this.saveListener = val;
    }

    private void updateSourceClasses() {
        String selectedPackage = this.sourceClasses.getSelectedPackage();
        ArrayList<ClassEntry> deobfClassEntries = Lists.newArrayList();
        for (ClassEntry entry : this.sourceType.getObfSourceClasses(this.memberMatches)) {
            deobfClassEntries.add(this.sourceDeobfuscator.deobfuscateEntry(entry));
        }
        this.sourceClasses.setClasses(deobfClassEntries);
        if (selectedPackage != null) {
            this.sourceClasses.expandPackage(selectedPackage);
        }
        for (SourceType sourceType : SourceType.values()) {
            this.sourceTypeButtons.get((Object)sourceType).setText(String.format("%s (%d)", sourceType.name(), sourceType.getObfSourceClasses(this.memberMatches).size()));
        }
    }

    protected void setSourceClass(ClassEntry sourceClass) {
        this.obfSourceClass = this.sourceDeobfuscator.obfuscateEntry(sourceClass);
        this.obfDestClass = (ClassEntry)this.classMatches.getUniqueMatches().get(this.obfSourceClass);
        if (this.obfDestClass == null) {
            throw new Error("No matching dest class for source class: " + this.obfSourceClass);
        }
        this.sourceReader.decompileClass(this.obfSourceClass, this.sourceDeobfuscator, false, this::updateSourceHighlights);
        this.destReader.decompileClass(this.obfDestClass, this.destDeobfuscator, false, this::updateDestHighlights);
    }

    protected void updateSourceHighlights() {
        this.highlightEntries(this.sourceReader, this.sourceDeobfuscator, this.memberMatches.matches().keySet(), this.memberMatches.getUnmatchedSourceEntries());
    }

    protected void updateDestHighlights() {
        this.highlightEntries(this.destReader, this.destDeobfuscator, this.memberMatches.matches().values(), this.memberMatches.getUnmatchedDestEntries());
    }

    private void highlightEntries(CodeReader reader, Deobfuscator deobfuscator, Collection<T> obfMatchedEntries, Collection<T> obfUnmatchedEntries) {
        reader.clearHighlights();
        this.updateHighlighted(obfMatchedEntries, deobfuscator, reader, this.matchedHighlightPainter);
        this.updateHighlighted(obfUnmatchedEntries, deobfuscator, reader, this.unmatchedHighlightPainter);
    }

    private void updateHighlighted(Collection<T> entries, Deobfuscator deobfuscator, CodeReader reader, Highlighter.HighlightPainter painter) {
        SourceIndex index = reader.getSourceIndex();
        for (Entry obfT : entries) {
            Entry deobfT = deobfuscator.deobfuscateEntry(obfT);
            Token token = index.getDeclarationToken(deobfT);
            if (token == null) continue;
            reader.setHighlightedToken(token, painter);
        }
    }

    private boolean isSelectionMatched() {
        return this.obfSourceEntry != null && this.obfDestEntry != null && this.memberMatches.isMatched(this.obfSourceEntry, this.obfDestEntry);
    }

    protected void onSelectSource(Entry source) {
        Entry sourceEntry;
        Entry obfSourceEntry;
        if (this.isSelectionMatched()) {
            this.setDest(null);
        }
        this.setSource(null);
        if (source != null && this.memberMatches.hasSource(obfSourceEntry = this.sourceDeobfuscator.obfuscateEntry(sourceEntry = source))) {
            this.setSource(obfSourceEntry);
            Entry obfDestEntry = (Entry)this.memberMatches.matches().get(obfSourceEntry);
            if (obfDestEntry != null) {
                this.setDest(obfDestEntry);
            }
        }
        this.updateButtons();
    }

    protected void onSelectDest(Entry dest) {
        Entry destEntry;
        Entry obfDestEntry;
        if (this.isSelectionMatched()) {
            this.setSource(null);
        }
        this.setDest(null);
        if (dest != null && this.memberMatches.hasDest(obfDestEntry = this.destDeobfuscator.obfuscateEntry(destEntry = dest))) {
            this.setDest(obfDestEntry);
            Entry obfSourceEntry = (Entry)this.memberMatches.matches().inverse().get(obfDestEntry);
            if (obfSourceEntry != null) {
                this.setSource(obfSourceEntry);
            }
        }
        this.updateButtons();
    }

    private void setSource(T obfEntry) {
        if (obfEntry == null) {
            this.obfSourceEntry = null;
            this.sourceLabel.setText("");
        } else {
            this.obfSourceEntry = obfEntry;
            this.sourceLabel.setText(this.getEntryLabel(obfEntry, this.sourceDeobfuscator));
        }
    }

    private void setDest(T obfEntry) {
        if (obfEntry == null) {
            this.obfDestEntry = null;
            this.destLabel.setText("");
        } else {
            this.obfDestEntry = obfEntry;
            this.destLabel.setText(this.getEntryLabel(obfEntry, this.destDeobfuscator));
        }
    }

    private String getEntryLabel(T obfEntry, Deobfuscator deobfuscator) {
        T deobfEntry = deobfuscator.deobfuscateEntry(obfEntry);
        return String.format("%s (%s)", deobfEntry.getName(), obfEntry.getName());
    }

    private void updateButtons() {
        GuiTricks.deactivateButton(this.matchButton);
        GuiTricks.deactivateButton(this.unmatchableButton);
        if (this.obfSourceEntry != null && this.obfDestEntry != null) {
            if (this.memberMatches.isMatched(this.obfSourceEntry, this.obfDestEntry)) {
                GuiTricks.activateButton(this.matchButton, "Unmatch", event -> this.unmatch());
            } else if (!this.memberMatches.isMatchedSourceEntry(this.obfSourceEntry) && !this.memberMatches.isMatchedDestEntry(this.obfDestEntry)) {
                GuiTricks.activateButton(this.matchButton, "Match", event -> this.match());
            }
        } else if (this.obfSourceEntry != null) {
            GuiTricks.activateButton(this.unmatchableButton, "Set Unmatchable", event -> this.unmatchable());
        }
    }

    protected void match() {
        this.memberMatches.makeMatch(this.obfSourceEntry, this.obfDestEntry, this.sourceDeobfuscator, this.destDeobfuscator);
        this.save();
        this.onSelectSource(null);
        this.onSelectDest(null);
        this.updateSourceHighlights();
        this.updateDestHighlights();
        this.updateSourceClasses();
    }

    protected void unmatch() {
        this.memberMatches.unmakeMatch(this.obfSourceEntry, this.obfDestEntry, this.sourceDeobfuscator, this.destDeobfuscator);
        this.save();
        this.onSelectSource(null);
        this.onSelectDest(null);
        this.updateSourceHighlights();
        this.updateDestHighlights();
        this.updateSourceClasses();
    }

    protected void unmatchable() {
        this.memberMatches.makeSourceUnmatchable(this.obfSourceEntry, this.sourceDeobfuscator);
        this.save();
        this.onSelectSource(null);
        this.onSelectDest(null);
        this.updateSourceHighlights();
        this.updateDestHighlights();
        this.updateSourceClasses();
    }

    private void save() {
        if (this.saveListener != null) {
            this.saveListener.save(this.memberMatches);
        }
    }

    public static interface SaveListener<T extends Entry> {
        public void save(MemberMatches<T> var1);
    }

    private static enum SourceType {
        Matched{

            @Override
            public <T extends Entry> Collection<ClassEntry> getObfSourceClasses(MemberMatches<T> matches) {
                return matches.getSourceClassesWithoutUnmatchedEntries();
            }
        }
        ,
        Unmatched{

            @Override
            public <T extends Entry> Collection<ClassEntry> getObfSourceClasses(MemberMatches<T> matches) {
                return matches.getSourceClassesWithUnmatchedEntries();
            }
        };


        public static SourceType getDefault() {
            return SourceType.values()[0];
        }

        public JRadioButton newRadio(ActionListener listener, ButtonGroup group) {
            JRadioButton button = new JRadioButton(this.name(), this == SourceType.getDefault());
            button.setActionCommand(this.name());
            button.addActionListener(listener);
            group.add(button);
            return button;
        }

        public abstract <T extends Entry> Collection<ClassEntry> getObfSourceClasses(MemberMatches<T> var1);
    }
}

