/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.gui.dialog;

import cuchaz.enigma.Deobfuscator;
import cuchaz.enigma.utils.Utils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class ProgressDialog
implements Deobfuscator.ProgressListener,
AutoCloseable {
    private JFrame frame = new JFrame("Enigma - Operation in progress");
    private JLabel labelTitle;
    private JLabel labelText;
    private JProgressBar progress;

    public ProgressDialog(JFrame parent) {
        Container pane = this.frame.getContentPane();
        FlowLayout layout = new FlowLayout();
        layout.setAlignment(0);
        pane.setLayout(layout);
        this.labelTitle = new JLabel();
        pane.add(this.labelTitle);
        JPanel panel = new JPanel();
        pane.add(panel);
        panel.setLayout(new BorderLayout());
        this.labelText = Utils.unboldLabel(new JLabel());
        this.progress = new JProgressBar();
        this.labelText.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
        panel.add((Component)this.labelText, "North");
        panel.add((Component)this.progress, "Center");
        panel.setPreferredSize(new Dimension(360, 50));
        pane.doLayout();
        this.frame.setSize(400, 120);
        this.frame.setResizable(false);
        this.frame.setLocationRelativeTo(parent);
        this.frame.setVisible(true);
        this.frame.setDefaultCloseOperation(0);
    }

    public static void runInThread(JFrame parent, ProgressRunnable runnable) {
        new Thread(() -> {
            try (ProgressDialog progress = new ProgressDialog(parent);){
                runnable.run(progress);
            }
            catch (Exception ex) {
                throw new Error(ex);
            }
        }).start();
    }

    @Override
    public void close() {
        this.frame.dispose();
    }

    @Override
    public void init(int totalWork, String title) {
        this.labelTitle.setText(title);
        this.progress.setMinimum(0);
        this.progress.setMaximum(totalWork);
        this.progress.setValue(0);
    }

    @Override
    public void onProgress(int numDone, String message) {
        this.labelText.setText(message);
        this.progress.setValue(numDone);
        this.frame.validate();
        this.frame.repaint();
    }

    public static interface ProgressRunnable {
        public void run(Deobfuscator.ProgressListener var1) throws Exception;
    }
}

