/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.mapping;

import com.google.common.collect.Maps;
import cuchaz.enigma.mapping.BehaviorEntry;
import cuchaz.enigma.mapping.ClassEntry;
import cuchaz.enigma.mapping.FieldMapping;
import cuchaz.enigma.mapping.Mappings;
import cuchaz.enigma.mapping.MethodMapping;
import cuchaz.enigma.mapping.NameValidator;
import cuchaz.enigma.mapping.Signature;
import cuchaz.enigma.mapping.Type;
import cuchaz.enigma.throwables.MappingConflict;
import java.util.ArrayList;
import java.util.Map;

public class ClassMapping
implements Comparable<ClassMapping> {
    private String obfFullName;
    private String obfSimpleName;
    private String deobfName;
    private String deobfFullName;
    private String previousDeobfName;
    private Map<String, ClassMapping> innerClassesByObfSimple;
    private Map<String, ClassMapping> innerClassesByObfFull;
    private Map<String, ClassMapping> innerClassesByDeobf;
    private Map<String, FieldMapping> fieldsByObf;
    private Map<String, FieldMapping> fieldsByDeobf;
    private Map<String, MethodMapping> methodsByObf;
    private Map<String, MethodMapping> methodsByDeobf;
    private boolean isDirty;
    private Mappings.EntryModifier modifier;
    private boolean deobfInner;

    public ClassMapping(String obfFullName) {
        this(obfFullName, null, Mappings.EntryModifier.UNCHANGED);
    }

    public ClassMapping(String obfFullName, String deobfName) {
        this(obfFullName, deobfName, Mappings.EntryModifier.UNCHANGED);
    }

    public ClassMapping(String obfFullName, String deobfName, Mappings.EntryModifier modifier) {
        this.obfFullName = obfFullName;
        ClassEntry classEntry = new ClassEntry(obfFullName);
        this.obfSimpleName = classEntry.isInnerClass() ? classEntry.getInnermostClassName() : classEntry.getSimpleName();
        this.previousDeobfName = null;
        this.deobfName = NameValidator.validateClassName(deobfName, false);
        this.innerClassesByObfSimple = Maps.newHashMap();
        this.innerClassesByObfFull = Maps.newHashMap();
        this.innerClassesByDeobf = Maps.newHashMap();
        this.fieldsByObf = Maps.newHashMap();
        this.fieldsByDeobf = Maps.newHashMap();
        this.methodsByObf = Maps.newHashMap();
        this.methodsByDeobf = Maps.newHashMap();
        this.isDirty = true;
        this.modifier = modifier;
    }

    public static boolean isSimpleClassName(String name) {
        return name.indexOf(47) < 0 && name.indexOf(36) < 0;
    }

    public String getObfFullName() {
        return this.obfFullName;
    }

    public String getObfSimpleName() {
        return this.obfSimpleName;
    }

    public String getPreviousDeobfName() {
        return this.previousDeobfName;
    }

    public String getDeobfName() {
        return this.deobfName;
    }

    public void setDeobfName(String val) {
        this.previousDeobfName = this.deobfName;
        this.deobfName = NameValidator.validateClassName(val, false);
        this.isDirty = true;
    }

    public Iterable<ClassMapping> innerClasses() {
        assert (this.innerClassesByObfSimple.size() >= this.innerClassesByDeobf.size());
        return this.innerClassesByObfSimple.values();
    }

    public void addInnerClassMapping(ClassMapping classMapping) throws MappingConflict {
        if (this.innerClassesByObfFull.containsKey(classMapping.getObfSimpleName())) {
            throw new MappingConflict("classes", classMapping.getObfSimpleName(), this.innerClassesByObfSimple.get(classMapping.getObfSimpleName()).getObfSimpleName());
        }
        this.innerClassesByObfFull.put(classMapping.getObfFullName(), classMapping);
        this.innerClassesByObfSimple.put(classMapping.getObfSimpleName(), classMapping);
        if (classMapping.getDeobfName() != null) {
            if (this.innerClassesByDeobf.containsKey(classMapping.getDeobfName())) {
                throw new MappingConflict("classes", classMapping.getDeobfName(), this.innerClassesByDeobf.get(classMapping.getDeobfName()).getDeobfName());
            }
            this.innerClassesByDeobf.put(classMapping.getDeobfName(), classMapping);
        }
        this.isDirty = true;
    }

    public void removeInnerClassMapping(ClassMapping classMapping) {
        boolean obfWasRemoved;
        this.innerClassesByObfFull.remove(classMapping.getObfFullName());
        boolean bl = obfWasRemoved = this.innerClassesByObfSimple.remove(classMapping.getObfSimpleName()) != null;
        assert (obfWasRemoved);
        if (classMapping.getDeobfName() != null) {
            boolean deobfWasRemoved;
            boolean bl2 = deobfWasRemoved = this.innerClassesByDeobf.remove(classMapping.getDeobfName()) != null;
            assert (deobfWasRemoved);
        }
        this.isDirty = true;
    }

    public ClassMapping getOrCreateInnerClass(ClassEntry obfInnerClass) {
        ClassMapping classMapping = this.innerClassesByObfSimple.get(obfInnerClass.getInnermostClassName());
        if (classMapping == null) {
            boolean wasAdded;
            classMapping = new ClassMapping(obfInnerClass.getName());
            this.innerClassesByObfFull.put(classMapping.getObfFullName(), classMapping);
            boolean bl = wasAdded = this.innerClassesByObfSimple.put(classMapping.getObfSimpleName(), classMapping) == null;
            assert (wasAdded);
            this.isDirty = true;
        }
        return classMapping;
    }

    public ClassMapping getInnerClassByObfSimple(String obfSimpleName) {
        assert (ClassMapping.isSimpleClassName(obfSimpleName));
        return this.innerClassesByObfSimple.get(obfSimpleName);
    }

    public ClassMapping getInnerClassByDeobf(String deobfName) {
        assert (ClassMapping.isSimpleClassName(deobfName));
        return this.innerClassesByDeobf.get(deobfName);
    }

    public ClassMapping getInnerClassByDeobfThenObfSimple(String name) {
        ClassMapping classMapping = this.getInnerClassByDeobf(name);
        if (classMapping == null) {
            classMapping = this.getInnerClassByObfSimple(name);
        }
        return classMapping;
    }

    public String getDeobfInnerClassName(String obfSimpleName) {
        assert (ClassMapping.isSimpleClassName(obfSimpleName));
        ClassMapping classMapping = this.innerClassesByObfSimple.get(obfSimpleName);
        if (classMapping != null) {
            return classMapping.getDeobfName();
        }
        return null;
    }

    public void setInnerClassName(ClassEntry obfInnerClass, String deobfName) {
        ClassMapping classMapping = this.getOrCreateInnerClass(obfInnerClass);
        if (classMapping.getDeobfName() != null) {
            boolean wasRemoved;
            boolean bl = wasRemoved = this.innerClassesByDeobf.remove(classMapping.getDeobfName()) != null;
            assert (wasRemoved);
        }
        classMapping.setDeobfName(deobfName);
        if (deobfName != null) {
            boolean wasAdded;
            assert (ClassMapping.isSimpleClassName(deobfName));
            boolean bl = wasAdded = this.innerClassesByDeobf.put(deobfName, classMapping) == null;
            assert (wasAdded);
        }
        this.isDirty = true;
    }

    public boolean hasInnerClassByObfSimple(String obfSimpleName) {
        return this.innerClassesByObfSimple.containsKey(obfSimpleName);
    }

    public boolean hasInnerClassByDeobf(String deobfName) {
        return this.innerClassesByDeobf.containsKey(deobfName);
    }

    public Iterable<FieldMapping> fields() {
        assert (this.fieldsByObf.size() == this.fieldsByDeobf.size());
        return this.fieldsByObf.values();
    }

    public boolean containsObfField(String obfName, Type obfType) {
        return this.fieldsByObf.containsKey(this.getFieldKey(obfName, obfType));
    }

    public boolean containsDeobfField(String deobfName, Type deobfType) {
        return this.fieldsByDeobf.containsKey(this.getFieldKey(deobfName, deobfType));
    }

    public void addFieldMapping(FieldMapping fieldMapping) {
        boolean obfWasAdded;
        String obfKey = this.getFieldKey(fieldMapping.getObfName(), fieldMapping.getObfType());
        if (this.fieldsByObf.containsKey(obfKey)) {
            throw new Error("Already have mapping for " + this.obfFullName + "." + obfKey);
        }
        if (fieldMapping.getDeobfName() != null) {
            boolean deobfWasAdded;
            String deobfKey = this.getFieldKey(fieldMapping.getDeobfName(), fieldMapping.getObfType());
            if (this.fieldsByDeobf.containsKey(deobfKey)) {
                throw new Error("Already have mapping for " + this.deobfName + "." + deobfKey);
            }
            boolean bl = deobfWasAdded = this.fieldsByDeobf.put(deobfKey, fieldMapping) == null;
            assert (deobfWasAdded);
        }
        boolean bl = obfWasAdded = this.fieldsByObf.put(obfKey, fieldMapping) == null;
        assert (obfWasAdded);
        this.isDirty = true;
    }

    public void removeFieldMapping(FieldMapping fieldMapping) {
        boolean obfWasRemoved;
        boolean bl = obfWasRemoved = this.fieldsByObf.remove(this.getFieldKey(fieldMapping.getObfName(), fieldMapping.getObfType())) != null;
        assert (obfWasRemoved);
        if (fieldMapping.getDeobfName() != null) {
            boolean deobfWasRemoved;
            boolean bl2 = deobfWasRemoved = this.fieldsByDeobf.remove(this.getFieldKey(fieldMapping.getDeobfName(), fieldMapping.getObfType())) != null;
            assert (deobfWasRemoved);
        }
        this.isDirty = true;
    }

    public FieldMapping getFieldByObf(String obfName, Type obfType) {
        return this.fieldsByObf.get(this.getFieldKey(obfName, obfType));
    }

    public FieldMapping getFieldByDeobf(String deobfName, Type obfType) {
        return this.fieldsByDeobf.get(this.getFieldKey(deobfName, obfType));
    }

    public String getObfFieldName(String deobfName, Type obfType) {
        FieldMapping fieldMapping = this.fieldsByDeobf.get(this.getFieldKey(deobfName, obfType));
        if (fieldMapping != null) {
            return fieldMapping.getObfName();
        }
        return null;
    }

    public String getDeobfFieldName(String obfName, Type obfType) {
        FieldMapping fieldMapping = this.fieldsByObf.get(this.getFieldKey(obfName, obfType));
        if (fieldMapping != null) {
            return fieldMapping.getDeobfName();
        }
        return null;
    }

    private String getFieldKey(String name, Type type) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null!");
        }
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null!");
        }
        return name + ":" + type;
    }

    public void setFieldName(String obfName, Type obfType, String deobfName) {
        assert (deobfName != null);
        FieldMapping fieldMapping = this.fieldsByObf.get(this.getFieldKey(obfName, obfType));
        if (fieldMapping == null) {
            boolean obfWasAdded;
            fieldMapping = new FieldMapping(obfName, obfType, deobfName, Mappings.EntryModifier.UNCHANGED);
            boolean bl = obfWasAdded = this.fieldsByObf.put(this.getFieldKey(obfName, obfType), fieldMapping) == null;
            assert (obfWasAdded);
        } else {
            boolean wasRemoved;
            boolean bl = wasRemoved = this.fieldsByDeobf.remove(this.getFieldKey(fieldMapping.getDeobfName(), obfType)) != null;
            assert (wasRemoved);
        }
        fieldMapping.setDeobfName(deobfName);
        if (deobfName != null) {
            boolean wasAdded;
            boolean bl = wasAdded = this.fieldsByDeobf.put(this.getFieldKey(deobfName, obfType), fieldMapping) == null;
            assert (wasAdded);
        }
        this.isDirty = true;
    }

    public void setFieldObfNameAndType(String oldObfName, Type obfType, String newObfName, Type newObfType) {
        boolean obfWasAdded;
        assert (newObfName != null);
        FieldMapping fieldMapping = this.fieldsByObf.remove(this.getFieldKey(oldObfName, obfType));
        assert (fieldMapping != null);
        fieldMapping.setObfName(newObfName);
        fieldMapping.setObfType(newObfType);
        boolean bl = obfWasAdded = this.fieldsByObf.put(this.getFieldKey(newObfName, newObfType), fieldMapping) == null;
        assert (obfWasAdded);
        this.isDirty = true;
    }

    public Iterable<MethodMapping> methods() {
        assert (this.methodsByObf.size() >= this.methodsByDeobf.size());
        return this.methodsByObf.values();
    }

    public boolean containsObfMethod(String obfName, Signature obfSignature) {
        return this.methodsByObf.containsKey(this.getMethodKey(obfName, obfSignature));
    }

    public boolean containsDeobfMethod(String deobfName, Signature obfSignature) {
        return this.methodsByDeobf.containsKey(this.getMethodKey(deobfName, obfSignature));
    }

    public void addMethodMapping(MethodMapping methodMapping) {
        boolean wasAdded;
        String obfKey = this.getMethodKey(methodMapping.getObfName(), methodMapping.getObfSignature());
        if (this.methodsByObf.containsKey(obfKey)) {
            throw new Error("Already have mapping for " + this.obfFullName + "." + obfKey);
        }
        boolean bl = wasAdded = this.methodsByObf.put(obfKey, methodMapping) == null;
        assert (wasAdded);
        if (methodMapping.getDeobfName() != null) {
            boolean deobfWasAdded;
            String deobfKey = this.getMethodKey(methodMapping.getDeobfName(), methodMapping.getObfSignature());
            if (this.methodsByDeobf.containsKey(deobfKey)) {
                throw new Error("Already have mapping for " + this.deobfName + "." + deobfKey);
            }
            boolean bl2 = deobfWasAdded = this.methodsByDeobf.put(deobfKey, methodMapping) == null;
            assert (deobfWasAdded);
        }
        this.isDirty = true;
        assert (this.methodsByObf.size() >= this.methodsByDeobf.size());
    }

    public void removeMethodMapping(MethodMapping methodMapping) {
        boolean obfWasRemoved;
        boolean bl = obfWasRemoved = this.methodsByObf.remove(this.getMethodKey(methodMapping.getObfName(), methodMapping.getObfSignature())) != null;
        assert (obfWasRemoved);
        if (methodMapping.getDeobfName() != null) {
            boolean deobfWasRemoved;
            boolean bl2 = deobfWasRemoved = this.methodsByDeobf.remove(this.getMethodKey(methodMapping.getDeobfName(), methodMapping.getObfSignature())) != null;
            assert (deobfWasRemoved);
        }
        this.isDirty = true;
    }

    public MethodMapping getMethodByObf(String obfName, Signature obfSignature) {
        return this.methodsByObf.get(this.getMethodKey(obfName, obfSignature));
    }

    public MethodMapping getMethodByDeobf(String deobfName, Signature obfSignature) {
        return this.methodsByDeobf.get(this.getMethodKey(deobfName, obfSignature));
    }

    private String getMethodKey(String name, Signature signature) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null!");
        }
        if (signature == null) {
            throw new IllegalArgumentException("signature cannot be null!");
        }
        return name + signature;
    }

    public void setMethodName(String obfName, Signature obfSignature, String deobfName) {
        MethodMapping methodMapping = this.methodsByObf.get(this.getMethodKey(obfName, obfSignature));
        if (methodMapping == null) {
            methodMapping = this.createMethodMapping(obfName, obfSignature);
        } else if (methodMapping.getDeobfName() != null) {
            boolean wasRemoved;
            boolean bl = wasRemoved = this.methodsByDeobf.remove(this.getMethodKey(methodMapping.getDeobfName(), methodMapping.getObfSignature())) != null;
            assert (wasRemoved);
        }
        methodMapping.setDeobfName(deobfName);
        if (deobfName != null) {
            boolean wasAdded;
            boolean bl = wasAdded = this.methodsByDeobf.put(this.getMethodKey(deobfName, obfSignature), methodMapping) == null;
            assert (wasAdded);
        }
        this.isDirty = true;
    }

    public void setMethodObfNameAndSignature(String oldObfName, Signature obfSignature, String newObfName, Signature newObfSignature) {
        boolean obfWasAdded;
        assert (newObfName != null);
        MethodMapping methodMapping = this.methodsByObf.remove(this.getMethodKey(oldObfName, obfSignature));
        assert (methodMapping != null);
        methodMapping.setObfName(newObfName);
        methodMapping.setObfSignature(newObfSignature);
        boolean bl = obfWasAdded = this.methodsByObf.put(this.getMethodKey(newObfName, newObfSignature), methodMapping) == null;
        assert (obfWasAdded);
        this.isDirty = true;
    }

    public void setArgumentName(String obfMethodName, Signature obfMethodSignature, int argumentIndex, String argumentName) {
        assert (argumentName != null);
        MethodMapping methodMapping = this.methodsByObf.get(this.getMethodKey(obfMethodName, obfMethodSignature));
        if (methodMapping == null) {
            methodMapping = this.createMethodMapping(obfMethodName, obfMethodSignature);
        }
        methodMapping.setArgumentName(argumentIndex, argumentName);
        this.isDirty = true;
    }

    public void removeArgumentName(String obfMethodName, Signature obfMethodSignature, int argumentIndex) {
        this.methodsByObf.get(this.getMethodKey(obfMethodName, obfMethodSignature)).removeArgumentName(argumentIndex);
        this.isDirty = true;
    }

    private MethodMapping createMethodMapping(String obfName, Signature obfSignature) {
        boolean wasAdded;
        MethodMapping methodMapping = new MethodMapping(obfName, obfSignature);
        boolean bl = wasAdded = this.methodsByObf.put(this.getMethodKey(obfName, obfSignature), methodMapping) == null;
        assert (wasAdded);
        this.isDirty = true;
        return methodMapping;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.obfFullName);
        buf.append(" <-> ");
        buf.append(this.deobfName);
        buf.append("\n");
        buf.append("Fields:\n");
        for (FieldMapping fieldMapping : this.fields()) {
            buf.append("\t");
            buf.append(fieldMapping.getObfName());
            buf.append(" <-> ");
            buf.append(fieldMapping.getDeobfName());
            buf.append("\n");
        }
        buf.append("Methods:\n");
        for (MethodMapping methodMapping : this.methodsByObf.values()) {
            buf.append(methodMapping);
            buf.append("\n");
        }
        buf.append("Inner Classes:\n");
        for (ClassMapping classMapping : this.innerClassesByObfSimple.values()) {
            buf.append("\t");
            buf.append(classMapping.getObfSimpleName());
            buf.append(" <-> ");
            buf.append(classMapping.getDeobfName());
            buf.append("\n");
        }
        return buf.toString();
    }

    @Override
    public int compareTo(ClassMapping other) {
        if (this.obfFullName.length() != other.obfFullName.length()) {
            return this.obfFullName.length() - other.obfFullName.length();
        }
        return this.obfFullName.compareTo(other.obfFullName);
    }

    public boolean renameObfClass(String oldObfClassName, String newObfClassName) {
        boolean wasAdded;
        boolean wasRemoved;
        for (ClassMapping innerClassMapping : new ArrayList<ClassMapping>(this.innerClassesByObfSimple.values())) {
            boolean wasAdded2;
            boolean wasRemoved2;
            if (!innerClassMapping.renameObfClass(oldObfClassName, newObfClassName)) continue;
            boolean bl = wasRemoved2 = this.innerClassesByObfSimple.remove(oldObfClassName) != null;
            assert (wasRemoved2);
            boolean bl2 = wasAdded2 = this.innerClassesByObfSimple.put(newObfClassName, innerClassMapping) == null;
            assert (wasAdded2);
        }
        for (FieldMapping fieldMapping : new ArrayList<FieldMapping>(this.fieldsByObf.values())) {
            String oldFieldKey = this.getFieldKey(fieldMapping.getObfName(), fieldMapping.getObfType());
            if (!fieldMapping.renameObfClass(oldObfClassName, newObfClassName)) continue;
            boolean bl = wasRemoved = this.fieldsByObf.remove(oldFieldKey) != null;
            assert (wasRemoved);
            boolean bl3 = wasAdded = this.fieldsByObf.put(this.getFieldKey(fieldMapping.getObfName(), fieldMapping.getObfType()), fieldMapping) == null;
            assert (wasAdded);
        }
        for (MethodMapping methodMapping : new ArrayList<MethodMapping>(this.methodsByObf.values())) {
            String oldMethodKey = this.getMethodKey(methodMapping.getObfName(), methodMapping.getObfSignature());
            if (!methodMapping.renameObfClass(oldObfClassName, newObfClassName)) continue;
            boolean bl = wasRemoved = this.methodsByObf.remove(oldMethodKey) != null;
            assert (wasRemoved);
            boolean bl4 = wasAdded = this.methodsByObf.put(this.getMethodKey(methodMapping.getObfName(), methodMapping.getObfSignature()), methodMapping) == null;
            assert (wasAdded);
        }
        if (this.obfFullName.equals(oldObfClassName)) {
            this.obfFullName = newObfClassName;
            return true;
        }
        this.isDirty = true;
        return false;
    }

    public boolean containsArgument(BehaviorEntry obfBehaviorEntry, String name) {
        MethodMapping methodMapping = this.methodsByObf.get(this.getMethodKey(obfBehaviorEntry.getName(), obfBehaviorEntry.getSignature()));
        return methodMapping != null && methodMapping.containsArgument(name);
    }

    public ClassEntry getObfEntry() {
        return new ClassEntry(this.obfFullName);
    }

    public ClassEntry getDeObfEntry() {
        return this.deobfFullName != null ? new ClassEntry(this.deobfFullName) : null;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public void resetDirty() {
        this.isDirty = false;
    }

    public Mappings.EntryModifier getModifier() {
        return this.modifier;
    }

    public void setModifier(Mappings.EntryModifier modifier) {
        if (this.modifier != modifier) {
            this.isDirty = true;
        }
        this.modifier = modifier;
    }

    public void setFieldModifier(String obfName, Type obfType, Mappings.EntryModifier modifier) {
        FieldMapping fieldMapping = this.fieldsByObf.computeIfAbsent(this.getFieldKey(obfName, obfType), k -> new FieldMapping(obfName, obfType, null, Mappings.EntryModifier.UNCHANGED));
        if (fieldMapping.getModifier() != modifier) {
            fieldMapping.setModifier(modifier);
            this.isDirty = true;
        }
    }

    public void setMethodModifier(String obfName, Signature sig, Mappings.EntryModifier modifier) {
        MethodMapping methodMapping = this.methodsByObf.computeIfAbsent(this.getMethodKey(obfName, sig), k -> new MethodMapping(obfName, sig, null, Mappings.EntryModifier.UNCHANGED));
        if (methodMapping.getModifier() != modifier) {
            methodMapping.setModifier(modifier);
            this.isDirty = true;
        }
    }

    public ClassMapping setDeobInner(String deobName) {
        this.deobfFullName = deobName;
        return this;
    }
}

