/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.mapping;

import cuchaz.enigma.mapping.ClassEntry;
import cuchaz.enigma.mapping.ClassNameReplacer;
import cuchaz.enigma.mapping.FieldEntry;
import cuchaz.enigma.mapping.Mappings;
import cuchaz.enigma.mapping.MemberMapping;
import cuchaz.enigma.mapping.NameValidator;
import cuchaz.enigma.mapping.Type;
import cuchaz.enigma.throwables.IllegalNameException;

public class FieldMapping
implements Comparable<FieldMapping>,
MemberMapping<FieldEntry> {
    private String obfName;
    private String deobfName;
    private Type obfType;
    private Mappings.EntryModifier modifier;

    public FieldMapping(String obfName, Type obfType, String deobfName, Mappings.EntryModifier modifier) {
        this.obfName = obfName;
        this.deobfName = NameValidator.validateFieldName(deobfName);
        this.obfType = obfType;
        this.modifier = modifier;
    }

    public FieldMapping(FieldMapping other, ClassNameReplacer obfClassNameReplacer) {
        this.obfName = other.obfName;
        this.deobfName = other.deobfName;
        this.modifier = other.modifier;
        this.obfType = new Type(other.obfType, obfClassNameReplacer);
    }

    @Override
    public FieldEntry getObfEntry(ClassEntry classEntry) {
        return new FieldEntry(classEntry, this.obfName, this.obfType);
    }

    @Override
    public String getObfName() {
        return this.obfName;
    }

    public void setObfName(String name) {
        block2: {
            try {
                NameValidator.validateMethodName(name);
            }
            catch (IllegalNameException ex) {
                if (this.deobfName != null) break block2;
                System.err.println("WARNING: " + name + " is conflicting, auto deobfuscate to " + name + "_auto_deob");
                this.setDeobfName(name + "_auto_deob");
            }
        }
        this.obfName = name;
    }

    public String getDeobfName() {
        return this.deobfName;
    }

    public void setDeobfName(String val) {
        this.deobfName = NameValidator.validateFieldName(val);
    }

    public Type getObfType() {
        return this.obfType;
    }

    public void setObfType(Type val) {
        this.obfType = val;
    }

    public Mappings.EntryModifier getModifier() {
        return this.modifier;
    }

    public void setModifier(Mappings.EntryModifier modifier) {
        this.modifier = modifier;
    }

    @Override
    public int compareTo(FieldMapping other) {
        return (this.obfName + this.obfType).compareTo(other.obfName + other.obfType);
    }

    public boolean renameObfClass(String oldObfClassName, String newObfClassName) {
        Type newType = new Type(this.obfType, className -> {
            if (className.equals(oldObfClassName)) {
                return newObfClassName;
            }
            return null;
        });
        if (!newType.equals(this.obfType)) {
            this.obfType = newType;
            return true;
        }
        return false;
    }
}

