/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.mapping;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import cuchaz.enigma.analysis.TranslationIndex;
import cuchaz.enigma.mapping.BehaviorEntry;
import cuchaz.enigma.mapping.ClassEntry;
import cuchaz.enigma.mapping.ClassMapping;
import cuchaz.enigma.mapping.FieldMapping;
import cuchaz.enigma.mapping.MappingsEnigmaWriter;
import cuchaz.enigma.mapping.MappingsSRGWriter;
import cuchaz.enigma.mapping.MethodMapping;
import cuchaz.enigma.mapping.Signature;
import cuchaz.enigma.mapping.TranslationDirection;
import cuchaz.enigma.mapping.Translator;
import cuchaz.enigma.mapping.Type;
import cuchaz.enigma.throwables.MappingConflict;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Mappings {
    private final FormatType originMapping;
    protected Map<String, ClassMapping> classesByObf;
    protected Map<String, ClassMapping> classesByDeobf;
    private Mappings previousState;

    public Mappings() {
        this(FormatType.ENIGMA_DIRECTORY);
    }

    public Mappings(FormatType originMapping) {
        this.originMapping = originMapping;
        this.classesByObf = Maps.newHashMap();
        this.classesByDeobf = Maps.newHashMap();
    }

    public Collection<ClassMapping> classes() {
        assert (this.classesByObf.size() >= this.classesByDeobf.size());
        return this.classesByObf.values();
    }

    public void addClassMapping(ClassMapping classMapping) throws MappingConflict {
        if (this.classesByObf.containsKey(classMapping.getObfFullName())) {
            throw new MappingConflict("class", classMapping.getObfFullName(), this.classesByObf.get(classMapping.getObfFullName()).getObfFullName());
        }
        this.classesByObf.put(classMapping.getObfFullName(), classMapping);
        if (classMapping.getDeobfName() != null) {
            if (this.classesByDeobf.containsKey(classMapping.getDeobfName())) {
                throw new MappingConflict("class", classMapping.getDeobfName(), this.classesByDeobf.get(classMapping.getDeobfName()).getDeobfName());
            }
            this.classesByDeobf.put(classMapping.getDeobfName(), classMapping);
        }
    }

    public void removeClassMapping(ClassMapping classMapping) {
        boolean obfWasRemoved;
        boolean bl = obfWasRemoved = this.classesByObf.remove(classMapping.getObfFullName()) != null;
        assert (obfWasRemoved);
        if (classMapping.getDeobfName() != null) {
            boolean deobfWasRemoved;
            boolean bl2 = deobfWasRemoved = this.classesByDeobf.remove(classMapping.getDeobfName()) != null;
            assert (deobfWasRemoved);
        }
    }

    public ClassMapping getClassByObf(ClassEntry entry) {
        return this.getClassByObf(entry.getName());
    }

    public ClassMapping getClassByObf(String obfName) {
        return this.classesByObf.get(obfName);
    }

    public ClassMapping getClassByDeobf(ClassEntry entry) {
        return this.getClassByDeobf(entry.getName());
    }

    public ClassMapping getClassByDeobf(String deobfName) {
        return this.classesByDeobf.get(deobfName);
    }

    public void setClassDeobfName(ClassMapping classMapping, String deobfName) {
        if (classMapping.getDeobfName() != null) {
            boolean wasRemoved;
            boolean bl = wasRemoved = this.classesByDeobf.remove(classMapping.getDeobfName()) != null;
            assert (wasRemoved);
        }
        classMapping.setDeobfName(deobfName);
        if (deobfName != null) {
            boolean wasAdded;
            boolean bl = wasAdded = this.classesByDeobf.put(deobfName, classMapping) == null;
            assert (wasAdded);
        }
    }

    public Translator getTranslator(TranslationDirection direction, TranslationIndex index) {
        switch (direction) {
            case Deobfuscating: {
                return new Translator(direction, this.classesByObf, index);
            }
            case Obfuscating: {
                HashMap<String, ClassMapping> classes = Maps.newHashMap();
                for (ClassMapping classMapping : this.classes()) {
                    if (classMapping.getDeobfName() != null) {
                        classes.put(classMapping.getDeobfName(), classMapping);
                        continue;
                    }
                    classes.put(classMapping.getObfFullName(), classMapping);
                }
                TranslationIndex deobfIndex = new TranslationIndex(index, this.getTranslator(TranslationDirection.Deobfuscating, index));
                return new Translator(direction, classes, deobfIndex);
            }
        }
        throw new Error("Invalid translation direction!");
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        for (ClassMapping classMapping : this.classesByObf.values()) {
            buf.append(classMapping);
            buf.append("\n");
        }
        return buf.toString();
    }

    public void renameObfClass(String oldObfName, String newObfName) {
        new ArrayList<ClassMapping>(this.classes()).stream().filter(classMapping -> classMapping.renameObfClass(oldObfName, newObfName)).forEach(classMapping -> {
            boolean wasAdded;
            boolean wasRemoved;
            boolean bl = wasRemoved = this.classesByObf.remove(oldObfName) != null;
            assert (wasRemoved);
            boolean bl2 = wasAdded = this.classesByObf.put(newObfName, (ClassMapping)classMapping) == null;
            assert (wasAdded);
        });
    }

    public Set<String> getAllObfClassNames() {
        HashSet<String> classNames = Sets.newHashSet();
        for (ClassMapping classMapping : this.classes()) {
            classNames.add(classMapping.getObfFullName());
            for (MethodMapping methodMapping : classMapping.methods()) {
                for (Type type : methodMapping.getObfSignature().types()) {
                    if (!type.hasClass()) continue;
                    classNames.add(type.getClassEntry().getClassName());
                }
            }
        }
        return classNames;
    }

    public boolean containsDeobfClass(String deobfName) {
        return this.classesByDeobf.containsKey(deobfName);
    }

    public boolean containsDeobfField(ClassEntry obfClassEntry, String deobfName, Type obfType) {
        ClassMapping classMapping = this.classesByObf.get(obfClassEntry.getName());
        return classMapping != null && classMapping.containsDeobfField(deobfName, obfType);
    }

    public boolean containsDeobfField(ClassEntry obfClassEntry, String deobfName) {
        ClassMapping classMapping = this.classesByObf.get(obfClassEntry.getName());
        if (classMapping != null) {
            for (FieldMapping fieldMapping : classMapping.fields()) {
                if (!deobfName.equals(fieldMapping.getDeobfName()) && !deobfName.equals(fieldMapping.getObfName())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsDeobfMethod(ClassEntry obfClassEntry, String deobfName, Signature obfSignature) {
        ClassMapping classMapping = this.classesByObf.get(obfClassEntry.getName());
        return classMapping != null && classMapping.containsDeobfMethod(deobfName, obfSignature);
    }

    public boolean containsArgument(BehaviorEntry obfBehaviorEntry, String name) {
        ClassMapping classMapping = this.classesByObf.get(obfBehaviorEntry.getClassName());
        return classMapping != null && classMapping.containsArgument(obfBehaviorEntry, name);
    }

    public List<ClassMapping> getClassMappingChain(ClassEntry obfClass) {
        ArrayList<ClassMapping> mappingChain = Lists.newArrayList();
        ClassMapping classMapping = null;
        for (ClassEntry obfClassEntry : obfClass.getClassChain()) {
            if (mappingChain.isEmpty()) {
                classMapping = this.classesByObf.get(obfClassEntry.getName());
            } else if (classMapping != null) {
                classMapping = classMapping.getInnerClassByObfSimple(obfClassEntry.getInnermostClassName());
            }
            mappingChain.add(classMapping);
        }
        return mappingChain;
    }

    public FormatType getOriginMappingFormat() {
        return this.originMapping;
    }

    public void savePreviousState() {
        this.previousState = new Mappings(this.originMapping);
        this.previousState.classesByDeobf = Maps.newHashMap(this.classesByDeobf);
        this.previousState.classesByObf = Maps.newHashMap(this.classesByObf);
        this.classesByDeobf.values().forEach(ClassMapping::resetDirty);
        this.classesByObf.values().forEach(ClassMapping::resetDirty);
    }

    public void saveEnigmaMappings(File file, boolean isDirectoryFormat) throws IOException {
        new MappingsEnigmaWriter().write(file, this, isDirectoryFormat);
        this.savePreviousState();
    }

    public void saveSRGMappings(File file) throws IOException {
        new MappingsSRGWriter().write(file, this);
    }

    public Mappings getPreviousState() {
        return this.previousState;
    }

    public static enum EntryModifier {
        UNCHANGED,
        PUBLIC,
        PROTECTED,
        PRIVATE;


        public String getFormattedName() {
            return " ACC:" + super.toString();
        }
    }

    public static enum FormatType {
        ENIGMA_FILE,
        ENIGMA_DIRECTORY,
        TINY_FILE,
        SRG_FILE;

    }
}

