/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.mapping;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import cuchaz.enigma.analysis.JarIndex;
import cuchaz.enigma.mapping.BehaviorEntry;
import cuchaz.enigma.mapping.ClassEntry;
import cuchaz.enigma.mapping.ClassMapping;
import cuchaz.enigma.mapping.EntryFactory;
import cuchaz.enigma.mapping.FieldEntry;
import cuchaz.enigma.mapping.FieldMapping;
import cuchaz.enigma.mapping.Mappings;
import cuchaz.enigma.mapping.MethodMapping;
import java.util.Map;

public class MappingsChecker {
    private JarIndex index;
    private Map<ClassEntry, ClassMapping> droppedClassMappings;
    private Map<ClassEntry, ClassMapping> droppedInnerClassMappings;
    private Map<FieldEntry, FieldMapping> droppedFieldMappings;
    private Map<BehaviorEntry, MethodMapping> droppedMethodMappings;

    public MappingsChecker(JarIndex index) {
        this.index = index;
        this.droppedClassMappings = Maps.newHashMap();
        this.droppedInnerClassMappings = Maps.newHashMap();
        this.droppedFieldMappings = Maps.newHashMap();
        this.droppedMethodMappings = Maps.newHashMap();
    }

    public Map<ClassEntry, ClassMapping> getDroppedClassMappings() {
        return this.droppedClassMappings;
    }

    public Map<ClassEntry, ClassMapping> getDroppedInnerClassMappings() {
        return this.droppedInnerClassMappings;
    }

    public Map<FieldEntry, FieldMapping> getDroppedFieldMappings() {
        return this.droppedFieldMappings;
    }

    public Map<BehaviorEntry, MethodMapping> getDroppedMethodMappings() {
        return this.droppedMethodMappings;
    }

    public void dropBrokenMappings(Mappings mappings) {
        for (ClassMapping classMapping : Lists.newArrayList(mappings.classes())) {
            if (this.checkClassMapping(classMapping)) continue;
            mappings.removeClassMapping(classMapping);
            this.droppedClassMappings.put(EntryFactory.getObfClassEntry(this.index, classMapping), classMapping);
        }
    }

    private boolean checkClassMapping(ClassMapping classMapping) {
        ClassEntry classEntry = EntryFactory.getObfClassEntry(this.index, classMapping);
        if (!this.index.getObfClassEntries().contains(classEntry)) {
            return false;
        }
        for (FieldMapping fieldMapping : Lists.newArrayList(classMapping.fields())) {
            FieldEntry obfFieldEntry = EntryFactory.getObfFieldEntry(classMapping, fieldMapping);
            if (this.index.containsObfField(obfFieldEntry)) continue;
            classMapping.removeFieldMapping(fieldMapping);
            this.droppedFieldMappings.put(obfFieldEntry, fieldMapping);
        }
        for (MethodMapping methodMapping : Lists.newArrayList(classMapping.methods())) {
            BehaviorEntry obfBehaviorEntry = EntryFactory.getObfBehaviorEntry(classEntry, methodMapping);
            if (this.index.containsObfBehavior(obfBehaviorEntry)) continue;
            classMapping.removeMethodMapping(methodMapping);
            this.droppedMethodMappings.put(obfBehaviorEntry, methodMapping);
        }
        for (ClassMapping innerClassMapping : Lists.newArrayList(classMapping.innerClasses())) {
            if (this.checkClassMapping(innerClassMapping)) continue;
            classMapping.removeInnerClassMapping(innerClassMapping);
            this.droppedInnerClassMappings.put(EntryFactory.getObfClassEntry(this.index, innerClassMapping), innerClassMapping);
        }
        return true;
    }
}

