/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.mapping;

import com.google.common.base.Charsets;
import com.google.common.collect.Queues;
import cuchaz.enigma.mapping.ArgumentMapping;
import cuchaz.enigma.mapping.ClassMapping;
import cuchaz.enigma.mapping.FieldMapping;
import cuchaz.enigma.mapping.Mappings;
import cuchaz.enigma.mapping.MethodMapping;
import cuchaz.enigma.mapping.Signature;
import cuchaz.enigma.mapping.Type;
import cuchaz.enigma.throwables.MappingConflict;
import cuchaz.enigma.throwables.MappingParseException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayDeque;

public class MappingsEnigmaReader {
    public Mappings read(File file) throws IOException, MappingParseException {
        Mappings mappings;
        if (file.isDirectory()) {
            mappings = new Mappings(Mappings.FormatType.ENIGMA_DIRECTORY);
            this.readDirectory(mappings, file);
        } else {
            mappings = new Mappings();
            this.readFile(mappings, file);
        }
        return mappings;
    }

    public void readDirectory(Mappings mappings, File directory) throws IOException, MappingParseException {
        File[] files = directory.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isFile() && !file.getName().startsWith(".") && file.getName().endsWith(".mapping")) {
                    this.readFile(mappings, file);
                    continue;
                }
                if (!file.isDirectory()) continue;
                this.readDirectory(mappings, file.getAbsoluteFile());
            }
        } else {
            throw new IOException("Cannot access directory" + directory.getAbsolutePath());
        }
        mappings.savePreviousState();
    }

    public Mappings readFile(Mappings mappings, File file) throws IOException, MappingParseException {
        String line;
        BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), Charsets.UTF_8));
        ArrayDeque<Comparable<ClassMapping>> mappingStack = Queues.newArrayDeque();
        int lineNumber = 0;
        while ((line = in.readLine()) != null) {
            ++lineNumber;
            int commentPos = line.indexOf(35);
            if (commentPos >= 0) {
                line = line.substring(0, commentPos);
            }
            if (line.trim().length() <= 0) continue;
            int indent = 0;
            for (int i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
                ++indent;
            }
            while (indent < mappingStack.size()) {
                mappingStack.pop();
            }
            String[] parts = line.trim().split("\\s");
            try {
                String token = parts[0];
                if (token.equalsIgnoreCase("CLASS")) {
                    ClassMapping classMapping;
                    if (indent <= 0) {
                        classMapping = this.readClass(parts, false);
                        mappings.addClassMapping(classMapping);
                    } else {
                        if (!(mappingStack.peek() instanceof ClassMapping)) {
                            throw new MappingParseException(file, lineNumber, "Unexpected CLASS entry here!");
                        }
                        classMapping = this.readClass(parts, true);
                        ((ClassMapping)mappingStack.peek()).addInnerClassMapping(classMapping);
                    }
                    mappingStack.push(classMapping);
                    continue;
                }
                if (token.equalsIgnoreCase("FIELD")) {
                    if (mappingStack.isEmpty() || !(mappingStack.peek() instanceof ClassMapping)) {
                        throw new MappingParseException(file, lineNumber, "Unexpected FIELD entry here!");
                    }
                    ((ClassMapping)mappingStack.peek()).addFieldMapping(this.readField(parts));
                    continue;
                }
                if (token.equalsIgnoreCase("METHOD")) {
                    if (mappingStack.isEmpty() || !(mappingStack.peek() instanceof ClassMapping)) {
                        throw new MappingParseException(file, lineNumber, "Unexpected METHOD entry here!");
                    }
                    MethodMapping methodMapping = this.readMethod(parts);
                    ((ClassMapping)mappingStack.peek()).addMethodMapping(methodMapping);
                    mappingStack.push(methodMapping);
                    continue;
                }
                if (!token.equalsIgnoreCase("ARG")) continue;
                if (mappingStack.isEmpty() || !(mappingStack.peek() instanceof MethodMapping)) {
                    throw new MappingParseException(file, lineNumber, "Unexpected ARG entry here!");
                }
                ((MethodMapping)mappingStack.peek()).addArgumentMapping(this.readArgument(parts));
            }
            catch (ArrayIndexOutOfBoundsException | IllegalArgumentException ex) {
                throw new MappingParseException(file, lineNumber, "Malformed line:\n" + line);
            }
            catch (MappingConflict e) {
                throw new MappingParseException(file, lineNumber, e.getMessage());
            }
        }
        in.close();
        return mappings;
    }

    private ArgumentMapping readArgument(String[] parts) {
        return new ArgumentMapping(Integer.parseInt(parts[1]), parts[2]);
    }

    private ClassMapping readClass(String[] parts, boolean makeSimple) {
        if (parts.length == 2) {
            return new ClassMapping(parts[1]);
        }
        if (parts.length == 3) {
            boolean access = parts[2].startsWith("ACC:");
            ClassMapping mapping = access ? new ClassMapping(parts[1], null, Mappings.EntryModifier.valueOf(parts[2].substring(4))) : new ClassMapping(parts[1], parts[2]);
            return mapping;
        }
        if (parts.length == 4) {
            return new ClassMapping(parts[1], parts[2], Mappings.EntryModifier.valueOf(parts[3].substring(4)));
        }
        return null;
    }

    protected FieldMapping readField(String[] parts) {
        FieldMapping mapping = null;
        if (parts.length == 4) {
            boolean access = parts[3].startsWith("ACC:");
            mapping = access ? new FieldMapping(parts[1], new Type(parts[2]), null, Mappings.EntryModifier.valueOf(parts[3].substring(4))) : new FieldMapping(parts[1], new Type(parts[3]), parts[2], Mappings.EntryModifier.UNCHANGED);
        } else if (parts.length == 5) {
            mapping = new FieldMapping(parts[1], new Type(parts[3]), parts[2], Mappings.EntryModifier.valueOf(parts[4].substring(4)));
        }
        return mapping;
    }

    private MethodMapping readMethod(String[] parts) {
        MethodMapping mapping = null;
        if (parts.length == 3) {
            mapping = new MethodMapping(parts[1], new Signature(parts[2]));
        } else if (parts.length == 4) {
            boolean access = parts[3].startsWith("ACC:");
            mapping = access ? new MethodMapping(parts[1], new Signature(parts[2]), null, Mappings.EntryModifier.valueOf(parts[3].substring(4))) : new MethodMapping(parts[1], new Signature(parts[3]), parts[2]);
        } else if (parts.length == 5) {
            mapping = new MethodMapping(parts[1], new Signature(parts[3]), parts[2], Mappings.EntryModifier.valueOf(parts[4].substring(4)));
        }
        return mapping;
    }
}

