/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.mapping;

import com.google.common.base.Charsets;
import cuchaz.enigma.mapping.ArgumentMapping;
import cuchaz.enigma.mapping.ClassMapping;
import cuchaz.enigma.mapping.FieldMapping;
import cuchaz.enigma.mapping.Mappings;
import cuchaz.enigma.mapping.MethodMapping;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MappingsEnigmaWriter {
    public void write(File out, Mappings mappings, boolean isDirectoryFormat) throws IOException {
        if (!isDirectoryFormat) {
            PrintWriter outputWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(out), Charsets.UTF_8));
            this.write(outputWriter, mappings);
            outputWriter.close();
        } else {
            this.writeAsDirectory(out, mappings);
        }
    }

    public void writeAsDirectory(File target, Mappings mappings) throws IOException {
        if (!target.exists() && !target.mkdirs()) {
            throw new IOException("Cannot create mapping directory!");
        }
        for (ClassMapping classMapping : this.sorted(mappings.classes())) {
            File result;
            if (!classMapping.isDirty()) continue;
            this.deletePreviousClassMapping(target, classMapping);
            File obFile = new File(target, classMapping.getObfFullName() + ".mapping");
            if (classMapping.getDeobfName() == null) {
                result = obFile;
            } else {
                if (obFile.exists()) {
                    obFile.delete();
                }
                result = new File(target, classMapping.getDeobfName() + ".mapping");
            }
            if (!result.getParentFile().exists()) {
                result.getParentFile().mkdirs();
            }
            result.createNewFile();
            PrintWriter outputWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(result), Charsets.UTF_8));
            this.write(outputWriter, classMapping, 0);
            outputWriter.close();
        }
        if (mappings.getPreviousState() != null) {
            ArrayList<ClassMapping> droppedClassMappings = new ArrayList<ClassMapping>(mappings.getPreviousState().classes());
            ArrayList<ClassMapping> classMappings = new ArrayList<ClassMapping>(mappings.classes());
            droppedClassMappings.removeAll(classMappings);
            for (ClassMapping classMapping : droppedClassMappings) {
                File result;
                File obFile = new File(target, classMapping.getObfFullName() + ".mapping");
                if (classMapping.getDeobfName() == null) {
                    result = obFile;
                } else {
                    if (obFile.exists()) {
                        obFile.delete();
                    }
                    result = new File(target, classMapping.getDeobfName() + ".mapping");
                }
                if (!result.exists()) continue;
                result.delete();
            }
        }
    }

    private void deletePreviousClassMapping(File target, ClassMapping classMapping) {
        File prevFile = null;
        if (classMapping.getDeobfName() != null && classMapping.getPreviousDeobfName() != null && !classMapping.getPreviousDeobfName().equals(classMapping.getDeobfName())) {
            prevFile = new File(target, classMapping.getPreviousDeobfName() + ".mapping");
        } else if (classMapping.getDeobfName() == null && classMapping.getPreviousDeobfName() != null) {
            prevFile = new File(target, classMapping.getPreviousDeobfName() + ".mapping");
        } else if (classMapping.getDeobfName() != null && classMapping.getPreviousDeobfName() == null) {
            prevFile = new File(target, classMapping.getObfFullName() + ".mapping");
        }
        if (prevFile != null && prevFile.exists()) {
            prevFile.delete();
        }
    }

    public void write(PrintWriter out, Mappings mappings) throws IOException {
        for (ClassMapping classMapping : this.sorted(mappings.classes())) {
            this.write(out, classMapping, 0);
        }
    }

    private void write(PrintWriter out, ClassMapping classMapping, int depth) throws IOException {
        if (classMapping.getDeobfName() == null) {
            out.format("%sCLASS %s%s\n", this.getIndent(depth), classMapping.getObfFullName(), classMapping.getModifier() == Mappings.EntryModifier.UNCHANGED ? "" : classMapping.getModifier().getFormattedName());
        } else {
            out.format("%sCLASS %s %s%s\n", this.getIndent(depth), classMapping.getObfFullName(), classMapping.getDeobfName(), classMapping.getModifier() == Mappings.EntryModifier.UNCHANGED ? "" : classMapping.getModifier().getFormattedName());
        }
        for (ClassMapping innerClassMapping : this.sorted(classMapping.innerClasses())) {
            this.write(out, innerClassMapping, depth + 1);
        }
        for (FieldMapping fieldMapping : this.sorted(classMapping.fields())) {
            this.write(out, fieldMapping, depth + 1);
        }
        for (MethodMapping methodMapping : this.sorted(classMapping.methods())) {
            this.write(out, methodMapping, depth + 1);
        }
    }

    private void write(PrintWriter out, FieldMapping fieldMapping, int depth) {
        if (fieldMapping.getDeobfName() == null) {
            out.format("%sFIELD %s %s%s\n", this.getIndent(depth), fieldMapping.getObfName(), fieldMapping.getObfType().toString(), fieldMapping.getModifier() == Mappings.EntryModifier.UNCHANGED ? "" : fieldMapping.getModifier().getFormattedName());
        } else {
            out.format("%sFIELD %s %s %s%s\n", this.getIndent(depth), fieldMapping.getObfName(), fieldMapping.getDeobfName(), fieldMapping.getObfType().toString(), fieldMapping.getModifier() == Mappings.EntryModifier.UNCHANGED ? "" : fieldMapping.getModifier().getFormattedName());
        }
    }

    private void write(PrintWriter out, MethodMapping methodMapping, int depth) throws IOException {
        if (methodMapping.getDeobfName() == null) {
            out.format("%sMETHOD %s %s%s\n", this.getIndent(depth), methodMapping.getObfName(), methodMapping.getObfSignature(), methodMapping.getModifier() == Mappings.EntryModifier.UNCHANGED ? "" : methodMapping.getModifier().getFormattedName());
        } else {
            out.format("%sMETHOD %s %s %s%s\n", this.getIndent(depth), methodMapping.getObfName(), methodMapping.getDeobfName(), methodMapping.getObfSignature(), methodMapping.getModifier() == Mappings.EntryModifier.UNCHANGED ? "" : methodMapping.getModifier().getFormattedName());
        }
        for (ArgumentMapping argumentMapping : this.sorted(methodMapping.arguments())) {
            this.write(out, argumentMapping, depth + 1);
        }
    }

    private void write(PrintWriter out, ArgumentMapping argumentMapping, int depth) {
        out.format("%sARG %d %s\n", this.getIndent(depth), argumentMapping.getIndex(), argumentMapping.getName());
    }

    private <T extends Comparable<T>> List<T> sorted(Iterable<T> classes) {
        ArrayList<Comparable> out = new ArrayList<Comparable>();
        for (Comparable t : classes) {
            out.add(t);
        }
        Collections.sort(out);
        return out;
    }

    private String getIndent(int depth) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < depth; ++i) {
            buf.append("\t");
        }
        return buf.toString();
    }
}

