/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.mapping;

import cuchaz.enigma.mapping.BehaviorEntry;
import cuchaz.enigma.mapping.ClassEntry;
import cuchaz.enigma.mapping.Signature;
import cuchaz.enigma.utils.Utils;

public class MethodEntry
implements BehaviorEntry {
    private ClassEntry classEntry;
    private String name;
    private Signature signature;

    public MethodEntry(ClassEntry classEntry, String name, Signature signature) {
        if (classEntry == null) {
            throw new IllegalArgumentException("Class cannot be null!");
        }
        if (name == null) {
            throw new IllegalArgumentException("Method name cannot be null!");
        }
        if (signature == null) {
            throw new IllegalArgumentException("Method signature cannot be null!");
        }
        if (name.startsWith("<")) {
            throw new IllegalArgumentException("Don't use MethodEntry for a constructor!");
        }
        this.classEntry = classEntry;
        this.name = name;
        this.signature = signature;
    }

    public MethodEntry(MethodEntry other, String newClassName) {
        this.classEntry = new ClassEntry(newClassName);
        this.name = other.name;
        this.signature = other.signature;
    }

    @Override
    public ClassEntry getClassEntry() {
        return this.classEntry;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Signature getSignature() {
        return this.signature;
    }

    @Override
    public String getClassName() {
        return this.classEntry.getName();
    }

    @Override
    public MethodEntry cloneToNewClass(ClassEntry classEntry) {
        return new MethodEntry(this, classEntry.getName());
    }

    public int hashCode() {
        return Utils.combineHashesOrdered(this.classEntry, this.name, this.signature);
    }

    public boolean equals(Object other) {
        return other instanceof MethodEntry && this.equals((MethodEntry)other);
    }

    public boolean equals(MethodEntry other) {
        return this.classEntry.equals(other.classEntry) && this.name.equals(other.name) && this.signature.equals(other.signature);
    }

    public String toString() {
        return this.classEntry.getName() + "." + this.name + this.signature;
    }
}

