/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.mapping;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import cuchaz.enigma.analysis.TranslationIndex;
import cuchaz.enigma.mapping.ArgumentEntry;
import cuchaz.enigma.mapping.BehaviorEntry;
import cuchaz.enigma.mapping.ClassEntry;
import cuchaz.enigma.mapping.ClassMapping;
import cuchaz.enigma.mapping.ClassNameReplacer;
import cuchaz.enigma.mapping.ConstructorEntry;
import cuchaz.enigma.mapping.Entry;
import cuchaz.enigma.mapping.FieldEntry;
import cuchaz.enigma.mapping.FieldMapping;
import cuchaz.enigma.mapping.LocalVariableEntry;
import cuchaz.enigma.mapping.Mappings;
import cuchaz.enigma.mapping.MethodEntry;
import cuchaz.enigma.mapping.MethodMapping;
import cuchaz.enigma.mapping.Signature;
import cuchaz.enigma.mapping.TranslationDirection;
import cuchaz.enigma.mapping.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class Translator {
    private TranslationDirection direction;
    private Map<String, ClassMapping> classes;
    private TranslationIndex index;
    private ClassNameReplacer classNameReplacer = className -> this.translateEntry(new ClassEntry(className)).getName();

    public Translator() {
        this.direction = null;
        this.classes = Maps.newHashMap();
        this.index = new TranslationIndex();
    }

    public Translator(TranslationDirection direction, Map<String, ClassMapping> classes, TranslationIndex index) {
        this.direction = direction;
        this.classes = classes;
        this.index = index;
    }

    public TranslationDirection getDirection() {
        return this.direction;
    }

    public TranslationIndex getTranslationIndex() {
        return this.index;
    }

    public <T extends Entry> T translateEntry(T entry) {
        if (entry instanceof ClassEntry) {
            return (T)this.translateEntry((ClassEntry)entry);
        }
        if (entry instanceof FieldEntry) {
            return (T)this.translateEntry((FieldEntry)entry);
        }
        if (entry instanceof MethodEntry) {
            return (T)this.translateEntry((MethodEntry)entry);
        }
        if (entry instanceof ConstructorEntry) {
            return (T)this.translateEntry((ConstructorEntry)entry);
        }
        if (entry instanceof ArgumentEntry) {
            return (T)this.translateEntry((ArgumentEntry)entry);
        }
        if (entry instanceof LocalVariableEntry) {
            return (T)this.translateEntry((LocalVariableEntry)entry);
        }
        throw new Error("Unknown entry type: " + entry.getClass().getName());
    }

    public <T extends Entry> String translate(T entry) {
        if (entry instanceof ClassEntry) {
            return this.translate((ClassEntry)entry);
        }
        if (entry instanceof FieldEntry) {
            return this.translate((FieldEntry)entry);
        }
        if (entry instanceof MethodEntry) {
            return this.translate((MethodEntry)entry);
        }
        if (entry instanceof ConstructorEntry) {
            return this.translate(entry);
        }
        if (entry instanceof ArgumentEntry) {
            return this.translate((ArgumentEntry)entry);
        }
        if (entry instanceof LocalVariableEntry) {
            return this.translate((LocalVariableEntry)entry);
        }
        throw new Error("Unknown entry type: " + entry.getClass().getName());
    }

    public String translate(LocalVariableEntry in) {
        LocalVariableEntry translated = this.translateEntry(in);
        if (translated.equals(in)) {
            return null;
        }
        return translated.getName();
    }

    public LocalVariableEntry translateEntry(LocalVariableEntry in) {
        return in;
    }

    public String translate(ClassEntry in) {
        ClassEntry translated = this.translateEntry(in);
        if (translated.equals(in)) {
            return null;
        }
        return translated.getName();
    }

    public String translateClass(String className) {
        return this.translate(new ClassEntry(className));
    }

    public ClassEntry translateEntry(ClassEntry in) {
        if (in.isInnerClass()) {
            List<ClassMapping> mappingsChain = this.getClassMappingChain(in);
            String[] obfClassNames = in.getName().split("\\$");
            StringBuilder buf = new StringBuilder();
            for (int i = 0; i < obfClassNames.length; ++i) {
                boolean isFirstClass = buf.length() == 0;
                String className = null;
                ClassMapping classMapping = mappingsChain.get(i);
                if (classMapping != null) {
                    className = this.direction.choose(classMapping.getDeobfName(), isFirstClass ? classMapping.getObfFullName() : classMapping.getObfSimpleName());
                }
                if (className == null) {
                    className = obfClassNames[i];
                }
                if (!isFirstClass) {
                    buf.append("$");
                }
                buf.append(className);
            }
            return new ClassEntry(buf.toString());
        }
        ClassMapping classMapping = this.classes.get(in.getName());
        if (classMapping == null) {
            return in;
        }
        return this.direction.choose(classMapping.getDeobfName() != null ? new ClassEntry(classMapping.getDeobfName()) : in, new ClassEntry(classMapping.getObfFullName()));
    }

    public String translate(FieldEntry in) {
        String translatedName;
        ClassMapping classMapping;
        ClassEntry resolvedClassEntry = this.index.resolveEntryClass(in);
        if (resolvedClassEntry != null && (classMapping = this.findClassMapping(resolvedClassEntry)) != null && (translatedName = this.direction.choose(classMapping.getDeobfFieldName(in.getName(), in.getType()), classMapping.getObfFieldName(in.getName(), this.translateType(in.getType())))) != null) {
            return translatedName;
        }
        return null;
    }

    public FieldEntry translateEntry(FieldEntry in) {
        String name = this.translate(in);
        if (name == null) {
            name = in.getName();
        }
        return new FieldEntry(this.translateEntry(in.getClassEntry()), name, this.translateType(in.getType()));
    }

    public String translate(MethodEntry in) {
        MethodMapping methodMapping;
        ClassMapping classMapping;
        ClassEntry resolvedClassEntry = this.index.resolveEntryClass(in, true);
        if (resolvedClassEntry != null && (classMapping = this.findClassMapping(resolvedClassEntry)) != null && (methodMapping = this.direction.choose(classMapping.getMethodByObf(in.getName(), in.getSignature()), classMapping.getMethodByDeobf(in.getName(), this.translateSignature(in.getSignature())))) != null) {
            return this.direction.choose(methodMapping.getDeobfName(), methodMapping.getObfName());
        }
        return null;
    }

    public MethodEntry translateEntry(MethodEntry in) {
        String name = this.translate(in);
        if (name == null) {
            name = in.getName();
        }
        return new MethodEntry(this.translateEntry(in.getClassEntry()), name, this.translateSignature(in.getSignature()));
    }

    public ConstructorEntry translateEntry(ConstructorEntry in) {
        if (in.isStatic()) {
            return new ConstructorEntry(this.translateEntry(in.getClassEntry()));
        }
        return new ConstructorEntry(this.translateEntry(in.getClassEntry()), this.translateSignature(in.getSignature()));
    }

    public BehaviorEntry translateEntry(BehaviorEntry in) {
        if (in instanceof MethodEntry) {
            return this.translateEntry((MethodEntry)in);
        }
        if (in instanceof ConstructorEntry) {
            return this.translateEntry((ConstructorEntry)in);
        }
        throw new Error("Wrong entry type!");
    }

    public String translate(ArgumentEntry in) {
        String classTranslate = this.translateArgument(in);
        if (classTranslate == null) {
            List<ClassEntry> ancestry = this.index.getAncestry(in.getClassEntry());
            for (ClassEntry entry : ancestry) {
                String result;
                ArgumentEntry motherArg = in.cloneToNewClass(entry);
                if (!this.index.entryExists(motherArg) || (result = this.translateArgument(motherArg)) == null) continue;
                return result;
            }
        }
        return classTranslate;
    }

    public String translateArgument(ArgumentEntry in) {
        MethodMapping methodMapping;
        ClassMapping classMapping;
        ClassEntry entry = in.getClassEntry();
        if (entry != null && (classMapping = this.findClassMapping(entry)) != null && (methodMapping = this.direction.choose(classMapping.getMethodByObf(in.getMethodName(), in.getMethodSignature()), classMapping.getMethodByDeobf(in.getMethodName(), this.translateSignature(in.getMethodSignature())))) != null) {
            return this.direction.choose(methodMapping.getDeobfArgumentName(in.getIndex()), methodMapping.getObfArgumentName(in.getIndex()));
        }
        return null;
    }

    public ArgumentEntry translateEntry(ArgumentEntry in) {
        String name = this.translate(in);
        if (name == null) {
            name = in.getName();
        }
        return new ArgumentEntry(this.translateEntry(in.getBehaviorEntry()), in.getIndex(), name);
    }

    public Type translateType(Type type) {
        return new Type(type, this.classNameReplacer);
    }

    public Signature translateSignature(Signature signature) {
        return new Signature(signature, this.classNameReplacer);
    }

    private ClassMapping findClassMapping(ClassEntry in) {
        List<ClassMapping> mappingChain = this.getClassMappingChain(in);
        return mappingChain.get(mappingChain.size() - 1);
    }

    private List<ClassMapping> getClassMappingChain(ClassEntry in) {
        String[] parts = in.getName().split("\\$");
        ArrayList<ClassMapping> mappingsChain = Lists.newArrayList();
        ClassMapping outerClassMapping = this.classes.get(parts[0]);
        mappingsChain.add(outerClassMapping);
        for (int i = 1; i < parts.length; ++i) {
            ClassMapping innerClassMapping = null;
            if (outerClassMapping != null) {
                innerClassMapping = this.direction.choose(outerClassMapping.getInnerClassByObfSimple(parts[i]), outerClassMapping.getInnerClassByDeobfThenObfSimple(parts[i]));
            }
            mappingsChain.add(innerClassMapping);
            outerClassMapping = innerClassMapping;
        }
        assert (mappingsChain.size() == parts.length);
        return mappingsChain;
    }

    public Mappings.EntryModifier getModifier(Entry entry) {
        ClassMapping classMapping = this.findClassMapping(entry.getClassEntry());
        if (classMapping != null && !entry.getName().equals("<clinit>")) {
            if (entry instanceof ClassEntry) {
                return classMapping.getModifier();
            }
            if (entry instanceof FieldEntry) {
                FieldMapping fieldMapping = classMapping.getFieldByObf(entry.getName(), ((FieldEntry)entry).getType());
                return fieldMapping != null ? fieldMapping.getModifier() : Mappings.EntryModifier.UNCHANGED;
            }
            if (entry instanceof BehaviorEntry) {
                MethodMapping methodMapping = classMapping.getMethodByObf(entry.getName(), ((BehaviorEntry)entry).getSignature());
                return methodMapping != null ? methodMapping.getModifier() : Mappings.EntryModifier.UNCHANGED;
            }
            throw new Error("Unknown entry type: " + entry.getClass().getName());
        }
        return Mappings.EntryModifier.UNCHANGED;
    }
}

