/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma;

import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.strobel.assembler.metadata.ITypeLoader;
import com.strobel.assembler.metadata.MetadataSystem;
import com.strobel.assembler.metadata.TypeDefinition;
import com.strobel.assembler.metadata.TypeReference;
import com.strobel.decompiler.DecompilerContext;
import com.strobel.decompiler.DecompilerSettings;
import com.strobel.decompiler.ITextOutput;
import com.strobel.decompiler.PlainTextOutput;
import com.strobel.decompiler.languages.java.JavaOutputVisitor;
import com.strobel.decompiler.languages.java.ast.AstBuilder;
import com.strobel.decompiler.languages.java.ast.CompilationUnit;
import com.strobel.decompiler.languages.java.ast.IAstVisitor;
import com.strobel.decompiler.languages.java.ast.InsertParenthesesVisitor;
import cuchaz.enigma.TranslatingTypeLoader;
import cuchaz.enigma.analysis.EntryReference;
import cuchaz.enigma.analysis.JarClassIterator;
import cuchaz.enigma.analysis.JarIndex;
import cuchaz.enigma.analysis.SourceIndex;
import cuchaz.enigma.analysis.SourceIndexVisitor;
import cuchaz.enigma.analysis.Token;
import cuchaz.enigma.bytecode.ClassProtectifier;
import cuchaz.enigma.bytecode.ClassPublifier;
import cuchaz.enigma.mapping.ArgumentEntry;
import cuchaz.enigma.mapping.ArgumentMapping;
import cuchaz.enigma.mapping.BehaviorEntry;
import cuchaz.enigma.mapping.ClassEntry;
import cuchaz.enigma.mapping.ClassMapping;
import cuchaz.enigma.mapping.ConstructorEntry;
import cuchaz.enigma.mapping.Entry;
import cuchaz.enigma.mapping.FieldEntry;
import cuchaz.enigma.mapping.FieldMapping;
import cuchaz.enigma.mapping.LocalVariableEntry;
import cuchaz.enigma.mapping.Mappings;
import cuchaz.enigma.mapping.MappingsChecker;
import cuchaz.enigma.mapping.MappingsRenamer;
import cuchaz.enigma.mapping.MethodEntry;
import cuchaz.enigma.mapping.MethodMapping;
import cuchaz.enigma.mapping.TranslationDirection;
import cuchaz.enigma.mapping.Translator;
import cuchaz.enigma.throwables.IllegalNameException;
import cuchaz.enigma.utils.Utils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import javassist.CtClass;
import javassist.bytecode.Descriptor;

public class Deobfuscator {
    private final JarFile jar;
    private final DecompilerSettings settings;
    private final JarIndex jarIndex;
    private final MappingsRenamer renamer;
    private final Map<TranslationDirection, Translator> translatorCache;
    private Mappings mappings;

    public Deobfuscator(JarFile jar) {
        this.jar = jar;
        this.jarIndex = new JarIndex();
        this.jarIndex.indexJar(this.jar, true);
        this.settings = DecompilerSettings.javaDefaults();
        this.settings.setMergeVariables(Utils.getSystemPropertyAsBoolean("enigma.mergeVariables", true));
        this.settings.setForceExplicitImports(Utils.getSystemPropertyAsBoolean("enigma.forceExplicitImports", true));
        this.settings.setForceExplicitTypeArguments(Utils.getSystemPropertyAsBoolean("enigma.forceExplicitTypeArguments", true));
        this.settings.setShowDebugLineNumbers(Utils.getSystemPropertyAsBoolean("enigma.showDebugLineNumbers", false));
        this.settings.setShowSyntheticMembers(Utils.getSystemPropertyAsBoolean("enigma.showSyntheticMembers", false));
        this.translatorCache = Maps.newTreeMap();
        this.renamer = new MappingsRenamer(this.jarIndex, null);
        this.setMappings(new Mappings());
    }

    public JarFile getJar() {
        return this.jar;
    }

    public String getJarName() {
        return this.jar.getName();
    }

    public JarIndex getJarIndex() {
        return this.jarIndex;
    }

    public Mappings getMappings() {
        return this.mappings;
    }

    public void setMappings(Mappings val) {
        this.setMappings(val, true);
    }

    public void setMappings(Mappings val, boolean warnAboutDrops) {
        if (val == null) {
            val = new Mappings();
        }
        MappingsChecker checker = new MappingsChecker(this.jarIndex);
        checker.dropBrokenMappings(val);
        if (warnAboutDrops) {
            for (Map.Entry<ClassEntry, ClassMapping> entry : checker.getDroppedClassMappings().entrySet()) {
                System.out.println("WARNING: Couldn't find class entry " + entry.getKey() + " (" + entry.getValue().getDeobfName() + ") in jar. Mapping was dropped.");
            }
            for (Map.Entry<ClassEntry, ClassMapping> entry : checker.getDroppedInnerClassMappings().entrySet()) {
                System.out.println("WARNING: Couldn't find inner class entry " + entry.getKey() + " (" + entry.getValue().getDeobfName() + ") in jar. Mapping was dropped.");
            }
            for (Map.Entry<Entry, Comparable<ClassMapping>> entry : checker.getDroppedFieldMappings().entrySet()) {
                System.out.println("WARNING: Couldn't find field entry " + entry.getKey() + " (" + ((FieldMapping)entry.getValue()).getDeobfName() + ") in jar. Mapping was dropped.");
            }
            for (Map.Entry<Entry, Comparable<ClassMapping>> entry : checker.getDroppedMethodMappings().entrySet()) {
                System.out.println("WARNING: Couldn't find behavior entry " + entry.getKey() + " (" + ((MethodMapping)entry.getValue()).getDeobfName() + ") in jar. Mapping was dropped.");
            }
        }
        this.mappings = val;
        this.renamer.setMappings(this.mappings);
        this.translatorCache.clear();
    }

    public Translator getTranslator(TranslationDirection direction) {
        return this.translatorCache.computeIfAbsent(direction, k -> this.mappings.getTranslator(direction, this.jarIndex.getTranslationIndex()));
    }

    public void getSeparatedClasses(List<ClassEntry> obfClasses, List<ClassEntry> deobfClasses) {
        for (ClassEntry obfClassEntry : this.jarIndex.getObfClassEntries()) {
            if (obfClassEntry.isInnerClass()) continue;
            ClassEntry deobfClassEntry = this.deobfuscateEntry(obfClassEntry);
            if (!deobfClassEntry.equals(obfClassEntry)) {
                deobfClasses.add(deobfClassEntry);
                continue;
            }
            if (obfClassEntry.getPackageName() != null) {
                deobfClasses.add(obfClassEntry);
                continue;
            }
            obfClasses.add(obfClassEntry);
        }
    }

    public TranslatingTypeLoader createTypeLoader() {
        return new TranslatingTypeLoader(this.jar, this.jarIndex, this.getTranslator(TranslationDirection.Obfuscating), this.getTranslator(TranslationDirection.Deobfuscating));
    }

    public CompilationUnit getSourceTree(String className) {
        String deobfClassName = className;
        ClassMapping classMapping = this.mappings.getClassByObf(className);
        if (classMapping != null && classMapping.getDeobfName() != null) {
            deobfClassName = classMapping.getDeobfName();
        }
        TranslatingTypeLoader loader = this.createTypeLoader();
        this.settings.setTypeLoader((ITypeLoader)loader);
        TypeReference type = new MetadataSystem((ITypeLoader)loader).lookupType(deobfClassName);
        if (type == null) {
            throw new Error(String.format("Unable to find type: %s (deobf: %s)\nTried class names: %s", className, deobfClassName, loader.getClassNamesToTry(deobfClassName)));
        }
        TypeDefinition resolvedType = type.resolve();
        DecompilerContext context = new DecompilerContext();
        context.setCurrentType(resolvedType);
        context.setSettings(this.settings);
        AstBuilder builder = new AstBuilder(context);
        builder.addType(resolvedType);
        builder.runTransformations(null);
        return builder.getCompilationUnit();
    }

    public SourceIndex getSourceIndex(CompilationUnit sourceTree, String source) {
        return this.getSourceIndex(sourceTree, source, null);
    }

    public SourceIndex getSourceIndex(CompilationUnit sourceTree, String source, Boolean ignoreBadTokens) {
        SourceIndex index = ignoreBadTokens != null ? new SourceIndex(source, ignoreBadTokens) : new SourceIndex(source);
        sourceTree.acceptVisitor((IAstVisitor)new SourceIndexVisitor(), (Object)index);
        for (Token token : index.referenceTokens()) {
            EntryReference<Entry, Entry> deobfReference = index.getDeobfReference(token);
            Object obfEntry = this.obfuscateEntry((Entry)deobfReference.entry);
            ClassEntry resolvedObfClassEntry = this.jarIndex.getTranslationIndex().resolveEntryClass((Entry)obfEntry);
            if (resolvedObfClassEntry == null || resolvedObfClassEntry.equals(obfEntry.getClassEntry())) continue;
            obfEntry = obfEntry.cloneToNewClass(resolvedObfClassEntry);
            deobfReference.entry = this.deobfuscateEntry((Entry)obfEntry);
            index.replaceDeobfReference(token, deobfReference);
        }
        return index;
    }

    public String getSource(CompilationUnit sourceTree) {
        StringWriter buf = new StringWriter();
        sourceTree.acceptVisitor((IAstVisitor)new InsertParenthesesVisitor(), null);
        sourceTree.acceptVisitor((IAstVisitor)new JavaOutputVisitor((ITextOutput)new PlainTextOutput((Writer)buf), this.settings), null);
        return buf.toString();
    }

    public void writeSources(File dirOut, ProgressListener progress) {
        HashSet classEntries = Sets.newHashSet();
        for (ClassEntry obfClassEntry : this.jarIndex.getObfClassEntries()) {
            if (obfClassEntry.isInnerClass()) continue;
            classEntries.add(obfClassEntry);
        }
        if (progress != null) {
            progress.init(classEntries.size(), "Decompiling classes...");
        }
        int i = 0;
        for (ClassEntry obfClassEntry : classEntries) {
            ClassEntry deobfClassEntry = this.deobfuscateEntry(new ClassEntry(obfClassEntry));
            if (progress != null) {
                progress.onProgress(i++, deobfClassEntry.toString());
            }
            try {
                String source = this.getSource(this.getSourceTree(obfClassEntry.getName()));
                File file = new File(dirOut, deobfClassEntry.getName().replace('.', '/') + ".java");
                file.getParentFile().mkdirs();
                OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(file), Charsets.UTF_8);
                Throwable throwable = null;
                try {
                    out.write(source);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (out == null) continue;
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    out.close();
                }
            }
            catch (Throwable t) {
                System.err.println("Unable to deobfuscate class " + deobfClassEntry + " (" + obfClassEntry + ")");
                t.printStackTrace(System.err);
            }
        }
        if (progress != null) {
            progress.onProgress(i, "Done!");
        }
    }

    private void addAllPotentialAncestors(Set<ClassEntry> classEntries, ClassEntry classObfEntry) {
        for (ClassEntry interfaceEntry : this.jarIndex.getTranslationIndex().getInterfaces(classObfEntry)) {
            if (!classEntries.add(interfaceEntry)) continue;
            this.addAllPotentialAncestors(classEntries, interfaceEntry);
        }
        ClassEntry superClassEntry = this.jarIndex.getTranslationIndex().getSuperclass(classObfEntry);
        if (superClassEntry != null && classEntries.add(superClassEntry)) {
            this.addAllPotentialAncestors(classEntries, superClassEntry);
        }
    }

    private boolean isBehaviorProvider(ClassEntry classObfEntry, BehaviorEntry behaviorEntry) {
        if (behaviorEntry instanceof MethodEntry) {
            MethodEntry methodEntry = (MethodEntry)behaviorEntry;
            HashSet<ClassEntry> classEntries = new HashSet<ClassEntry>();
            this.addAllPotentialAncestors(classEntries, classObfEntry);
            for (ClassEntry parentEntry : classEntries) {
                MethodEntry ancestorMethodEntry = new MethodEntry(parentEntry, methodEntry.getName(), methodEntry.getSignature());
                if (!this.jarIndex.containsObfBehavior(ancestorMethodEntry)) continue;
                return false;
            }
        }
        return true;
    }

    public void rebuildMethodNames(ProgressListener progress) {
        Entry obfEntry;
        int i = 0;
        HashMap<ClassMapping, Map<Entry, String>> renameClassMap = new HashMap<ClassMapping, Map<Entry, String>>();
        progress.init(this.getMappings().classes().size() * 3, "Rebuilding method names");
        for (ClassMapping classMapping : Lists.newArrayList(this.getMappings().classes())) {
            progress.onProgress(i++, classMapping.getDeobfName());
            this.rebuildMethodNames(classMapping, renameClassMap);
            for (ClassMapping classMapping2 : classMapping.innerClasses()) {
                this.rebuildMethodNames(classMapping2, renameClassMap);
            }
        }
        for (Map.Entry entry : renameClassMap.entrySet()) {
            progress.onProgress(i++, ((ClassMapping)entry.getKey()).getDeobfName());
            for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                obfEntry = (Entry)entry2.getKey();
                this.removeMapping(obfEntry);
            }
        }
        for (Map.Entry entry : renameClassMap.entrySet()) {
            progress.onProgress(i++, ((ClassMapping)entry.getKey()).getDeobfName());
            for (Map.Entry entry3 : ((Map)entry.getValue()).entrySet()) {
                obfEntry = (Entry)entry3.getKey();
                String name = (String)entry3.getValue();
                try {
                    this.rename(obfEntry, name);
                }
                catch (IllegalNameException exception) {
                    System.out.println("WARNING: " + exception.getMessage());
                }
            }
        }
    }

    private void rebuildMethodNames(ClassMapping classMapping, Map<ClassMapping, Map<Entry, String>> renameClassMap) {
        HashMap<Entry, String> renameEntries = new HashMap<Entry, String>();
        for (MethodMapping methodMapping : Lists.newArrayList(classMapping.methods())) {
            BehaviorEntry obfEntry;
            ClassEntry classObfEntry = classMapping.getObfEntry();
            if (!this.isBehaviorProvider(classObfEntry, obfEntry = methodMapping.getObfEntry(classObfEntry))) continue;
            if (this.hasDeobfuscatedName(obfEntry) && !(obfEntry instanceof ConstructorEntry) && !methodMapping.getDeobfName().equals(methodMapping.getObfName())) {
                renameEntries.put(obfEntry, methodMapping.getDeobfName());
            }
            for (ArgumentMapping argumentMapping : Lists.newArrayList(methodMapping.arguments())) {
                ArgumentEntry argObfEntry = argumentMapping.getObfEntry(obfEntry);
                if (!this.hasDeobfuscatedName(argObfEntry)) continue;
                renameEntries.put(argObfEntry, this.deobfuscateEntry(argObfEntry).getName());
            }
        }
        renameClassMap.put(classMapping, renameEntries);
    }

    public void writeJar(File out, ProgressListener progress) {
        this.transformJar(out, progress, this.createTypeLoader()::transformClass);
    }

    public void protectifyJar(File out, ProgressListener progress) {
        this.transformJar(out, progress, ClassProtectifier::protectify);
    }

    public void publifyJar(File out, ProgressListener progress) {
        this.transformJar(out, progress, ClassPublifier::publify);
    }

    public void transformJar(File out, ProgressListener progress, ClassTransformer transformer) {
        try (JarOutputStream outJar = new JarOutputStream(new FileOutputStream(out));){
            if (progress != null) {
                progress.init(JarClassIterator.getClassEntries(this.jar).size(), "Transforming classes...");
            }
            int i = 0;
            for (CtClass c : JarClassIterator.classes(this.jar)) {
                if (progress != null) {
                    progress.onProgress(i++, c.getName());
                }
                try {
                    c = transformer.transform(c);
                    outJar.putNextEntry(new JarEntry(c.getName().replace('.', '/') + ".class"));
                    outJar.write(c.toBytecode());
                    outJar.closeEntry();
                }
                catch (Throwable t) {
                    throw new Error("Unable to transform class " + c.getName(), t);
                }
            }
            if (progress != null) {
                progress.onProgress(i, "Done!");
            }
            outJar.close();
        }
        catch (IOException ex) {
            throw new Error("Unable to write to Jar file!");
        }
    }

    public <T extends Entry> T obfuscateEntry(T deobfEntry) {
        if (deobfEntry == null) {
            return null;
        }
        return this.getTranslator(TranslationDirection.Obfuscating).translateEntry(deobfEntry);
    }

    public <T extends Entry> T deobfuscateEntry(T obfEntry) {
        if (obfEntry == null) {
            return null;
        }
        return this.getTranslator(TranslationDirection.Deobfuscating).translateEntry(obfEntry);
    }

    public <E extends Entry, C extends Entry> EntryReference<E, C> obfuscateReference(EntryReference<E, C> deobfReference) {
        if (deobfReference == null) {
            return null;
        }
        return new EntryReference(this.obfuscateEntry((Entry)deobfReference.entry), this.obfuscateEntry((Entry)deobfReference.context), deobfReference);
    }

    public <E extends Entry, C extends Entry> EntryReference<E, C> deobfuscateReference(EntryReference<E, C> obfReference) {
        if (obfReference == null) {
            return null;
        }
        return new EntryReference(this.deobfuscateEntry((Entry)obfReference.entry), this.deobfuscateEntry((Entry)obfReference.context), obfReference);
    }

    public boolean isObfuscatedIdentifier(Entry obfEntry) {
        return this.isObfuscatedIdentifier(obfEntry, false);
    }

    public boolean isObfuscatedIdentifier(Entry obfEntry, boolean hack) {
        if (obfEntry instanceof MethodEntry) {
            MethodEntry obfMethodEntry = (MethodEntry)obfEntry;
            String name = obfMethodEntry.getName();
            String sig = obfMethodEntry.getSignature().toString();
            if (name.equals("clone") && sig.equals("()Ljava/lang/Object;")) {
                return false;
            }
            if (name.equals("equals") && sig.equals("(Ljava/lang/Object;)Z")) {
                return false;
            }
            if (name.equals("finalize") && sig.equals("()V")) {
                return false;
            }
            if (name.equals("getClass") && sig.equals("()Ljava/lang/Class;")) {
                return false;
            }
            if (name.equals("hashCode") && sig.equals("()I")) {
                return false;
            }
            if (name.equals("notify") && sig.equals("()V")) {
                return false;
            }
            if (name.equals("notifyAll") && sig.equals("()V")) {
                return false;
            }
            if (name.equals("toString") && sig.equals("()Ljava/lang/String;")) {
                return false;
            }
            if (name.equals("wait") && sig.equals("()V")) {
                return false;
            }
            if (name.equals("wait") && sig.equals("(J)V")) {
                return false;
            }
            if (name.equals("wait") && sig.equals("(JI)V")) {
                return false;
            }
            if (hack && this.jarIndex.containsObfEntry(obfEntry.getClassEntry())) {
                return true;
            }
        }
        return this.jarIndex.containsObfEntry(obfEntry);
    }

    public boolean isRenameable(EntryReference<Entry, Entry> obfReference, boolean activeHack) {
        return obfReference.isNamed() && this.isObfuscatedIdentifier(obfReference.getNameableEntry(), activeHack);
    }

    public boolean isRenameable(EntryReference<Entry, Entry> obfReference) {
        return this.isRenameable(obfReference, false);
    }

    public boolean hasDeobfuscatedName(Entry obfEntry) {
        Translator translator = this.getTranslator(TranslationDirection.Deobfuscating);
        if (obfEntry instanceof ClassEntry) {
            ClassEntry obfClass = (ClassEntry)obfEntry;
            List<ClassMapping> mappingChain = this.mappings.getClassMappingChain(obfClass);
            ClassMapping classMapping = mappingChain.get(mappingChain.size() - 1);
            return classMapping != null && classMapping.getDeobfName() != null;
        }
        if (obfEntry instanceof FieldEntry) {
            return translator.translate((FieldEntry)obfEntry) != null;
        }
        if (obfEntry instanceof MethodEntry) {
            return translator.translate((MethodEntry)obfEntry) != null;
        }
        if (obfEntry instanceof ConstructorEntry) {
            return false;
        }
        if (obfEntry instanceof ArgumentEntry) {
            return translator.translate((ArgumentEntry)obfEntry) != null;
        }
        if (obfEntry instanceof LocalVariableEntry) {
            return false;
        }
        throw new Error("Unknown entry type: " + obfEntry.getClass().getName());
    }

    public void rename(Entry obfEntry, String newName) {
        this.rename(obfEntry, newName, true);
    }

    public void rename(Entry obfEntry, String newName, boolean clearCache) {
        if (obfEntry instanceof ClassEntry) {
            this.renamer.setClassName((ClassEntry)obfEntry, Descriptor.toJvmName((String)newName));
        } else if (obfEntry instanceof FieldEntry) {
            this.renamer.setFieldName((FieldEntry)obfEntry, newName);
        } else if (obfEntry instanceof MethodEntry) {
            this.renamer.setMethodTreeName((MethodEntry)obfEntry, newName);
        } else {
            if (obfEntry instanceof ConstructorEntry) {
                throw new IllegalArgumentException("Cannot rename constructors");
            }
            if (obfEntry instanceof ArgumentEntry) {
                this.renamer.setArgumentTreeName((ArgumentEntry)obfEntry, newName);
            } else if (!(obfEntry instanceof LocalVariableEntry)) {
                throw new Error("Unknown entry type: " + obfEntry.getClass().getName());
            }
        }
        if (clearCache) {
            this.translatorCache.clear();
        }
    }

    public void removeMapping(Entry obfEntry) {
        if (obfEntry instanceof ClassEntry) {
            this.renamer.removeClassMapping((ClassEntry)obfEntry);
        } else if (obfEntry instanceof FieldEntry) {
            this.renamer.removeFieldMapping((FieldEntry)obfEntry);
        } else if (obfEntry instanceof MethodEntry) {
            this.renamer.removeMethodTreeMapping((MethodEntry)obfEntry);
        } else {
            if (obfEntry instanceof ConstructorEntry) {
                throw new IllegalArgumentException("Cannot rename constructors");
            }
            if (obfEntry instanceof ArgumentEntry) {
                this.renamer.removeArgumentMapping((ArgumentEntry)obfEntry);
            } else {
                throw new Error("Unknown entry type: " + obfEntry);
            }
        }
        this.translatorCache.clear();
    }

    public void markAsDeobfuscated(Entry obfEntry) {
        if (obfEntry instanceof ClassEntry) {
            this.renamer.markClassAsDeobfuscated((ClassEntry)obfEntry);
        } else if (obfEntry instanceof FieldEntry) {
            this.renamer.markFieldAsDeobfuscated((FieldEntry)obfEntry);
        } else if (obfEntry instanceof MethodEntry) {
            this.renamer.markMethodTreeAsDeobfuscated((MethodEntry)obfEntry);
        } else {
            if (obfEntry instanceof ConstructorEntry) {
                throw new IllegalArgumentException("Cannot rename constructors");
            }
            if (obfEntry instanceof ArgumentEntry) {
                this.renamer.markArgumentAsDeobfuscated((ArgumentEntry)obfEntry);
            } else if (!(obfEntry instanceof LocalVariableEntry)) {
                throw new Error("Unknown entry type: " + obfEntry);
            }
        }
        this.translatorCache.clear();
    }

    public void changeModifier(Entry entry, Mappings.EntryModifier modifierEntry) {
        Entry obfEntry = this.obfuscateEntry(entry);
        if (obfEntry instanceof ClassEntry) {
            this.renamer.setClassModifier((ClassEntry)obfEntry, modifierEntry);
        } else if (obfEntry instanceof FieldEntry) {
            this.renamer.setFieldModifier((FieldEntry)obfEntry, modifierEntry);
        } else if (obfEntry instanceof BehaviorEntry) {
            this.renamer.setMethodModifier((BehaviorEntry)obfEntry, modifierEntry);
        } else {
            throw new Error("Unknown entry type: " + obfEntry);
        }
    }

    public Mappings.EntryModifier getModifier(Entry obEntry) {
        Entry entry = this.obfuscateEntry(obEntry);
        if (entry != null) {
            obEntry = entry;
        }
        return this.getTranslator(TranslationDirection.Deobfuscating).getModifier(obEntry);
    }

    public static interface ClassTransformer {
        public CtClass transform(CtClass var1) throws Exception;
    }

    public static interface ProgressListener {
        public void init(int var1, String var2);

        public void onProgress(int var1, String var2);
    }
}

