/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.analysis;

import java.lang.reflect.Modifier;
import javassist.CtBehavior;
import javassist.CtField;

public enum Access {
    PUBLIC,
    PROTECTED,
    PACKAGE,
    PRIVATE;


    public static Access get(CtBehavior behavior) {
        return Access.get(behavior.getModifiers());
    }

    public static Access get(CtField field) {
        return Access.get(field.getModifiers());
    }

    public static Access get(int modifiers) {
        boolean isPublic = Modifier.isPublic(modifiers);
        boolean isProtected = Modifier.isProtected(modifiers);
        boolean isPrivate = Modifier.isPrivate(modifiers);
        if (isPublic && !isProtected && !isPrivate) {
            return PUBLIC;
        }
        if (!isPublic && isProtected && !isPrivate) {
            return PROTECTED;
        }
        if (!isPublic && !isProtected && isPrivate) {
            return PRIVATE;
        }
        if (!(isPublic || isProtected || isPrivate)) {
            return PACKAGE;
        }
        return PUBLIC;
    }
}

