/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.analysis;

import com.google.common.collect.Sets;
import cuchaz.enigma.analysis.Access;
import cuchaz.enigma.analysis.EntryReference;
import cuchaz.enigma.analysis.JarIndex;
import cuchaz.enigma.analysis.ReferenceTreeNode;
import cuchaz.enigma.mapping.BehaviorEntry;
import cuchaz.enigma.mapping.Translator;
import java.util.HashSet;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class BehaviorReferenceTreeNode
extends DefaultMutableTreeNode
implements ReferenceTreeNode<BehaviorEntry, BehaviorEntry> {
    private Translator deobfuscatingTranslator;
    private BehaviorEntry entry;
    private EntryReference<BehaviorEntry, BehaviorEntry> reference;
    private Access access;

    public BehaviorReferenceTreeNode(Translator deobfuscatingTranslator, BehaviorEntry entry) {
        this.deobfuscatingTranslator = deobfuscatingTranslator;
        this.entry = entry;
        this.reference = null;
    }

    public BehaviorReferenceTreeNode(Translator deobfuscatingTranslator, EntryReference<BehaviorEntry, BehaviorEntry> reference, Access access) {
        this.deobfuscatingTranslator = deobfuscatingTranslator;
        this.entry = (BehaviorEntry)reference.entry;
        this.reference = reference;
        this.access = access;
    }

    @Override
    public BehaviorEntry getEntry() {
        return this.entry;
    }

    @Override
    public EntryReference<BehaviorEntry, BehaviorEntry> getReference() {
        return this.reference;
    }

    @Override
    public String toString() {
        if (this.reference != null) {
            return String.format("%s (%s)", new Object[]{this.deobfuscatingTranslator.translateEntry((BehaviorEntry)this.reference.context), this.access});
        }
        return this.deobfuscatingTranslator.translateEntry(this.entry).toString();
    }

    public void load(JarIndex index, boolean recurse) {
        for (EntryReference<BehaviorEntry, BehaviorEntry> reference : index.getBehaviorReferences(this.entry)) {
            this.add(new BehaviorReferenceTreeNode(this.deobfuscatingTranslator, reference, index.getAccess(this.entry)));
        }
        if (recurse && this.children != null) {
            for (EntryReference<BehaviorEntry, BehaviorEntry> child : this.children) {
                if (!(child instanceof BehaviorReferenceTreeNode)) continue;
                BehaviorReferenceTreeNode node = (BehaviorReferenceTreeNode)((Object)child);
                HashSet ancestors = Sets.newHashSet();
                TreeNode n = node;
                while (n.getParent() != null) {
                    if (!((n = n.getParent()) instanceof BehaviorReferenceTreeNode)) continue;
                    ancestors.add(((BehaviorReferenceTreeNode)n).getEntry());
                }
                if (ancestors.contains(node.getEntry())) continue;
                node.load(index, true);
            }
        }
    }
}

