/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.analysis;

import com.google.common.collect.Lists;
import cuchaz.enigma.analysis.TranslationIndex;
import cuchaz.enigma.mapping.ClassEntry;
import cuchaz.enigma.mapping.Translator;
import java.util.ArrayList;
import javax.swing.tree.DefaultMutableTreeNode;

public class ClassInheritanceTreeNode
extends DefaultMutableTreeNode {
    private Translator deobfuscatingTranslator;
    private String obfClassName;

    public ClassInheritanceTreeNode(Translator deobfuscatingTranslator, String obfClassName) {
        this.deobfuscatingTranslator = deobfuscatingTranslator;
        this.obfClassName = obfClassName;
    }

    public static ClassInheritanceTreeNode findNode(ClassInheritanceTreeNode node, ClassEntry entry) {
        if (node.getObfClassName().equals(entry.getName())) {
            return node;
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            ClassInheritanceTreeNode foundNode = ClassInheritanceTreeNode.findNode((ClassInheritanceTreeNode)node.getChildAt(i), entry);
            if (foundNode == null) continue;
            return foundNode;
        }
        return null;
    }

    public String getObfClassName() {
        return this.obfClassName;
    }

    public String getDeobfClassName() {
        return this.deobfuscatingTranslator.translateClass(this.obfClassName);
    }

    @Override
    public String toString() {
        String deobfClassName = this.getDeobfClassName();
        if (deobfClassName != null) {
            return deobfClassName;
        }
        return this.obfClassName;
    }

    public void load(TranslationIndex ancestries, boolean recurse) {
        ArrayList nodes = Lists.newArrayList();
        for (ClassEntry subclassEntry : ancestries.getSubclass(new ClassEntry(this.obfClassName))) {
            nodes.add(new ClassInheritanceTreeNode(this.deobfuscatingTranslator, subclassEntry.getName()));
        }
        nodes.forEach(this::add);
        if (recurse) {
            for (ClassInheritanceTreeNode node : nodes) {
                node.load(ancestries, true);
            }
        }
    }
}

